/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedFlowable<T>
extends Flowable<T>
implements RxInstrumentedComponent {
    private final Publisher<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedFlowable(Publisher<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (!(s instanceof FlowableSubscriber)) {
            throw new IllegalArgumentException("Subscriber must be an instance of FlowableSubscriber");
        }
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.subscribe(s);
        }
    }
}

