/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.refresh;

import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Write;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.Map;
import java.util.Set;

@Endpoint(value="refresh")
public class RefreshEndpoint {
    private final Environment environment;
    private final ApplicationEventPublisher<RefreshEvent> eventPublisher;

    public RefreshEndpoint(Environment environment, ApplicationEventPublisher<RefreshEvent> eventPublisher) {
        this.environment = environment;
        this.eventPublisher = eventPublisher;
    }

    @Write
    public String[] refresh(@Nullable Boolean force) {
        if (force != null && force.booleanValue()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent());
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Map changes = this.environment.refreshAndDiff();
        if (!changes.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent(changes));
        }
        Set keys = changes.keySet();
        return keys.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }
}

