/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.stop;

import io.micronaut.context.ApplicationContext;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Write;
import java.util.LinkedHashMap;
import java.util.Map;

@Endpoint(id="stop", defaultEnabled=false)
public class ServerStopEndpoint {
    private static final long WAIT_BEFORE_STOP = 500L;
    private final ApplicationContext context;
    private final Map<String, String> message;

    ServerStopEndpoint(ApplicationContext context) {
        this.context = context;
        this.message = new LinkedHashMap<String, String>(1);
        this.message.put("message", "Server shutdown started");
    }

    @Write(consumes={})
    public Object stop() {
        try {
            Map<String, String> map = this.message;
            return map;
        }
        finally {
            Thread thread = new Thread(this::stopServer);
            thread.setContextClassLoader(this.getClass().getClassLoader());
            thread.start();
        }
    }

    private void stopServer() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.context.stop();
    }
}

