/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator;

import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.reactivestreams.Publisher;

public abstract class AbstractHealthIndicator<T>
implements HealthIndicator {
    protected ExecutorService executorService;
    protected HealthStatus healthStatus;

    @Inject
    public void setExecutorService(@Named(value="io") ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public Publisher<HealthResult> getResult() {
        if (this.executorService == null) {
            throw new IllegalStateException("I/O ExecutorService is null");
        }
        return new AsyncSingleResultPublisher(this.executorService, this::getHealthResult);
    }

    protected abstract T getHealthInformation();

    protected HealthResult getHealthResult() {
        HealthResult.Builder builder = HealthResult.builder(this.getName());
        try {
            builder.details(this.getHealthInformation());
            builder.status(this.healthStatus);
        }
        catch (Exception e) {
            builder.status(HealthStatus.DOWN);
            builder.exception(e);
        }
        return builder.build();
    }

    protected abstract String getName();
}

