/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.beans;

import io.micronaut.context.BeanContext;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.beans.BeanDefinitionDataCollector;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Endpoint(value="beans")
public class BeansEndpoint {
    private BeanContext beanContext;
    private BeanDefinitionDataCollector beanDefinitionDataCollector;

    public BeansEndpoint(BeanContext beanContext, BeanDefinitionDataCollector beanDefinitionDataCollector) {
        this.beanContext = beanContext;
        this.beanDefinitionDataCollector = beanDefinitionDataCollector;
    }

    @Read
    public Single getBeans() {
        List<BeanDefinition<?>> beanDefinitions = this.beanContext.getAllBeanDefinitions().stream().sorted(Comparator.comparing(bd -> bd.getClass().getName())).collect(Collectors.toList());
        return Flowable.fromPublisher(this.beanDefinitionDataCollector.getData(beanDefinitions)).first(Collections.emptyMap());
    }
}

