/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.condition.TrueCondition;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationDefaultValuesProvider;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueProvider;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.annotation.ReflectionConfig;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class AnnotationMetadataSupport {
    private static final Map<String, Map<CharSequence, Object>> CORE_ANNOTATION_DEFAULTS;
    private static final Map<String, Map<CharSequence, Object>> ANNOTATION_DEFAULTS;
    private static final Map<String, String> REPEATABLE_ANNOTATIONS_CONTAINERS;
    private static final Map<String, String> CORE_REPEATABLE_ANNOTATIONS_CONTAINERS;
    private static final Map<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>> ANNOTATION_PROXY_CACHE;
    private static final Map<String, Class<? extends Annotation>> ANNOTATION_TYPES;
    public static final AnnotationDefaultValuesProvider ANNOTATION_DEFAULT_VALUES_PROVIDER;

    @Internal
    public static List<Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>>> getCoreRepeatableAnnotations() {
        return Arrays.asList(new AbstractMap.SimpleEntry<Class<Indexed>, Class<Indexes>>(Indexed.class, Indexes.class), new AbstractMap.SimpleEntry<Class<Requires>, Class<Requirements>>(Requires.class, Requirements.class), new AbstractMap.SimpleEntry<Class<AliasFor>, Class<Aliases>>(AliasFor.class, Aliases.class), new AbstractMap.SimpleEntry<Class<Property>, Class<PropertySource>>(Property.class, PropertySource.class), new AbstractMap.SimpleEntry<Class<ReflectionConfig>, Class<ReflectionConfig.ReflectionConfigList>>(ReflectionConfig.class, ReflectionConfig.ReflectionConfigList.class));
    }

    @Internal
    public static Map<String, String> getCoreRepeatableAnnotationsContainers() {
        return CORE_REPEATABLE_ANNOTATIONS_CONTAINERS;
    }

    @Internal
    public static Map<String, Map<CharSequence, Object>> getCoreAnnotationDefaults() {
        return CORE_ANNOTATION_DEFAULTS;
    }

    @NonNull
    public static Map<CharSequence, Object> getDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.getOrDefault(annotation, Collections.emptyMap());
    }

    @Nullable
    public static Map<CharSequence, Object> getDefaultValuesOrNull(String annotation) {
        return ANNOTATION_DEFAULTS.get(annotation);
    }

    @Internal
    public static String getRepeatableAnnotation(String annotation) {
        return REPEATABLE_ANNOTATIONS_CONTAINERS.get(annotation);
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        return AnnotationMetadataSupport.getAnnotationType(name, AnnotationMetadataSupport.class.getClassLoader());
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name, ClassLoader classLoader) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        Class aClass = ClassUtils.forName((String)name, (ClassLoader)classLoader).orElse(null);
        if (aClass != null && Annotation.class.isAssignableFrom(aClass)) {
            ANNOTATION_TYPES.put(name, aClass);
            return Optional.of(aClass);
        }
        return Optional.empty();
    }

    static Optional<Class<? extends Annotation>> getRegisteredAnnotationType(String name) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static Map<CharSequence, Object> getDefaultValues(Class<? extends Annotation> annotation) {
        return AnnotationMetadataSupport.getDefaultValues(annotation.getName());
    }

    static boolean hasDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.containsKey(annotation);
    }

    static void registerDefaultValues(String annotation, Map<CharSequence, Object> defaultValues) {
        if (StringUtils.isNotEmpty((CharSequence)annotation) && CollectionUtils.isNotEmpty(defaultValues)) {
            ANNOTATION_DEFAULTS.put(annotation, defaultValues);
        }
    }

    static void registerDefaultValues(AnnotationClassValue<?> annotation, Map<CharSequence, Object> defaultValues) {
        if (defaultValues != null) {
            AnnotationMetadataSupport.registerDefaultValues(annotation.getName(), defaultValues);
        }
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    static void registerAnnotationType(AnnotationClassValue<?> annotationClassValue) {
        Class aClass;
        String name = annotationClassValue.getName();
        if (!ANNOTATION_TYPES.containsKey(name) && (aClass = (Class)annotationClassValue.getType().orElse(null)) != null && Annotation.class.isAssignableFrom(aClass)) {
            ANNOTATION_TYPES.put(name, aClass);
        }
    }

    @Internal
    static void registerRepeatableAnnotations(Map<String, String> repeatableAnnotations) {
        REPEATABLE_ANNOTATIONS_CONTAINERS.putAll(repeatableAnnotations);
    }

    @Internal
    static void registerRepeatableAnnotation(@NonNull String repeatable, @NonNull String repeatableContainer) {
        REPEATABLE_ANNOTATIONS_CONTAINERS.put(repeatable, repeatableContainer);
    }

    static Optional<Constructor<InvocationHandler>> getProxyClass(Class<? extends Annotation> annotation) {
        return ANNOTATION_PROXY_CACHE.computeIfAbsent(annotation, aClass -> {
            Class<?> proxyClass = Proxy.getProxyClass(annotation.getClassLoader(), annotation, AnnotationValueProvider.class);
            return ReflectionUtils.findConstructor(proxyClass, (Class[])new Class[]{InvocationHandler.class});
        });
    }

    @Internal
    public static <T extends Annotation> T buildAnnotation(Class<T> annotationClass, @Nullable AnnotationValue<T> annotationValue) {
        Optional<Constructor<InvocationHandler>> proxyClass = AnnotationMetadataSupport.getProxyClass(annotationClass);
        if (proxyClass.isPresent()) {
            HashMap<CharSequence, Object> values = new HashMap<CharSequence, Object>(AnnotationMetadataSupport.getDefaultValues(annotationClass));
            if (annotationValue != null) {
                annotationValue.getValues().forEach((key, o) -> values.put(key.toString(), o));
            }
            int hashCode = AnnotationUtil.calculateHashCode(values);
            Optional instantiated = InstantiationUtils.tryInstantiate(proxyClass.get(), (Object[])new Object[]{new AnnotationProxyHandler<T>(hashCode, annotationClass, annotationValue)});
            if (instantiated.isPresent()) {
                return (T)((Annotation)instantiated.get());
            }
        }
        throw new AnnotationMetadataException("Failed to build annotation for type: " + annotationClass.getName());
    }

    static {
        ANNOTATION_DEFAULTS = new ConcurrentHashMap<String, Map<CharSequence, Object>>(20);
        REPEATABLE_ANNOTATIONS_CONTAINERS = new ConcurrentHashMap<String, String>(20);
        ANNOTATION_PROXY_CACHE = new ConcurrentHashMap<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>>(20);
        ANNOTATION_TYPES = new ConcurrentHashMap<String, Class<? extends Annotation>>(20);
        ANNOTATION_DEFAULT_VALUES_PROVIDER = new AnnotationDefaultValuesProvider(){

            public Map<CharSequence, Object> provide(String annotationName) {
                return AnnotationMetadataSupport.getDefaultValues(annotationName);
            }
        };
        Arrays.asList(Any.class, jakarta.annotation.Nullable.class, Nonnull.class, ReadableBytes.class, Format.class, Indexed.class, Bindable.class, DefaultScope.class, Internal.class, DefaultImplementation.class, Nullable.class, NonNull.class, PreDestroy.class, PostConstruct.class, Named.class, Singleton.class, Inject.class, Qualifier.class, Scope.class, Prototype.class, Executable.class, Bean.class, Primary.class, Value.class, Property.class, Provided.class, Requires.class, Secondary.class, Type.class, Context.class, EachBean.class, EachProperty.class, Configuration.class, ConfigurationProperties.class, ConfigurationBuilder.class, Introspected.class, Parameter.class, Requirements.class, Factory.class).forEach(ann -> ANNOTATION_TYPES.put(ann.getName(), (Class<? extends Annotation>)ann));
        HashMap coreAnnotationsDefaults = new HashMap(100);
        coreAnnotationsDefaults.put(Deprecated.class.getName(), Map.of("forRemoval", false));
        coreAnnotationsDefaults.put(Order.class.getName(), Map.of("value", 0));
        coreAnnotationsDefaults.put(Executable.class.getName(), Map.of("processOnStartup", false));
        coreAnnotationsDefaults.put(ConfigurationProperties.class.getName(), Map.of("cliPrefix", StringUtils.EMPTY_STRING_ARRAY, "excludes", StringUtils.EMPTY_STRING_ARRAY, "includes", StringUtils.EMPTY_STRING_ARRAY));
        coreAnnotationsDefaults.put(EachProperty.class.getName(), Map.of("excludes", StringUtils.EMPTY_STRING_ARRAY, "includes", StringUtils.EMPTY_STRING_ARRAY, "list", false));
        coreAnnotationsDefaults.put(ConfigurationReader.class.getName(), Map.of("excludes", StringUtils.EMPTY_STRING_ARRAY, "includes", StringUtils.EMPTY_STRING_ARRAY));
        coreAnnotationsDefaults.put(Bean.class.getName(), Map.of("typed", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES));
        coreAnnotationsDefaults.put(Requires.class.getName(), Map.ofEntries(Map.entry("beans", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("classes", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("condition", TrueCondition.class), Map.entry("entities", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("env", StringUtils.EMPTY_STRING_ARRAY), Map.entry("missing", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("missingBeans", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("missingClasses", StringUtils.EMPTY_STRING_ARRAY), Map.entry("missingConfigurations", StringUtils.EMPTY_STRING_ARRAY), Map.entry("notEnv", StringUtils.EMPTY_STRING_ARRAY), Map.entry("notOs", StringUtils.EMPTY_STRING_ARRAY), Map.entry("os", StringUtils.EMPTY_STRING_ARRAY), Map.entry("resources", StringUtils.EMPTY_STRING_ARRAY), Map.entry("sdk", "MICRONAUT")));
        coreAnnotationsDefaults.put(Replaces.class.getName(), Map.of("qualifier", Annotation.class));
        coreAnnotationsDefaults.put(Introspected.IntrospectionBuilder.class.getName(), Map.of("accessorStyle", new AnnotationValue("io.micronaut.core.annotation.AccessorsStyle", Map.of("writePrefixes", new String[]{""}), ANNOTATION_DEFAULT_VALUES_PROVIDER), "creatorMethod", "build"));
        coreAnnotationsDefaults.put(Introspected.class.getName(), Map.ofEntries(Map.entry("accessKind", new String[]{"METHOD"}), Map.entry("annotationMetadata", true), Map.entry("builder", new AnnotationValue("io.micronaut.core.annotation.Introspected$IntrospectionBuilder", Map.of(), ANNOTATION_DEFAULT_VALUES_PROVIDER)), Map.entry("classNames", StringUtils.EMPTY_STRING_ARRAY), Map.entry("classes", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("excludedAnnotations", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("excludes", StringUtils.EMPTY_STRING_ARRAY), Map.entry("includedAnnotations", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES), Map.entry("includes", StringUtils.EMPTY_STRING_ARRAY), Map.entry("indexed", AnnotationUtil.ZERO_ANNOTATION_VALUES), Map.entry("packages", StringUtils.EMPTY_STRING_ARRAY), Map.entry("visibility", new String[]{"DEFAULT"}), Map.entry("withPrefix", "with")));
        coreAnnotationsDefaults.put(MapFormat.class.getName(), Map.of("keyFormat", "HYPHENATED", "transformation", "NESTED"));
        coreAnnotationsDefaults.put(Parallel.class.getName(), Map.of("shutdownOnError", true));
        coreAnnotationsDefaults.put("io.micronaut.aop.constructor.TestConstructorAnn", Map.of());
        coreAnnotationsDefaults.put("io.micronaut.aop.AroundConstruct", Map.of());
        coreAnnotationsDefaults.put("io.micronaut.aop.InterceptorBinding", Map.of("bindMembers", false, "kind", "AROUND", "value", Annotation.class));
        coreAnnotationsDefaults.put("io.micronaut.aop.InterceptorBean", Map.of());
        coreAnnotationsDefaults.put("io.micronaut.aop.Around", Map.of("cacheableLazyTarget", false, "hotswap", false, "lazy", false, "proxyTarget", false, "proxyTargetMode", "ERROR"));
        coreAnnotationsDefaults.put("io.micronaut.aop.Introduction", Map.of("interfaces", AnnotationClassValue.ZERO_ANNOTATION_CLASS_VALUES));
        coreAnnotationsDefaults.put("io.micronaut.aop.Adapter", Map.of());
        coreAnnotationsDefaults.put("io.micronaut.validation.annotation.ValidatedElement", Map.of());
        coreAnnotationsDefaults.put(AccessorsStyle.class.getName(), Map.of("readPrefixes", new String[]{"get"}, "writePrefixes", new String[]{"set"}));
        CORE_ANNOTATION_DEFAULTS = Collections.unmodifiableMap(coreAnnotationsDefaults);
        ANNOTATION_DEFAULTS.putAll(CORE_ANNOTATION_DEFAULTS);
        LinkedHashMap<String, String> coreRepeatableAnnotationsContainers = new LinkedHashMap<String, String>();
        for (Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>> e : AnnotationMetadataSupport.getCoreRepeatableAnnotations()) {
            coreRepeatableAnnotationsContainers.put(e.getKey().getName(), e.getValue().getName());
        }
        coreRepeatableAnnotationsContainers.put("io.micronaut.aop.InterceptorBinding", "io.micronaut.aop.InterceptorBindingDefinitions");
        CORE_REPEATABLE_ANNOTATIONS_CONTAINERS = Collections.unmodifiableMap(coreRepeatableAnnotationsContainers);
        REPEATABLE_ANNOTATIONS_CONTAINERS.putAll(coreRepeatableAnnotationsContainers);
    }

    private static class AnnotationProxyHandler<A extends Annotation>
    implements InvocationHandler,
    AnnotationValueProvider<A> {
        private final int hashCode;
        private final Class<A> annotationClass;
        private final AnnotationValue<A> annotationValue;

        AnnotationProxyHandler(int hashCode, Class<A> annotationClass, @Nullable AnnotationValue<A> annotationValue) {
            this.hashCode = hashCode;
            this.annotationClass = annotationClass;
            this.annotationValue = annotationValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.annotationClass.isInstance(obj)) {
                return false;
            }
            Annotation other = (Annotation)this.annotationClass.cast(obj);
            AnnotationValue<?> otherValues = this.getAnnotationValues(other);
            if (this.annotationValue == null && otherValues == null) {
                return true;
            }
            if (this.annotationValue == null || otherValues == null) {
                return false;
            }
            return this.annotationValue.equals(otherValues);
        }

        private AnnotationValue<?> getAnnotationValues(Annotation other) {
            if (other instanceof AnnotationProxyHandler) {
                AnnotationProxyHandler handler = (AnnotationProxyHandler)((Object)other);
                return handler.annotationValue;
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if ((args == null || args.length == 0) && "hashCode".equals(name)) {
                return this.hashCode;
            }
            if (args != null && args.length == 1 && "equals".equals(name)) {
                return this.equals(args[0]);
            }
            if ("toString".equals(name)) {
                return this.annotationValue.toString();
            }
            if ("annotationType".equals(name)) {
                return this.annotationClass;
            }
            if (method.getReturnType() == AnnotationValue.class) {
                return this.annotationValue;
            }
            if (this.annotationValue != null && this.annotationValue.contains(name)) {
                return this.annotationValue.getRequiredValue(name, method.getReturnType());
            }
            return method.getDefaultValue();
        }

        @NonNull
        public AnnotationValue<A> annotationValue() {
            if (this.annotationValue != null) {
                return this.annotationValue;
            }
            return new AnnotationValue(this.annotationClass.getName());
        }
    }
}

