/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.bind;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.bind.ExecutableBeanContextBinder;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DefaultExecutableBeanContextBinder
implements ExecutableBeanContextBinder {
    public <T, R> BoundExecutable<T, R> bind(Executable<T, R> target, ArgumentBinderRegistry<BeanContext> registry, BeanContext source) throws UnsatisfiedArgumentException {
        return this.bind(target, source);
    }

    public <T, R> BoundExecutable<T, R> tryBind(Executable<T, R> target, ArgumentBinderRegistry<BeanContext> registry, BeanContext source) {
        Argument[] arguments = target.getArguments();
        if (arguments.length == 0) {
            return new ContextBoundExecutable<T, R>(target, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        Object[] bound = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            Optional v = argument.getAnnotationMetadata().stringValue(Value.class);
            if (v.isPresent() && source instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)source;
                bound[i] = applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElse(null);
                continue;
            }
            v = argument.getAnnotationMetadata().stringValue(Property.class, "name");
            if (v.isPresent() && source instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)source;
                bound[i] = applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElse(null);
                continue;
            }
            bound[i] = source.findBean(argument, DefaultExecutableBeanContextBinder.resolveQualifier(argument)).orElse(null);
        }
        return new ContextBoundExecutable<T, R>(target, bound);
    }

    @Override
    public <T, R> BoundExecutable<T, R> bind(Executable<T, R> target, BeanContext source) throws UnsatisfiedArgumentException {
        Argument[] arguments = target.getArguments();
        if (arguments.length == 0) {
            return new ContextBoundExecutable<T, R>(target, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        Object[] bound = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            Optional v = argument.getAnnotationMetadata().stringValue(Value.class);
            if (v.isPresent() && source instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)source;
                Optional finalV = v;
                bound[i] = applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElseThrow(() -> new UnsatisfiedArgumentException(argument, "Unresolvable property specified to @Value: " + (String)finalV.get()));
                continue;
            }
            v = argument.getAnnotationMetadata().stringValue(Property.class, "name");
            if (v.isPresent() && source instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)source;
                Optional finalV1 = v;
                bound[i] = applicationContext.getEnvironment().getProperty((String)v.get(), argument).orElseThrow(() -> new UnsatisfiedArgumentException(argument, "Unresolvable property specified to @Value: " + (String)finalV1.get()));
                continue;
            }
            bound[i] = source.findBean(argument, DefaultExecutableBeanContextBinder.resolveQualifier(argument)).orElseThrow(() -> new UnsatisfiedArgumentException(argument, "Unresolvable bean argument: " + String.valueOf(argument)));
        }
        return new ContextBoundExecutable<T, R>(target, bound);
    }

    private static <T> Qualifier<T> resolveQualifier(Argument<?> argument) {
        List qualifierTypes;
        AnnotationMetadata annotationMetadata = Objects.requireNonNull(argument, "Argument cannot be null").getAnnotationMetadata();
        boolean hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        List list = qualifierTypes = hasMetadata ? AnnotationUtil.findQualifierAnnotationsNames((AnnotationMetadata)annotationMetadata) : Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)qualifierTypes)) {
            if (qualifierTypes.size() == 1) {
                return Qualifiers.byAnnotation(annotationMetadata, (String)qualifierTypes.iterator().next());
            }
            Qualifier[] qualifiers = (Qualifier[])qualifierTypes.stream().map(type -> Qualifiers.byAnnotation(annotationMetadata, type)).toArray(Qualifier[]::new);
            return Qualifiers.byQualifiers(qualifiers);
        }
        return null;
    }

    private record ContextBoundExecutable<T, R>(Executable<T, R> target, Object[] bound) implements BoundExecutable<T, R>
    {
        public Executable<T, R> getTarget() {
            return this.target;
        }

        public R invoke(T instance) {
            return (R)this.target.invoke(instance, this.bound);
        }

        public Object[] getBoundArguments() {
            return this.bound;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextBoundExecutable that = (ContextBoundExecutable)o;
            return this.target.equals(that.target) && Arrays.equals(this.bound, that.bound);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.target);
            result = 31 * result + Arrays.hashCode(this.bound);
            return result;
        }

        @Override
        public String toString() {
            return "ContextBoundExecutable{target=" + String.valueOf(this.target) + ", bound=" + Arrays.toString(this.bound) + "}";
        }
    }
}

