/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.BeanResolutionTraceMode;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.InjectScope;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.ConfigurationPath;
import io.micronaut.context.exceptions.CircularDependencyException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.AnsiColour;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.CallableInjectionPoint;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.proxy.InterceptedBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractBeanResolutionContext
implements BeanResolutionContext {
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    protected final DefaultBeanContext context;
    protected final BeanDefinition<?> rootDefinition;
    protected final BeanResolutionContext.Path path;
    @NonNull
    private final BeanResolutionTraceMode traceMode;
    private final boolean traceEnabled;
    private Map<CharSequence, Object> attributes;
    private Qualifier<?> qualifier;
    private List<BeanRegistration<?>> dependentBeans;
    private BeanRegistration<?> dependentFactory;
    private ConfigurationPath configurationPath;

    @Internal
    protected AbstractBeanResolutionContext(DefaultBeanContext context, BeanDefinition<?> rootDefinition) {
        this.context = context;
        this.rootDefinition = rootDefinition;
        this.path = new DefaultPath();
        this.traceMode = context.traceMode;
        this.traceEnabled = rootDefinition != null && this.isTraceEnabled(rootDefinition.getBeanType().getTypeName(), context.tracePatterns);
    }

    @Override
    public ConfigurationPath getConfigurationPath() {
        if (this.configurationPath != null) {
            return this.configurationPath;
        }
        this.configurationPath = ConfigurationPath.newPath();
        return this.configurationPath;
    }

    @Override
    public ConfigurationPath setConfigurationPath(ConfigurationPath configurationPath) {
        ConfigurationPath old = this.configurationPath;
        this.configurationPath = configurationPath;
        return old;
    }

    @Override
    public void valueResolved(Argument<?> argument, Qualifier<?> qualifier, String property, Object value) {
        if (this.traceEnabled) {
            this.traceMode.getTracer().ifPresent(tracer -> tracer.traceValueResolved(this, argument, property, value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTraceEnabled(@NonNull String typeName, @NonNull Set<String> tracePatterns) {
        if (this.traceMode == BeanResolutionTraceMode.NONE) return false;
        if (tracePatterns.isEmpty()) return true;
        if (!tracePatterns.stream().anyMatch(typeName::matches)) return false;
        return true;
    }

    @Override
    public Object resolvePropertyValue(Argument<?> argument, String stringValue, String cliProperty, boolean isPlaceholder) {
        Optional value;
        ArgumentConversionContext conversionContext;
        ApplicationContext applicationContext = (ApplicationContext)((Object)this.context);
        Argument argumentType = argument;
        Class wrapperType = null;
        Class type = argument.getType();
        if (type == Optional.class) {
            wrapperType = Optional.class;
            argumentType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        } else if (type == OptionalInt.class) {
            wrapperType = OptionalInt.class;
            argumentType = Argument.INT;
        } else if (type == OptionalLong.class) {
            wrapperType = OptionalLong.class;
            argumentType = Argument.LONG;
        } else if (type == OptionalDouble.class) {
            wrapperType = OptionalDouble.class;
            argumentType = Argument.DOUBLE;
        }
        ArgumentConversionContext argumentConversionContext = conversionContext = wrapperType != null ? ConversionContext.of((Argument)argumentType) : ConversionContext.of((Argument)argument);
        if (isPlaceholder) {
            value = applicationContext.resolvePlaceholders(stringValue).flatMap(v -> applicationContext.getConversionService().convert(v, conversionContext));
        } else {
            value = applicationContext.getProperty(stringValue = this.substituteWildCards(stringValue), conversionContext);
            if (value.isEmpty() && cliProperty != null) {
                value = applicationContext.getProperty(cliProperty, conversionContext);
            }
        }
        if (this.traceEnabled) {
            String propertyName = stringValue;
            Object propertyValue = value.orElse(null);
            this.traceMode.getTracer().ifPresent(tracer -> tracer.traceValueResolved(this, argument, propertyName, propertyValue));
        }
        if (argument.isOptional()) {
            if (value.isEmpty()) {
                return value;
            }
            Object convertedOptional = value.get();
            if (convertedOptional instanceof Optional) {
                return convertedOptional;
            }
            return value;
        }
        if (wrapperType != null) {
            Object v2 = value.orElse(null);
            if (OptionalInt.class == wrapperType) {
                OptionalInt optionalInt;
                if (v2 instanceof Integer) {
                    Integer i = v2;
                    optionalInt = OptionalInt.of(i);
                } else {
                    optionalInt = OptionalInt.empty();
                }
                return optionalInt;
            }
            if (OptionalLong.class == wrapperType) {
                OptionalLong optionalLong;
                if (v2 instanceof Long) {
                    Long l = v2;
                    optionalLong = OptionalLong.of(l);
                } else {
                    optionalLong = OptionalLong.empty();
                }
                return optionalLong;
            }
            if (OptionalDouble.class == wrapperType) {
                OptionalDouble optionalDouble;
                if (v2 instanceof Double) {
                    Double d = v2;
                    optionalDouble = OptionalDouble.of(d);
                } else {
                    optionalDouble = OptionalDouble.empty();
                }
                return optionalDouble;
            }
        }
        if (value.isPresent()) {
            return value.get();
        }
        if (argument.isDeclaredNullable()) {
            return null;
        }
        String finalStringValue = stringValue;
        return argument.getAnnotationMetadata().getValue(Bindable.class, "defaultValue", argument).orElseThrow(() -> DependencyInjectionException.missingProperty(this, conversionContext, finalStringValue));
    }

    private String substituteWildCards(String valString) {
        ConfigurationPath configurationPath = this.getConfigurationPath();
        if (configurationPath.isNotEmpty()) {
            return configurationPath.resolveValue(valString);
        }
        return valString;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Object bean = this.context.getBean((BeanResolutionContext)this, beanType, qualifier);
        if (this.traceEnabled) {
            this.traceMode.getTracer().ifPresent(tracer -> {
                tracer.traceBeanResolved(this, beanType, qualifier, bean);
                String disabledBeanMessage = this.context.resolveDisabledBeanMessage(this, beanType, qualifier);
                if (disabledBeanMessage != null) {
                    tracer.traceBeanDisabled(this, beanType, qualifier, disabledBeanMessage);
                }
            });
        }
        return bean;
    }

    @Override
    @NonNull
    public <T> Collection<T> getBeansOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<T> beans = this.context.getBeansOfType(this, beanType, qualifier);
        if (this.traceEnabled) {
            this.traceBeanCollection(beanType, qualifier, beans);
        }
        return beans;
    }

    private <T> void traceBeanCollection(Argument<T> beanType, Qualifier<T> qualifier, Collection<T> beans) {
        this.traceMode.getTracer().ifPresent(tracer -> {
            for (Object bean : beans) {
                tracer.traceBeanResolved(this, beanType, qualifier, bean);
            }
            String disabledBeanMessage = this.context.resolveDisabledBeanMessage(this, beanType, qualifier);
            if (disabledBeanMessage != null) {
                tracer.traceBeanDisabled(this, beanType, qualifier, disabledBeanMessage);
            }
        });
    }

    @Override
    @NonNull
    public <T> Stream<T> streamOfType(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.context.streamOfType((BeanResolutionContext)this, beanType, qualifier);
    }

    @Override
    public <V> Map<String, V> mapOfType(Argument<V> beanType, Qualifier<V> qualifier) {
        Map<String, V> beanMap = this.context.mapOfType(this, beanType, qualifier);
        if (this.traceEnabled) {
            this.traceBeanCollection(beanType, qualifier, beanMap.values());
        }
        return beanMap;
    }

    @Override
    @NonNull
    public <T> Optional<T> findBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Optional resolved = this.context.findBean((BeanResolutionContext)this, beanType, qualifier);
        if (this.traceEnabled) {
            this.traceMode.getTracer().ifPresent(tracer -> {
                tracer.traceBeanResolved(this, beanType, qualifier, resolved.orElse(null));
                String disabledBeanMessage = this.context.resolveDisabledBeanMessage(this, beanType, qualifier);
                if (disabledBeanMessage != null) {
                    tracer.traceBeanDisabled(this, beanType, qualifier, disabledBeanMessage);
                }
            });
        }
        return resolved;
    }

    @Override
    @NonNull
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> registrations = this.context.getBeanRegistrations(this, beanType, qualifier);
        if (this.traceEnabled) {
            this.traceBeanCollection(beanType, qualifier, registrations.stream().map(BeanRegistration::getBean).collect(Collectors.toList()));
        }
        return registrations;
    }

    public void copyStateFrom(@NonNull AbstractBeanResolutionContext context) {
        this.path.addAll(context.path);
        this.qualifier = context.qualifier;
        if (context.attributes != null) {
            this.getAttributesOrCreate().putAll(context.attributes);
        }
    }

    @Override
    public <T> void addDependentBean(BeanRegistration<T> beanRegistration) {
        if (beanRegistration.getBeanDefinition() == this.rootDefinition) {
            return;
        }
        if (this.dependentBeans == null) {
            this.dependentBeans = new ArrayList(3);
        }
        this.dependentBeans.add(beanRegistration);
    }

    @Override
    public void destroyInjectScopedBeans() {
        CustomScope injectScope = this.context.getCustomScopeRegistry().findScope(InjectScope.class.getName()).orElse(null);
        if (injectScope instanceof LifeCycle) {
            LifeCycle cycle = (LifeCycle)((Object)injectScope);
            cycle.stop();
        }
    }

    @Override
    @NonNull
    public List<BeanRegistration<?>> getAndResetDependentBeans() {
        if (this.dependentBeans == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<?>> registrations = Collections.unmodifiableList(this.dependentBeans);
        this.dependentBeans = null;
        return registrations;
    }

    @Override
    public void markDependentAsFactory() {
        if (this.dependentBeans != null) {
            if (this.dependentBeans.isEmpty()) {
                return;
            }
            if (this.dependentBeans.size() != 1) {
                throw new IllegalStateException("Expected only one bean dependent!");
            }
            this.dependentFactory = this.dependentBeans.remove(0);
        }
    }

    @Override
    public BeanRegistration<?> getAndResetDependentFactoryBean() {
        BeanRegistration<?> result = this.dependentFactory;
        this.dependentFactory = null;
        return result;
    }

    @Override
    public List<BeanRegistration<?>> popDependentBeans() {
        List<BeanRegistration<?>> result = this.dependentBeans;
        this.dependentBeans = null;
        return result;
    }

    @Override
    public void pushDependentBeans(List<BeanRegistration<?>> dependentBeans) {
        if (this.dependentBeans != null && !this.dependentBeans.isEmpty()) {
            throw new IllegalStateException("Found existing dependent beans!");
        }
        this.dependentBeans = dependentBeans;
    }

    @Override
    public final BeanContext getContext() {
        return this.context;
    }

    @Override
    public final BeanDefinition getRootDefinition() {
        return this.rootDefinition;
    }

    @Override
    public final BeanResolutionContext.Path getPath() {
        return this.path;
    }

    @Override
    public final Object setAttribute(CharSequence key, Object value) {
        return this.getAttributesOrCreate().put(key, value);
    }

    @Override
    public final Object getAttribute(CharSequence key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public final Object removeAttribute(CharSequence key) {
        if (this.attributes != null && key != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    @Override
    public Map<CharSequence, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<CharSequence, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    @Nullable
    public Qualifier<?> getCurrentQualifier() {
        return this.qualifier;
    }

    @Override
    public void setCurrentQualifier(@Nullable Qualifier<?> qualifier) {
        this.qualifier = qualifier;
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (requiredType.isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    protected void onNewSegment(BeanResolutionContext.Segment<?, ?> segment) {
    }

    @NonNull
    private Map<CharSequence, Object> getAttributesOrCreate() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<CharSequence, Object>(2);
        }
        return this.attributes;
    }

    class DefaultPath
    extends LinkedList<BeanResolutionContext.Segment<?, ?>>
    implements BeanResolutionContext.Path {
        public static final String RIGHT_ARROW = "\\---> ";
        public static final String RIGHT_ARROW_EMOJI = " \u21aa\ufe0f  ";
        private static final String CIRCULAR_ERROR_MSG = "Circular dependency detected";

        DefaultPath() {
        }

        @Override
        public String toConsoleString(boolean ansiSupported) {
            Iterator i = this.descendingIterator();
            String ls = CachedEnvironment.getProperty("line.separator");
            StringBuilder pathString = new StringBuilder().append(ls);
            Object spaces = "";
            while (i.hasNext()) {
                pathString.append(((BeanResolutionContext.Segment)i.next()).toString());
                if (!i.hasNext()) continue;
                pathString.append(ls).append((String)spaces).append(ansiSupported ? RIGHT_ARROW_EMOJI : RIGHT_ARROW);
                spaces = (String)spaces + "      ";
            }
            return pathString.toString();
        }

        @Override
        public String toString() {
            return this.toConsoleString(false);
        }

        @Override
        public String toCircularString() {
            return this.toConsoleCircularString(false);
        }

        @Override
        public String toConsoleCircularString(boolean ansiSupported) {
            Iterator i = this.descendingIterator();
            StringBuilder pathString = new StringBuilder();
            String ls = CachedEnvironment.getProperty("line.separator");
            int cycleIndex = this.lastIndexOf(this.iterator().next());
            cycleIndex = cycleIndex > 0 ? this.size() - cycleIndex : 0;
            Object spaces = "";
            for (int index = 0; i.hasNext() && index < this.size() - 1; ++index) {
                String segmentString = ((BeanResolutionContext.Segment)i.next()).toString();
                if (index == cycleIndex) {
                    pathString.append(ls).append((String)spaces).append("^").append("  ").append(ansiSupported ? RIGHT_ARROW_EMOJI : RIGHT_ARROW);
                    spaces = (String)spaces + "|  ";
                } else if (index != 0) {
                    pathString.append(ls).append((String)spaces).append(ansiSupported ? RIGHT_ARROW_EMOJI : RIGHT_ARROW);
                }
                pathString.append(segmentString);
                spaces = (String)spaces + "      ";
            }
            String dashes = String.join((CharSequence)"", Collections.nCopies(((String)spaces).length() - ((String)spaces).indexOf("|") - 1, "-"));
            pathString.append(ls).append((String)spaces).append("|").append(ls).append((CharSequence)spaces, 0, ((String)spaces).indexOf("|")).append("+").append(dashes).append("+");
            return pathString.toString();
        }

        @Override
        public Optional<BeanResolutionContext.Segment<?, ?>> currentSegment() {
            return Optional.ofNullable((BeanResolutionContext.Segment)this.peek());
        }

        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, Argument argument) {
            ConstructorInjectionPoint constructor = declaringType.getConstructor();
            if (constructor instanceof MethodInjectionPoint) {
                MethodInjectionPoint methodInjectionPoint = (MethodInjectionPoint)((Object)constructor);
                return this.pushConstructorResolve(declaringType, methodInjectionPoint.getName(), argument, constructor.getArguments());
            }
            return this.pushConstructorResolve(declaringType, AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME, argument, constructor.getArguments());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushConstructorResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            try {
                if (AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME.equals(methodName)) {
                    ConstructorArgumentSegment constructorSegment = new ConstructorArgumentSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), methodName, (Argument<Object>)argument, arguments);
                    this.detectCircularDependency(declaringType, argument, constructorSegment);
                } else {
                    MethodSegment ms;
                    BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
                    MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), methodName, (Argument<Object>)argument, arguments, previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
                    if (this.contains(methodSegment)) {
                        this.push(methodSegment);
                        throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                    }
                    this.push(methodSegment);
                }
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        @Override
        public BeanResolutionContext.Path pushBeanCreate(BeanDefinition<?> declaringType, Argument<?> beanType) {
            if (AbstractBeanResolutionContext.this.traceEnabled) {
                AbstractBeanResolutionContext.this.traceMode.getTracer().ifPresent(tracer -> tracer.traceBeanCreation(AbstractBeanResolutionContext.this, declaringType, beanType));
            }
            return this.pushConstructorResolve(declaringType, beanType);
        }

        private void traceResolution() {
            if (AbstractBeanResolutionContext.this.traceEnabled) {
                AbstractBeanResolutionContext.this.getPath().currentSegment().ifPresent(segment -> AbstractBeanResolutionContext.this.traceMode.getTracer().ifPresent(tracer -> tracer.traceInjectBean(AbstractBeanResolutionContext.this, segment)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, MethodInjectionPoint methodInjectionPoint, Argument argument) {
            try {
                MethodSegment ms;
                BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
                MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), methodInjectionPoint.getName(), (Argument<Object>)argument, methodInjectionPoint.getArguments(), previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
                if (this.contains(methodSegment)) {
                    this.push(methodSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, methodInjectionPoint, argument, CIRCULAR_ERROR_MSG);
                }
                this.push(methodSegment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushMethodArgumentResolve(BeanDefinition declaringType, String methodName, Argument argument, Argument[] arguments) {
            try {
                MethodSegment ms;
                BeanResolutionContext.Segment previous = (BeanResolutionContext.Segment)this.peek();
                MethodArgumentSegment methodSegment = new MethodArgumentSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), methodName, (Argument<Object>)argument, arguments, previous instanceof MethodSegment ? (ms = (MethodSegment)previous) : null);
                if (this.contains(methodSegment)) {
                    this.push(methodSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, methodName, argument, CIRCULAR_ERROR_MSG);
                }
                this.push(methodSegment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushEventListenerResolve(BeanDefinition<?> declaringType, Argument<?> eventType) {
            try {
                EventListenerSegment segment = new EventListenerSegment(declaringType, eventType);
                if (this.contains(segment)) {
                    this.push(segment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, eventType, CIRCULAR_ERROR_MSG);
                }
                this.push(segment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, FieldInjectionPoint fieldInjectionPoint) {
            try {
                FieldSegment fieldSegment = new FieldSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), fieldInjectionPoint.asArgument());
                if (this.contains(fieldSegment)) {
                    this.push(fieldSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, fieldInjectionPoint, CIRCULAR_ERROR_MSG);
                }
                this.push(fieldSegment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushFieldResolve(BeanDefinition declaringType, Argument fieldAsArgument) {
            try {
                FieldSegment fieldSegment = new FieldSegment(declaringType, AbstractBeanResolutionContext.this.getCurrentQualifier(), fieldAsArgument);
                if (this.contains(fieldSegment)) {
                    this.push(fieldSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, declaringType, fieldAsArgument.getName(), CIRCULAR_ERROR_MSG);
                }
                this.push(fieldSegment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeanResolutionContext.Path pushAnnotationResolve(BeanDefinition beanDefinition, Argument annotationMemberBeanAsArgument) {
            try {
                AnnotationSegment annotationSegment = new AnnotationSegment(beanDefinition, AbstractBeanResolutionContext.this.getCurrentQualifier(), annotationMemberBeanAsArgument);
                if (this.contains(annotationSegment)) {
                    this.push(annotationSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, beanDefinition, annotationMemberBeanAsArgument.getName(), CIRCULAR_ERROR_MSG);
                }
                this.push(annotationSegment);
            }
            finally {
                this.traceResolution();
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void detectCircularDependency(BeanDefinition declaringType, Argument argument, BeanResolutionContext.Segment constructorSegment) {
            if (!this.contains(constructorSegment)) {
                this.push(constructorSegment);
                return;
            }
            BeanResolutionContext.Segment last = (BeanResolutionContext.Segment)this.peek();
            if (last == null) {
                this.push(constructorSegment);
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
            }
            BeanDefinition declaringBean = last.getDeclaringType();
            if (declaringBean.equals(declaringType)) {
                this.push(constructorSegment);
                return;
            }
            if (declaringType instanceof ProxyBeanDefinition) {
                ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringType;
                if (!proxyBeanDefinition.getTargetDefinitionType().equals(declaringBean.getClass())) {
                    this.push(constructorSegment);
                    throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
                }
                this.push(constructorSegment);
                return;
            }
            if (!(declaringBean instanceof ProxyBeanDefinition)) {
                this.push(constructorSegment);
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
            }
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringBean;
            if (!proxyBeanDefinition.getTargetDefinitionType().equals(declaringType.getClass())) {
                this.push(constructorSegment);
                throw new CircularDependencyException((BeanResolutionContext)AbstractBeanResolutionContext.this, argument, CIRCULAR_ERROR_MSG);
            }
            this.push(constructorSegment);
        }

        @Override
        public void push(BeanResolutionContext.Segment<?, ?> segment) {
            super.push(segment);
            AbstractBeanResolutionContext.this.onNewSegment(segment);
        }

        @Override
        public void close() {
            if (AbstractBeanResolutionContext.this.traceEnabled) {
                AbstractBeanResolutionContext.this.traceMode.getTracer().ifPresent(tracer -> {
                    if (this.isEmpty()) {
                        tracer.traceBeanCreated(AbstractBeanResolutionContext.this, AbstractBeanResolutionContext.this.rootDefinition);
                    } else {
                        BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)this.peek();
                        if (segment != null) {
                            tracer.traceInjectComplete(AbstractBeanResolutionContext.this, segment);
                        }
                    }
                });
            }
            BeanResolutionContext.Path.super.close();
        }
    }

    protected static abstract class AbstractSegment<B, T>
    implements BeanResolutionContext.Segment<B, T>,
    Named {
        protected static final String MEMBER_SEPARATOR = "#";
        private final BeanDefinition<B> declaringComponent;
        @Nullable
        private final Qualifier<B> qualifier;
        private final String name;
        private final Argument<T> argument;

        AbstractSegment(BeanDefinition<B> declaringClass, Qualifier<B> qualifier, String name, Argument<T> argument) {
            this.declaringComponent = declaringClass;
            this.qualifier = qualifier;
            this.name = name;
            this.argument = argument;
        }

        protected String getTypeName(Class<?> type) {
            if (InterceptedBean.class.isAssignableFrom(type)) {
                Class<?>[] interfaces = type.getInterfaces();
                Set interfaceNames = Arrays.stream(interfaces).map(Class::getName).collect(Collectors.toSet());
                if (type.isInterface() && interfaceNames.contains("io.micronaut.aop.Introduced")) {
                    return NameUtils.getShortenedName((String)interfaces[0].getTypeName());
                }
                return NameUtils.getShortenedName((String)type.getSuperclass().getTypeName());
            }
            return NameUtils.getShortenedName((String)type.getTypeName());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BeanDefinition<B> getDeclaringType() {
            return this.declaringComponent;
        }

        @Override
        public Qualifier<B> getDeclaringTypeQualifier() {
            return this.qualifier == null ? this.declaringComponent.getDeclaredQualifier() : this.qualifier;
        }

        @Override
        public Argument<T> getArgument() {
            return this.argument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractSegment that = (AbstractSegment)o;
            return this.declaringComponent.equals(that.declaringComponent) && this.name.equals(that.name) && this.argument.equals(that.argument);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.declaringComponent, (Object)this.name, this.argument);
        }

        void outputArguments(StringBuilder baseString, Argument[] arguments, boolean ansiSupported) {
            baseString.append(ansiSupported ? AnsiColour.brightCyan((String)"(") : "(");
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                boolean isInjectedArgument = argument.equals(this.getArgument());
                if (isInjectedArgument) {
                    if (ansiSupported) {
                        baseString.append(AnsiColour.BLUE_UNDERLINED);
                    }
                    baseString.append('[');
                }
                String beanTypeString = argument.getBeanTypeString(ansiSupported && !isInjectedArgument ? TypeInformation.TypeFormat.ANSI_SIMPLE : TypeInformation.TypeFormat.SIMPLE);
                baseString.append(beanTypeString).append(' ').append(ansiSupported && !isInjectedArgument ? AnsiColour.brightBlue((String)argument.getName()) : argument.getName());
                if (isInjectedArgument) {
                    baseString.append(']');
                    if (ansiSupported) {
                        baseString.append(AnsiColour.RESET);
                    }
                }
                if (i == arguments.length - 1) continue;
                Argument next = arguments[i + 1];
                if (this.getDeclaringType().getBeanType().isSynthetic() && next.getName().startsWith("$")) break;
                baseString.append(", ");
            }
            baseString.append(ansiSupported ? AnsiColour.brightCyan((String)")") : ")");
        }
    }

    public static final class AnnotationSegment<B>
    extends AbstractSegment<B, B>
    implements InjectionPoint<B> {
        AnnotationSegment(BeanDefinition<B> beanDefinition, Qualifier<B> qualifier, Argument<B> argument) {
            super(beanDefinition, qualifier, argument.getName(), argument);
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }

        @Override
        public Qualifier<B> getDeclaringBeanQualifier() {
            return this.getDeclaringTypeQualifier();
        }
    }

    public static final class FieldSegment<B, T>
    extends AbstractSegment<B, T>
    implements InjectionPoint<B>,
    ArgumentCoercible<T>,
    ArgumentInjectionPoint<B, T> {
        FieldSegment(BeanDefinition<B> declaringClass, Qualifier<B> qualifier, Argument<T> argument) {
            super(declaringClass, qualifier, argument.getName(), argument);
        }

        public String toString() {
            return this.toConsoleString(false);
        }

        @Override
        public String toConsoleString(boolean ansiSupported) {
            String beanDescription = this.getDeclaringType().getBeanDescription(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED, false);
            StringBuilder baseString = new StringBuilder(beanDescription);
            String memberSeparator = ansiSupported ? String.valueOf(AnsiColour.CYAN_BOLD) + "#" + String.valueOf(AnsiColour.RESET) : "#";
            baseString.append(memberSeparator);
            baseString.append(this.getName());
            return baseString.toString();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public CallableInjectionPoint<B> getOuterInjectionPoint() {
            throw new UnsupportedOperationException("Outer injection point not retrievable from here");
        }

        @Override
        public Argument<T> asArgument() {
            return this.getArgument();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }

        @Override
        public Qualifier<B> getDeclaringBeanQualifier() {
            return this.getDeclaringTypeQualifier();
        }
    }

    public static class MethodSegment<B, T>
    extends AbstractSegment<B, T>
    implements CallableInjectionPoint<B> {
        private final Argument<Object>[] arguments;

        MethodSegment(BeanDefinition<B> declaringType, Qualifier<B> qualifier, String methodName, Argument<T> argument, Argument<Object>[] arguments) {
            super(declaringType, qualifier, methodName, argument);
            this.arguments = arguments;
        }

        public String toString() {
            return this.toConsoleString(false);
        }

        @Override
        public String toConsoleString(boolean ansiSupported) {
            StringBuilder baseString = new StringBuilder(this.getDeclaringType().getTypeInformation().getBeanTypeString(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED));
            String memberSeparator = ansiSupported ? String.valueOf(AnsiColour.CYAN_BOLD) + "#" + String.valueOf(AnsiColour.RESET) : "#";
            baseString.append(memberSeparator);
            baseString.append(this.getName());
            this.outputArguments(baseString, this.arguments, ansiSupported);
            return baseString.toString();
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public Argument<?>[] getArguments() {
            return this.arguments;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }

        @Override
        public Qualifier<B> getDeclaringBeanQualifier() {
            return this.getDeclaringTypeQualifier();
        }
    }

    public static class EventListenerSegment<B, T>
    extends AbstractSegment<B, T>
    implements CallableInjectionPoint<B> {
        EventListenerSegment(BeanDefinition<B> declaringClass, Argument<T> eventType) {
            super(declaringClass, null, eventType.getName(), eventType);
        }

        @Override
        public String toConsoleString(boolean ansiSupported) {
            if (ansiSupported) {
                String event = this.getArgument().getTypeString(TypeInformation.TypeFormat.ANSI_SIMPLE);
                return event + " \u27a1\ufe0f  " + this.getDeclaringBean().getBeanDescription(TypeInformation.TypeFormat.ANSI_SHORTENED);
            }
            String event = this.getArgument().getTypeString(TypeInformation.TypeFormat.SIMPLE);
            return event + " -> " + this.getDeclaringBean().getBeanDescription(TypeInformation.TypeFormat.SHORTENED);
        }

        @Override
        public InjectionPoint<B> getInjectionPoint() {
            return this;
        }

        @Override
        public Argument<?>[] getArguments() {
            return new Argument[]{this.getArgument()};
        }

        @Override
        public BeanDefinition<B> getDeclaringBean() {
            return this.getDeclaringType();
        }
    }

    public static final class MethodArgumentSegment
    extends MethodSegment<Object, Object>
    implements ArgumentInjectionPoint<Object, Object> {
        private final MethodSegment<Object, Object> outer;

        public MethodArgumentSegment(BeanDefinition<Object> declaringType, Qualifier<Object> qualifier, String methodName, Argument<Object> argument, Argument<Object>[] arguments, MethodSegment<Object, Object> outer) {
            super(declaringType, qualifier, methodName, argument, arguments);
            this.outer = outer;
        }

        @Override
        public CallableInjectionPoint<Object> getOuterInjectionPoint() {
            if (this.outer == null) {
                throw new IllegalStateException("Outer argument inaccessible");
            }
            return this.outer;
        }

        @Override
        public String toString() {
            return this.toConsoleString(false);
        }

        @Override
        public String toConsoleString(boolean ansiSupported) {
            BeanDefinition declaringBean = this.getDeclaringBean();
            if (declaringBean.hasAnnotation(Factory.class)) {
                String beanDescription = declaringBean.getBeanDescription(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED, false);
                StringBuilder baseString = new StringBuilder(beanDescription);
                String methodName = this.getName();
                if (!AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME.equals(methodName)) {
                    String memberSeparator = ansiSupported ? String.valueOf(AnsiColour.CYAN_BOLD) + "#" + String.valueOf(AnsiColour.RESET) : "#";
                    baseString.append(memberSeparator);
                    baseString.append(methodName);
                }
                this.outputArguments(baseString, this.getArguments(), ansiSupported);
                return baseString.toString();
            }
            return super.toConsoleString(ansiSupported);
        }
    }

    public static class ConstructorSegment
    extends AbstractSegment<Object, Object>
    implements ArgumentInjectionPoint<Object, Object> {
        private static final String ANN_ADAPTER = "io.micronaut.aop.Adapter";
        private final String methodName;
        private final Argument<Object>[] arguments;

        ConstructorSegment(BeanDefinition<Object> declaringBeanDefinition, Qualifier<Object> qualifier, String methodName, Argument<Object> argument, Argument<Object>[] arguments) {
            super(declaringBeanDefinition, qualifier, declaringBeanDefinition.getBeanType().getName(), argument);
            this.methodName = methodName;
            this.arguments = arguments;
        }

        public String toString() {
            return this.toConsoleString(false);
        }

        @Override
        @NonNull
        public String toConsoleString(boolean ansiSupported) {
            StringBuilder baseString;
            BeanDefinition declaringType = this.getDeclaringType();
            TypeInformation typeInformation = declaringType.getTypeInformation();
            if (declaringType.hasDeclaredStereotype(ANN_ADAPTER)) {
                ExecutableMethod method = declaringType.getExecutableMethods().iterator().next();
                Class beanType = method.classValue(ANN_ADAPTER, "adaptedBean").orElse(declaringType.getBeanType());
                String beanMethod = method.stringValue(ANN_ADAPTER, "adaptedMethod").orElse("unknown");
                baseString = new StringBuilder(TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED), beanType, (Map)declaringType.asArgument().getTypeVariables(), (AnnotationMetadata)declaringType.getAnnotationMetadata())).append("#");
                baseString.append(beanMethod);
            } else if (AbstractBeanResolutionContext.CONSTRUCTOR_METHOD_NAME.equals(this.methodName)) {
                baseString = new StringBuilder(ansiSupported ? AnsiColour.magentaBold((String)"new ") : "new ");
                baseString.append(typeInformation.getBeanTypeString(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED));
            } else {
                baseString = new StringBuilder(typeInformation.getBeanTypeString(ansiSupported ? TypeInformation.TypeFormat.ANSI_SHORTENED : TypeInformation.TypeFormat.SHORTENED)).append("#");
                baseString.append(this.methodName);
            }
            this.outputArguments(baseString, this.arguments, ansiSupported);
            return baseString.toString();
        }

        @Override
        public InjectionPoint<Object> getInjectionPoint() {
            return this;
        }

        @Override
        @NonNull
        public CallableInjectionPoint<Object> getOuterInjectionPoint() {
            return this.getDeclaringType().getConstructor();
        }

        @Override
        public BeanDefinition<Object> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public Qualifier<Object> getDeclaringBeanQualifier() {
            return this.getDeclaringTypeQualifier();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.getArgument().getAnnotationMetadata();
        }
    }

    public static final class ConstructorArgumentSegment
    extends ConstructorSegment
    implements ArgumentInjectionPoint<Object, Object> {
        public ConstructorArgumentSegment(BeanDefinition<Object> declaringType, Qualifier<Object> qualifier, String methodName, Argument<Object> argument, Argument<Object>[] arguments) {
            super(declaringType, qualifier, methodName, argument, arguments);
        }

        @Override
        public BeanDefinition<Object> getDeclaringBean() {
            return this.getDeclaringType();
        }

        @Override
        public Qualifier<Object> getDeclaringBeanQualifier() {
            return this.getDeclaringTypeQualifier();
        }
    }
}

