/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Consumer;

public interface Element
extends AnnotationMetadataDelegate,
AnnotatedElement {
    public static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];

    @NonNull
    public String getName();

    default public boolean isPackagePrivate() {
        return false;
    }

    public boolean isProtected();

    public boolean isPublic();

    @NonNull
    public Object getNativeType();

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }

    @NonNull
    default public Element annotate(@NonNull String annotationType) {
        return this.annotate(annotationType, (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull Class<T> annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        return this.annotate(annotationType.getName(), consumer);
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull Class<T> annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", annotationType);
        return this.annotate(annotationType.getName(), (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public String getSimpleName() {
        return this.getName();
    }

    default public boolean isAbstract() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public Optional<String> getDocumentation() {
        return Optional.empty();
    }

    default public boolean isPrivate() {
        return !this.isPublic();
    }

    default public boolean isFinal() {
        return false;
    }
}

