/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import java.util.Objects;

public class BeanRegistration<T>
implements Ordered {
    final BeanIdentifier identifier;
    final BeanDefinition<T> beanDefinition;
    final T bean;

    public BeanRegistration(BeanIdentifier identifier, BeanDefinition<T> beanDefinition, T bean) {
        this.identifier = identifier;
        this.beanDefinition = beanDefinition;
        this.bean = bean;
    }

    public int getOrder() {
        return OrderUtil.getOrder((AnnotationMetadata)this.beanDefinition.getAnnotationMetadata(), this.bean);
    }

    public BeanIdentifier getIdentifier() {
        return this.identifier;
    }

    public BeanDefinition<T> getBeanDefinition() {
        return this.beanDefinition;
    }

    public T getBean() {
        return this.bean;
    }

    public String toString() {
        return "BeanRegistration: " + this.bean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanRegistration that = (BeanRegistration)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.beanDefinition, that.beanDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.beanDefinition);
    }
}

