/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.asm.signature.SignatureVisitor;
import io.micronaut.asm.signature.SignatureWriter;
import io.micronaut.context.AbstractBeanDefinition;
import io.micronaut.context.AbstractParametrizedBeanDefinition;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ProviderFactory;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ConfigBuilderState;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Internal
public class BeanDefinitionWriter
extends AbstractClassFileWriter
implements BeanDefinitionVisitor {
    private static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    private static final Constructor<AbstractBeanDefinition> CONSTRUCTOR_ABSTRACT_BEAN_DEFINITION = (Constructor)ReflectionUtils.findConstructor(AbstractBeanDefinition.class, (Class[])new Class[]{Class.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class}).orElseThrow(() -> new ClassGenerationException("Invalid version of Micronaut present on the class path"));
    private static final Method METHOD_MAP_OF = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(CollectionUtils.class, (String)"mapOf", (Class[])new Class[]{Object[].class}));
    private static final java.lang.reflect.Method POST_CONSTRUCT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"postConstruct", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method INJECT_BEAN_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"injectBean", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method PRE_DESTROY_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"preDestroy", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Object.class});
    private static final java.lang.reflect.Method ADD_FIELD_INJECTION_POINT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addInjectionPoint", (Class[])new Class[]{Class.class, Class.class, String.class, AnnotationMetadata.class, Argument[].class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_METHOD_INJECTION_POINT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addInjectionPoint", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_POST_CONSTRUCT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addPostConstruct", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_PRE_DESTROY_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addPreDestroy", (Class[])new Class[]{Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE});
    private static final java.lang.reflect.Method ADD_EXECUTABLE_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"addExecutableMethod", (Class[])new Class[]{ExecutableMethod.class});
    private static final java.lang.reflect.Method GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanForConstructorArgument");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationsForConstructorArgument");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationForConstructorArgument");
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeansOfTypeForConstructorArgument");
    private static final java.lang.reflect.Method GET_VALUE_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getValueForConstructorArgument");
    private static final java.lang.reflect.Method GET_BEAN_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanForField");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationsForField");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationForField");
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeansOfTypeForField");
    private static final java.lang.reflect.Method GET_VALUE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getValueForField");
    private static final java.lang.reflect.Method GET_VALUE_FOR_PATH = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"getValueForPath", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Argument.class, String.class});
    private static final java.lang.reflect.Method CONTAINS_VALUE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("containsValueForField");
    private static final java.lang.reflect.Method CONTAINS_PROPERTIES_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)"containsProperties", (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class});
    private static final java.lang.reflect.Method GET_BEAN_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanForMethodArgument");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanRegistrationsForMethodArgument");
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanRegistrationForMethodArgument");
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeansOfTypeForMethodArgument");
    private static final java.lang.reflect.Method GET_VALUE_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getValueForMethodArgument");
    private static final java.lang.reflect.Method CONTAINS_VALUE_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("containsValueForMethodArgument");
    private static final Method BEAN_DEFINITION_CLASS_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class));
    private static final Method BEAN_DEFINITION_METHOD_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, Class.class, String.class, AnnotationMetadata.class, Boolean.TYPE, Argument[].class));
    private static final Type TYPE_ABSTRACT_BEAN_DEFINITION = Type.getType(AbstractBeanDefinition.class);
    private static final Type TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION = Type.getType(AbstractParametrizedBeanDefinition.class);
    private static final Method METHOD_OPTIONAL_EMPTY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"empty", (Class[])new Class[0]));
    private static final Type TYPE_OPTIONAL = Type.getType(Optional.class);
    private static final Method METHOD_OPTIONAL_OF = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"of", (Class[])new Class[]{Object.class}));
    private final ClassWriter classWriter;
    private final String beanFullClassName;
    private final String beanDefinitionName;
    private final String beanDefinitionInternalName;
    private final Type beanType;
    private final Type providedType;
    private final Set<Class> interfaceTypes;
    private final Map<String, GeneratorAdapter> loadTypeMethods = new LinkedHashMap<String, GeneratorAdapter>();
    private final Map<String, ExecutableMethodWriter> methodExecutors = new LinkedHashMap<String, ExecutableMethodWriter>();
    private final String providedBeanClassName;
    private final String packageName;
    private final String beanSimpleClassName;
    private final Type beanDefinitionType;
    private final boolean isInterface;
    private final boolean isConfigurationProperties;
    private final ConfigurationMetadataBuilder<?> metadataBuilder;
    private GeneratorAdapter constructorVisitor;
    private GeneratorAdapter buildMethodVisitor;
    private GeneratorAdapter injectMethodVisitor;
    private Label injectEnd = null;
    private GeneratorAdapter preDestroyMethodVisitor;
    private GeneratorAdapter postConstructMethodVisitor;
    private int methodExecutorIndex = 0;
    private int currentFieldIndex = 0;
    private int currentMethodIndex = 0;
    private int buildMethodLocalCount = 4;
    private int injectMethodLocalCount = 4;
    private int postConstructMethodLocalCount = 4;
    private int preDestroyMethodLocalCount = 4;
    private int buildInstanceIndex;
    private int argsIndex = -1;
    private int injectInstanceIndex;
    private int postConstructInstanceIndex;
    private int preDestroyInstanceIndex;
    private boolean beanFinalized = false;
    private Type superType = TYPE_ABSTRACT_BEAN_DEFINITION;
    private boolean isSuperFactory = false;
    private final AnnotationMetadata annotationMetadata;
    private ConfigBuilderState currentConfigBuilderState;
    private int optionalInstanceIndex;
    private boolean preprocessMethods = false;
    private Map<String, Map<String, ClassElement>> typeArguments;
    private List<MethodVisitData> postConstructMethodVisits = new ArrayList<MethodVisitData>(2);
    private List<MethodVisitData> preDestroyMethodVisits = new ArrayList<MethodVisitData>(2);
    private String interceptedType;
    private List<Runnable> deferredInjectionPoints = new ArrayList<Runnable>();

    public BeanDefinitionWriter(String packageName, String className, boolean isInterface, OriginatingElements originatingElements, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder<?> metadataBuilder) {
        this(packageName, className, BeanDefinitionWriter.getBeanDefinitionName(packageName, className), packageName + '.' + className, isInterface, originatingElements, annotationMetadata, metadataBuilder);
    }

    public BeanDefinitionWriter(ClassElement classElement, ConfigurationMetadataBuilder<?> metadataBuilder) {
        this(classElement.getPackageName(), classElement.getSimpleName(), BeanDefinitionWriter.getBeanDefinitionName(classElement.getPackageName(), classElement.getSimpleName()), BeanDefinitionWriter.getProvidedClassName(classElement), classElement.isInterface(), OriginatingElements.of(classElement), classElement.getAnnotationMetadata(), metadataBuilder);
    }

    public BeanDefinitionWriter(String packageName, String className, String beanDefinitionName, String providedClassName, boolean isInterface, OriginatingElements originatingElements, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder<?> metadataBuilder) {
        super(originatingElements);
        this.metadataBuilder = metadataBuilder;
        this.classWriter = new ClassWriter(3);
        this.packageName = packageName;
        this.isInterface = isInterface;
        this.beanFullClassName = packageName + '.' + className;
        this.annotationMetadata = annotationMetadata;
        this.beanSimpleClassName = className;
        this.providedBeanClassName = providedClassName;
        this.beanDefinitionName = beanDefinitionName;
        this.beanDefinitionType = BeanDefinitionWriter.getTypeReferenceForName(this.beanDefinitionName, new String[0]);
        this.beanType = BeanDefinitionWriter.getTypeReferenceForName(this.beanFullClassName, new String[0]);
        this.providedType = BeanDefinitionWriter.getTypeReferenceForName(this.providedBeanClassName, new String[0]);
        this.beanDefinitionInternalName = BeanDefinitionWriter.getInternalName(this.beanDefinitionName);
        this.interfaceTypes = new TreeSet<Class>(Comparator.comparing(Class::getName));
        this.interfaceTypes.add(BeanFactory.class);
        this.isConfigurationProperties = annotationMetadata.hasDeclaredStereotype(ConfigurationProperties.class);
    }

    private static String getProvidedClassName(ClassElement classElement) {
        for (Class provider : ProviderFactory.getProviders()) {
            String providerName = provider.getName();
            if (!classElement.isAssignable(providerName)) continue;
            Iterator<ClassElement> i = classElement.getTypeArguments(providerName).values().iterator();
            return i.hasNext() ? i.next().getName() : classElement.getName();
        }
        return classElement.getName();
    }

    @NotNull
    private static String getBeanDefinitionName(String packageName, String className) {
        return packageName + ".$" + className + "Definition";
    }

    @Override
    @NonNull
    public String getBeanDefinitionReferenceClassName() {
        return this.beanDefinitionName + "Class";
    }

    public final List<MethodVisitData> getPostConstructMethodVisits() {
        return Collections.unmodifiableList(this.postConstructMethodVisits);
    }

    public List<MethodVisitData> getPreDestroyMethodVisits() {
        return Collections.unmodifiableList(this.preDestroyMethodVisits);
    }

    public ClassVisitor getClassWriter() {
        return this.classWriter;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isSingleton() {
        return this.annotationMetadata.hasDeclaredStereotype(Singleton.class);
    }

    @Override
    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.interfaceTypes.add(interfaceType);
    }

    @Override
    public void visitSuperBeanDefinition(String name) {
        this.superType = BeanDefinitionWriter.getTypeReferenceForName(name, new String[0]);
    }

    @Override
    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.visitSuperBeanDefinition(beanName);
        this.isSuperFactory = true;
    }

    @Override
    public String getBeanTypeName() {
        return this.beanFullClassName;
    }

    @Override
    public Type getProvidedType() {
        return this.providedType;
    }

    @Override
    public void setValidated(boolean validated) {
        if (validated) {
            this.interfaceTypes.add(ValidatedBeanDefinition.class);
        } else {
            this.interfaceTypes.remove(ValidatedBeanDefinition.class);
        }
    }

    @Override
    public void setInterceptedType(String typeName) {
        if (typeName != null) {
            this.interfaceTypes.add(AdvisedBeanType.class);
        }
        this.interceptedType = typeName;
    }

    @Override
    public Optional<Type> getInterceptedType() {
        return Optional.ofNullable(this.interceptedType).map(x$0 -> BeanDefinitionWriter.getTypeReferenceForName(x$0, new String[0]));
    }

    @Override
    public boolean isValidated() {
        return this.interfaceTypes.contains(ValidatedBeanDefinition.class);
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanDefinitionName;
    }

    public String getBeanDefinitionClassFile() {
        String className = this.getBeanDefinitionName();
        return this.getClassFileName(className);
    }

    public void visitBeanFactoryMethod(ClassElement factoryClass, MethodElement factoryMethod) {
        if (this.constructorVisitor != null) {
            throw new IllegalStateException("Only a single call to visitBeanFactoryMethod(..) is permitted");
        }
        this.visitBuildFactoryMethodDefinition(factoryClass, factoryMethod);
        this.buildFactoryMethodClassConstructor(factoryClass, factoryMethod.getGenericReturnType(), factoryMethod.getName(), factoryMethod.getAnnotationMetadata(), Arrays.asList(factoryMethod.getParameters()));
        this.visitInjectMethodDefinition();
    }

    @Override
    public void visitBeanDefinitionConstructor(MethodElement constructor, boolean requiresReflection) {
        if (this.constructorVisitor == null) {
            this.applyConfigurationInjectionIfNecessary(constructor);
            this.visitBeanDefinitionConstructorInternal(constructor, requiresReflection);
            this.visitBuildMethodDefinition(constructor);
            this.visitInjectMethodDefinition();
        }
    }

    private void applyConfigurationInjectionIfNecessary(MethodElement constructor) {
        boolean isRecordConfig = this.isRecordConfig(constructor);
        if (isRecordConfig || constructor.hasAnnotation(ConfigurationInject.class)) {
            List<Class<? extends Annotation>> injectionTypes = Arrays.asList(Property.class, Value.class, Parameter.class, Qualifier.class, Inject.class);
            if (isRecordConfig) {
                List<PropertyElement> beanProperties = constructor.getDeclaringType().getBeanProperties();
                ParameterElement[] parameters = constructor.getParameters();
                if (beanProperties.size() == parameters.length) {
                    for (int i = 0; i < parameters.length; ++i) {
                        ParameterElement parameter = parameters[i];
                        PropertyElement bp = beanProperties.get(i);
                        AnnotationMetadata beanPropertyMetadata = bp.getAnnotationMetadata();
                        AnnotationMetadata annotationMetadata = parameter.getAnnotationMetadata();
                        if (injectionTypes.stream().noneMatch(arg_0 -> ((AnnotationMetadata)beanPropertyMetadata).hasStereotype(arg_0))) {
                            this.processConfigurationConstructorParameter(parameter, annotationMetadata);
                        }
                        if (!annotationMetadata.hasStereotype(ANN_CONSTRAINT)) continue;
                        this.setValidated(true);
                    }
                } else {
                    this.processConfigurationInjectionConstructor(constructor, injectionTypes);
                }
            } else {
                this.processConfigurationInjectionConstructor(constructor, injectionTypes);
            }
        }
    }

    private void processConfigurationInjectionConstructor(MethodElement constructor, List<Class<? extends Annotation>> injectionTypes) {
        ParameterElement[] parameters;
        for (ParameterElement parameter : parameters = constructor.getParameters()) {
            AnnotationMetadata annotationMetadata = parameter.getAnnotationMetadata();
            if (injectionTypes.stream().noneMatch(arg_0 -> ((AnnotationMetadata)annotationMetadata).hasStereotype(arg_0))) {
                this.processConfigurationConstructorParameter(parameter, annotationMetadata);
            }
            if (!annotationMetadata.hasStereotype(ANN_CONSTRAINT)) continue;
            this.setValidated(true);
        }
    }

    private void processConfigurationConstructorParameter(ParameterElement parameter, AnnotationMetadata annotationMetadata) {
        ClassElement parameterType = parameter.getGenericType();
        if (!parameterType.hasStereotype(Scope.class)) {
            PropertyMetadata pm = this.metadataBuilder.visitProperty(parameterType.getName(), parameter.getName(), parameter.getDocumentation().orElse(null), annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null));
            parameter.annotate(Property.class, builder -> builder.member("name", pm.getPath()));
        }
    }

    private boolean isRecordConfig(MethodElement constructor) {
        ClassElement declaringType = constructor.getDeclaringType();
        return declaringType.isRecord() && declaringType.hasStereotype(ConfigurationReader.class);
    }

    @Override
    public void visitDefaultConstructor(AnnotationMetadata annotationMetadata) {
        if (this.constructorVisitor == null) {
            ClassElement bean = ClassElement.of(this.beanType.getClassName());
            MethodElement constructor = MethodElement.of(bean, annotationMetadata, bean, bean, "<init>", new ParameterElement[0]);
            this.visitBeanDefinitionConstructorInternal(constructor, false);
            this.visitBuildMethodDefinition(constructor);
            this.visitInjectMethodDefinition();
        }
    }

    @Override
    public void visitBeanDefinitionEnd() {
        if (this.classWriter == null) {
            throw new IllegalStateException("At least one called to visitBeanDefinitionConstructor(..) is required");
        }
        String[] interfaceInternalNames = new String[this.interfaceTypes.size()];
        Iterator<Class> j = this.interfaceTypes.iterator();
        for (int i = 0; i < interfaceInternalNames.length; ++i) {
            interfaceInternalNames[i] = Type.getInternalName((Class)j.next());
        }
        this.classWriter.visit(52, 4096, this.beanDefinitionInternalName, this.generateBeanDefSig(this.providedType.getInternalName()), this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), interfaceInternalNames);
        this.classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        if (this.buildMethodVisitor == null) {
            throw new IllegalStateException("At least one call to visitBeanDefinitionConstructor() is required");
        }
        this.finalizeInjectMethod();
        this.finalizeBuildMethod();
        this.finalizeAnnotationMetadata();
        this.finalizeTypeArguments();
        if (this.preprocessMethods) {
            GeneratorAdapter requiresMethodProcessing = this.startPublicMethod(this.classWriter, "requiresMethodProcessing", Boolean.TYPE.getName(), new String[0]);
            requiresMethodProcessing.push(true);
            requiresMethodProcessing.visitInsn(172);
            requiresMethodProcessing.visitMaxs(1, 1);
            requiresMethodProcessing.visitEnd();
        }
        for (Runnable fieldInjectionPoint : this.deferredInjectionPoints) {
            fieldInjectionPoint.run();
        }
        this.constructorVisitor.visitInsn(177);
        this.constructorVisitor.visitMaxs(13, 1);
        if (this.buildMethodVisitor != null) {
            this.buildMethodVisitor.visitInsn(176);
            this.buildMethodVisitor.visitMaxs(13, this.buildMethodLocalCount);
        }
        if (this.injectMethodVisitor != null) {
            this.injectMethodVisitor.visitMaxs(13, this.injectMethodLocalCount);
        }
        if (this.postConstructMethodVisitor != null) {
            this.postConstructMethodVisitor.visitVarInsn(25, this.postConstructInstanceIndex);
            this.postConstructMethodVisitor.visitInsn(176);
            this.postConstructMethodVisitor.visitMaxs(13, this.postConstructMethodLocalCount);
        }
        if (this.preDestroyMethodVisitor != null) {
            this.preDestroyMethodVisitor.visitVarInsn(25, this.preDestroyInstanceIndex);
            this.preDestroyMethodVisitor.visitInsn(176);
            this.preDestroyMethodVisitor.visitMaxs(13, this.preDestroyMethodLocalCount);
        }
        this.getInterceptedType().ifPresent(t -> this.implementInterceptedTypeMethod((Type)t, this.classWriter));
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        this.classWriter.visitEnd();
        this.beanFinalized = true;
    }

    private void finalizeTypeArguments() {
        if (CollectionUtils.isNotEmpty(this.typeArguments)) {
            GeneratorAdapter visitor = this.startPublicMethodZeroArgs(this.classWriter, Map.class, "getTypeArgumentsMap");
            int totalSize = this.typeArguments.size() * 2;
            BeanDefinitionWriter.pushNewArray(visitor, Object.class, totalSize);
            int i = 0;
            for (Map.Entry<String, Map<String, ClassElement>> entry : this.typeArguments.entrySet()) {
                String typeName = entry.getKey();
                BeanDefinitionWriter.pushStoreStringInArray(visitor, i++, totalSize, typeName);
                BeanDefinitionWriter.pushStoreInArray(visitor, i++, totalSize, () -> BeanDefinitionWriter.pushTypeArgumentElements(this.beanDefinitionType, this.classWriter, visitor, this.beanDefinitionName, (Map)entry.getValue(), this.loadTypeMethods));
            }
            visitor.invokeStatic(Type.getType(CollectionUtils.class), METHOD_MAP_OF);
            visitor.returnValue();
            visitor.visitMaxs(1, 1);
            visitor.visitEnd();
        }
    }

    private void finalizeAnnotationMetadata() {
        if (this.annotationMetadata != null) {
            GeneratorAdapter annotationMetadataMethod = this.startProtectedMethod(this.classWriter, "resolveAnnotationMetadata", AnnotationMetadata.class.getName(), new String[0]);
            annotationMetadataMethod.loadThis();
            annotationMetadataMethod.getStatic(BeanDefinitionWriter.getTypeReferenceForName(this.getBeanDefinitionReferenceClassName(), new String[0]), "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
            annotationMetadataMethod.returnValue();
            annotationMetadataMethod.visitMaxs(1, 1);
            annotationMetadataMethod.visitEnd();
        }
        AnnotationMetadata annotationMetadata = this.annotationMetadata != null ? this.annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
        this.writeBooleanMethod(this.classWriter, "isSingleton", () -> annotationMetadata.hasDeclaredStereotype(Singleton.class) || annotationMetadata.classValue(DefaultScope.class).map(t -> t == Singleton.class).orElse(false) != false);
        this.writeBooleanMethod(this.classWriter, "isIterable", () -> annotationMetadata.hasDeclaredStereotype(EachProperty.class) || annotationMetadata.hasDeclaredStereotype(EachBean.class));
        this.writeBooleanMethod(this.classWriter, "isPrimary", () -> annotationMetadata.hasDeclaredStereotype(Primary.class));
        this.writeBooleanMethod(this.classWriter, "isProvided", () -> annotationMetadata.hasDeclaredStereotype(Provided.class));
        GeneratorAdapter getScopeMethod = this.startPublicMethodZeroArgs(this.classWriter, Optional.class, "getScope");
        getScopeMethod.loadThis();
        Optional scope = annotationMetadata.getDeclaredAnnotationNameByStereotype(Scope.class.getName());
        if (scope.isPresent()) {
            getScopeMethod.push(BeanDefinitionWriter.getTypeReferenceForName((String)scope.get(), new String[0]));
            getScopeMethod.invokeStatic(TYPE_OPTIONAL, METHOD_OPTIONAL_OF);
        } else {
            getScopeMethod.invokeStatic(TYPE_OPTIONAL, METHOD_OPTIONAL_EMPTY);
        }
        getScopeMethod.returnValue();
        getScopeMethod.visitMaxs(1, 1);
        getScopeMethod.visitEnd();
    }

    public byte[] toByteArray() {
        if (!this.beanFinalized) {
            throw new IllegalStateException("Bean definition not finalized. Call visitBeanDefinitionEnd() first.");
        }
        return this.classWriter.toByteArray();
    }

    @Override
    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        try (OutputStream out = visitor.visitClass(this.getBeanDefinitionName(), this.getOriginatingElements());){
            try {
                for (ExecutableMethodWriter methodWriter : this.methodExecutors.values()) {
                    methodWriter.accept(visitor);
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
            out.write(this.toByteArray());
        }
    }

    @Override
    public void visitSetterValue(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, boolean isOptional) {
        ParameterElement[] parameters = methodElement.getParameters();
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Method must have exactly 1 argument");
        }
        Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        this.constructorVisitor.visitVarInsn(25, 0);
        this.constructorVisitor.push(declaringTypeRef);
        this.constructorVisitor.push(methodElement.getName());
        BeanDefinitionWriter.pushBuildArgumentsForMethod(declaringTypeRef.getClassName(), this.beanDefinitionType, this.classWriter, this.constructorVisitor, Arrays.asList(parameters), this.loadTypeMethods);
        AnnotationMetadata annotationMetadata = methodElement.getAnnotationMetadata();
        if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            this.constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, this.constructorVisitor, (DefaultAnnotationMetadata)annotationMetadata, this.loadTypeMethods);
        }
        this.constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)this.constructorVisitor, ADD_METHOD_INJECTION_POINT_METHOD);
        if (!requiresReflection) {
            this.resolveBeanOrValueForSetter(declaringTypeRef, methodElement.getReturnType(), methodElement.getName(), parameters[0].getType(), GET_VALUE_FOR_METHOD_ARGUMENT, isOptional);
        }
        ++this.currentMethodIndex;
    }

    @Override
    public void visitPostConstructMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection) {
        this.visitPostConstructMethodDefinition();
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, requiresReflection);
        this.postConstructMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.constructorVisitor, this.postConstructMethodVisitor, this.postConstructInstanceIndex, ADD_POST_CONSTRUCT_METHOD);
    }

    @Override
    public void visitPreDestroyMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection) {
        this.visitPreDestroyMethodDefinition();
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, requiresReflection);
        this.preDestroyMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.constructorVisitor, this.preDestroyMethodVisitor, this.preDestroyInstanceIndex, ADD_PRE_DESTROY_METHOD);
    }

    @Override
    public void visitMethodInjectionPoint(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection) {
        this.applyConfigurationInjectionIfNecessary(methodElement);
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
        int injectInstanceIndex = this.injectInstanceIndex;
        this.visitMethodInjectionPointInternal(new MethodVisitData(declaringType, methodElement, requiresReflection), constructorVisitor, injectMethodVisitor, injectInstanceIndex, ADD_METHOD_INJECTION_POINT_METHOD);
    }

    @Override
    public ExecutableMethodWriter visitExecutableMethod(TypedElement declaringBean, MethodElement methodElement) {
        return this.visitExecutableMethod(declaringBean, methodElement, null, null);
    }

    public ExecutableMethodWriter visitExecutableMethod(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName) {
        boolean isSuspend;
        AnnotationMetadata annotationMetadata = methodElement.getAnnotationMetadata();
        String methodName = methodElement.getName();
        List<ParameterElement> argumentTypes = Arrays.asList(methodElement.getSuspendParameters());
        String methodKey = methodName + "(" + argumentTypes.stream().map(p -> p.getType().getName()).collect(Collectors.joining(",")) + ")";
        if (this.methodExecutors.containsKey(methodKey)) {
            return this.methodExecutors.get(methodKey);
        }
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        for (ParameterElement parameterElement : argumentTypes) {
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, parameterElement.getAnnotationMetadata());
        }
        String methodProxyShortName = "$exec" + ++this.methodExecutorIndex;
        String methodExecutorClassName = this.beanDefinitionName + "$" + methodProxyShortName;
        ParameterElement last = (ParameterElement)CollectionUtils.last(argumentTypes);
        boolean bl = isSuspend = last != null && "kotlin.coroutines.Continuation".equals(last.getType().getName());
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{new AnnotationMetadataReference(this.getBeanDefinitionReferenceClassName(), this.annotationMetadata), ((AnnotationMetadataHierarchy)annotationMetadata).getDeclaredMetadata()});
        }
        boolean isInterface = declaringType.getType().isInterface();
        ExecutableMethodWriter executableMethodWriter = new ExecutableMethodWriter(methodExecutorClassName, this.isInterface || isInterface, isInterface && !methodElement.isDefault() || methodElement.isAbstract(), methodElement.isDefault(), isSuspend, this, annotationMetadata, interceptedProxyClassName, interceptedProxyBridgeMethodName);
        executableMethodWriter.visitMethod(declaringType, methodElement);
        this.methodExecutors.put(methodKey, executableMethodWriter);
        this.deferredInjectionPoints.add(() -> {
            if (this.constructorVisitor == null) {
                throw new IllegalStateException("Method visitBeanDefinitionConstructor(..) should be called first!");
            }
            this.constructorVisitor.visitVarInsn(25, 0);
            String methodExecutorInternalName = executableMethodWriter.getInternalName();
            this.constructorVisitor.visitTypeInsn(187, methodExecutorInternalName);
            this.constructorVisitor.visitInsn(89);
            this.constructorVisitor.visitMethodInsn(183, methodExecutorInternalName, "<init>", "()V", false);
            this.pushInvokeMethodOnSuperClass((MethodVisitor)this.constructorVisitor, ADD_EXECUTABLE_METHOD);
        });
        return executableMethodWriter;
    }

    public String toString() {
        return "BeanDefinitionWriter{beanFullClassName='" + this.beanFullClassName + '\'' + '}';
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getBeanSimpleName() {
        return this.beanSimpleClassName;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public void visitConfigBuilderField(ClassElement type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)factoryMethod)) {
            Type builderType = JavaModelUtils.getTypeReference(type);
            this.injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod((String)(builderType.getClassName() + " " + factoryMethod + "()")));
            this.injectMethodVisitor.putField(this.beanType, field, builderType);
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, field, false, annotationMetadata, metadataBuilder, isInterface);
    }

    @Override
    public void visitConfigBuilderMethod(ClassElement type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)factoryMethod)) {
            Type builderType = JavaModelUtils.getTypeReference(type);
            this.injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod((String)(builderType.getClassName() + " " + factoryMethod + "()")));
            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
            String setterName = NameUtils.setterNameFor((String)propertyName);
            this.injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod((String)("void " + setterName + "(" + builderType.getClassName() + ")")));
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, methodName, true, annotationMetadata, metadataBuilder, isInterface);
    }

    @Override
    public void visitConfigBuilderDurationMethod(String prefix, ClassElement returnType, String methodName, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, ClassElement.of(Duration.class), Collections.emptyMap(), true, path);
    }

    @Override
    public void visitConfigBuilderMethod(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, paramType, generics, false, path);
    }

    @Override
    public void visitConfigBuilderEnd() {
        this.currentConfigBuilderState = null;
    }

    @Override
    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.preprocessMethods = shouldPreProcess;
    }

    @Override
    public void visitTypeArguments(Map<String, Map<String, ClassElement>> typeArguments) {
        this.typeArguments = typeArguments;
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.preprocessMethods;
    }

    @Override
    public void visitFieldInjectionPoint(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection) {
        java.lang.reflect.Method methodToInvoke;
        ClassElement genericType = fieldElement.getGenericType();
        if (genericType.isAssignable(Collection.class) || genericType.isArray()) {
            ClassElement typeArgument;
            ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
            methodToInvoke = typeArgument != null ? (typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_FIELD : GET_BEANS_OF_TYPE_FOR_FIELD) : GET_BEAN_FOR_FIELD;
        } else {
            methodToInvoke = genericType.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATION_FOR_FIELD : GET_BEAN_FOR_FIELD;
        }
        this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection, methodToInvoke, false);
    }

    @Override
    public void visitFieldValue(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection, boolean isOptional) {
        this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection, GET_VALUE_FOR_FIELD, isOptional);
    }

    private void visitConfigBuilderMethodInternal(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, boolean isDurationWithTimeUnit, String propertyPath) {
        if (this.currentConfigBuilderState != null) {
            Type builderType = this.currentConfigBuilderState.getType();
            String builderName = this.currentConfigBuilderState.getName();
            boolean isResolveBuilderViaMethodCall = this.currentConfigBuilderState.isMethod();
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
            String propertyName = NameUtils.hyphenate((String)NameUtils.decapitalize((String)methodName.substring(prefix.length())), (boolean)true);
            boolean zeroArgs = paramType == null;
            this.pushGetValueForPathCall(injectMethodVisitor, paramType, propertyName, propertyPath, zeroArgs, generics);
            Label ifEnd = new Label();
            injectMethodVisitor.invokeVirtual(Type.getType(Optional.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"isPresent", (Class[])new Class[0])));
            injectMethodVisitor.push(false);
            injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, ifEnd);
            if (zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, Boolean.TYPE);
                injectMethodVisitor.push(false);
                injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, ifEnd);
            }
            injectMethodVisitor.visitLabel(new Label());
            String methodDescriptor = zeroArgs ? BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList()) : (isDurationWithTimeUnit ? BeanDefinitionWriter.getMethodDescriptor(returnType, Arrays.asList(ClassElement.of(Long.TYPE), ClassElement.of(TimeUnit.class))) : BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.singleton(paramType)));
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label exceptionHandler = new Label();
            injectMethodVisitor.visitTryCatchBlock(tryStart, tryEnd, exceptionHandler, Type.getInternalName(NoSuchMethodError.class));
            injectMethodVisitor.visitLabel(tryStart);
            injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            if (isResolveBuilderViaMethodCall) {
                String desc = builderType.getClassName() + " " + builderName + "()";
                injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod((String)desc));
            } else {
                injectMethodVisitor.getField(this.beanType, builderName, builderType);
            }
            if (!zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, paramType);
            }
            boolean isInterface = this.currentConfigBuilderState.isInterface();
            if (isDurationWithTimeUnit) {
                injectMethodVisitor.invokeVirtual(Type.getType(Duration.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Duration.class, (String)"toMillis", (Class[])new Class[0])));
                Type tu = Type.getType(TimeUnit.class);
                injectMethodVisitor.getStatic(tu, "MILLISECONDS", tu);
            }
            if (isInterface) {
                injectMethodVisitor.invokeInterface(builderType, new Method(methodName, methodDescriptor));
            } else {
                injectMethodVisitor.invokeVirtual(builderType, new Method(methodName, methodDescriptor));
            }
            if (returnType != PrimitiveElement.VOID) {
                injectMethodVisitor.pop();
            }
            injectMethodVisitor.visitJumpInsn(167, tryEnd);
            injectMethodVisitor.visitLabel(exceptionHandler);
            injectMethodVisitor.pop();
            injectMethodVisitor.visitLabel(tryEnd);
            injectMethodVisitor.visitLabel(ifEnd);
        }
    }

    private void pushOptionalGet(GeneratorAdapter injectMethodVisitor) {
        injectMethodVisitor.visitVarInsn(25, this.optionalInstanceIndex);
        injectMethodVisitor.invokeVirtual(Type.getType(Optional.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)"get", (Class[])new Class[0])));
    }

    private void pushGetValueForPathCall(GeneratorAdapter injectMethodVisitor, ClassElement propertyType, String propertyName, String propertyPath, boolean zeroArgs, Map<String, ClassElement> generics) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        if (zeroArgs) {
            BeanDefinitionWriter.buildArgument(injectMethodVisitor, propertyName, Type.getType(Boolean.class));
        } else {
            BeanDefinitionWriter.buildArgumentWithGenerics(this.beanDefinitionType, this.classWriter, injectMethodVisitor, propertyName, JavaModelUtils.getTypeReference(propertyType), propertyType, generics, new HashSet<String>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(propertyPath);
        injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)GET_VALUE_FOR_PATH));
        injectMethodVisitor.visitVarInsn(58, this.optionalInstanceIndex);
        injectMethodVisitor.visitVarInsn(25, this.optionalInstanceIndex);
    }

    private void buildFactoryMethodClassConstructor(ClassElement factoryClass, ClassElement producedType, String methodName, AnnotationMetadata methodAnnotationMetadata, List<ParameterElement> argumentTypes) {
        Type factoryTypeRef = JavaModelUtils.getTypeReference(factoryClass);
        Type producedTypeRef = JavaModelUtils.getTypeReference(producedType);
        this.constructorVisitor = this.buildProtectedConstructor(BEAN_DEFINITION_METHOD_CONSTRUCTOR);
        GeneratorAdapter defaultConstructor = new GeneratorAdapter((MethodVisitor)this.startConstructor((ClassVisitor)this.classWriter), 1, "<init>", "()V");
        defaultConstructor.loadThis();
        defaultConstructor.push(producedTypeRef);
        defaultConstructor.push(factoryTypeRef);
        defaultConstructor.push(methodName);
        this.pushAnnotationMetadata(methodAnnotationMetadata, defaultConstructor);
        defaultConstructor.push(false);
        if (CollectionUtils.isNotEmpty(argumentTypes)) {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanDefinitionType.getClassName(), this.beanDefinitionType, this.classWriter, defaultConstructor, argumentTypes, this.loadTypeMethods);
        } else {
            defaultConstructor.visitInsn(1);
        }
        defaultConstructor.invokeConstructor(this.beanDefinitionType, BEAN_DEFINITION_METHOD_CONSTRUCTOR);
        defaultConstructor.visitInsn(177);
        defaultConstructor.visitMaxs(13, 1);
        defaultConstructor.visitEnd();
    }

    private void visitFieldInjectionPointInternal(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection, java.lang.reflect.Method methodToInvoke, boolean isValueOptional) {
        AnnotationMetadata annotationMetadata = fieldElement.getAnnotationMetadata();
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        constructorVisitor.loadThis();
        Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(JavaModelUtils.getTypeReference(fieldElement.getType()));
        constructorVisitor.push(fieldElement.getName());
        this.pushAnnotationMetadata(annotationMetadata, constructorVisitor);
        Map<String, ClassElement> typeArguments = fieldElement.getGenericType().getTypeArguments();
        if (CollectionUtils.isNotEmpty(typeArguments)) {
            BeanDefinitionWriter.pushTypeArgumentElements(this.beanDefinitionType, this.classWriter, constructorVisitor, declaringType.getName(), typeArguments, this.loadTypeMethods);
        } else {
            constructorVisitor.visitInsn(1);
        }
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, ADD_FIELD_INJECTION_POINT_METHOD);
        GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
        Label falseCondition = null;
        if (isValueOptional) {
            Label trueCondition = new Label();
            falseCondition = new Label();
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentFieldIndex);
            injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_VALUE_FOR_FIELD));
            injectMethodVisitor.push(false);
            injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, falseCondition);
            injectMethodVisitor.visitLabel(trueCondition);
        }
        if (!requiresReflection) {
            injectMethodVisitor.visitVarInsn(25, this.injectInstanceIndex);
            injectMethodVisitor.loadThis();
            injectMethodVisitor.visitVarInsn(25, 1);
            injectMethodVisitor.visitVarInsn(25, 2);
            injectMethodVisitor.push(this.currentFieldIndex);
            this.pushInvokeMethodOnSuperClass((MethodVisitor)injectMethodVisitor, methodToInvoke);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, fieldElement.getType());
            injectMethodVisitor.visitFieldInsn(181, declaringTypeRef.getInternalName(), fieldElement.getName(), BeanDefinitionWriter.getTypeDescriptor(fieldElement.getType()));
        } else {
            this.pushInjectMethodForIndex(injectMethodVisitor, this.injectInstanceIndex, this.currentFieldIndex, "injectBeanField");
        }
        if (falseCondition != null) {
            injectMethodVisitor.visitLabel(falseCondition);
        }
        ++this.currentFieldIndex;
    }

    private void pushAnnotationMetadata(AnnotationMetadata annotationMetadata, GeneratorAdapter constructorVisitor) {
        if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
            constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, constructorVisitor, (DefaultAnnotationMetadata)annotationMetadata, this.loadTypeMethods);
        }
    }

    private void addInjectionPointForSetterInternal(AnnotationMetadata fieldAnnotationMetadata, boolean requiresReflection, String setterName, Map<String, ClassElement> genericTypes, Type declaringTypeRef) {
        GeneratorAdapter constructorVisitor = this.constructorVisitor;
        constructorVisitor.visitVarInsn(25, 0);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(setterName);
        BeanDefinitionWriter.pushTypeArgumentElements(this.beanDefinitionType, this.classWriter, constructorVisitor, declaringTypeRef.getClassName(), genericTypes, this.loadTypeMethods);
        if (fieldAnnotationMetadata == null || fieldAnnotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
            constructorVisitor.visitInsn(1);
        } else {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, constructorVisitor, (DefaultAnnotationMetadata)fieldAnnotationMetadata, this.loadTypeMethods);
        }
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, ADD_METHOD_INJECTION_POINT_METHOD);
    }

    private void visitMethodInjectionPointInternal(MethodVisitData methodVisitData, GeneratorAdapter constructorVisitor, GeneratorAdapter injectMethodVisitor, int injectInstanceIndex, java.lang.reflect.Method addMethodInjectionPointMethod) {
        MethodElement methodElement = methodVisitData.getMethodElement();
        AnnotationMetadata annotationMetadata = methodElement.getAnnotationMetadata();
        List<ParameterElement> argumentTypes = Arrays.asList(methodElement.getParameters());
        TypedElement declaringType = methodVisitData.beanType;
        String methodName = methodElement.getName();
        boolean requiresReflection = methodVisitData.requiresReflection;
        ClassElement returnType = methodElement.getReturnType();
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        boolean hasArguments = methodElement.hasParameters();
        int argCount = hasArguments ? argumentTypes.size() : 0;
        Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        constructorVisitor.visitVarInsn(25, 0);
        constructorVisitor.push(declaringTypeRef);
        constructorVisitor.push(methodName);
        if (hasArguments) {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(declaringType.getName(), this.beanDefinitionType, this.classWriter, constructorVisitor, argumentTypes, this.loadTypeMethods);
            for (ParameterElement value : argumentTypes) {
                DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value.getAnnotationMetadata());
            }
        } else {
            constructorVisitor.visitInsn(1);
        }
        this.pushAnnotationMetadata(this.annotationMetadata, constructorVisitor);
        constructorVisitor.visitInsn(requiresReflection ? 4 : 3);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)constructorVisitor, addMethodInjectionPointMethod);
        if (!requiresReflection) {
            String methodDescriptor;
            injectMethodVisitor.visitVarInsn(25, injectInstanceIndex);
            if (hasArguments) {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, argumentTypes);
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i = 0; i < argCount; ++i) {
                    ParameterElement entry = argIterator.next();
                    AnnotationMetadata argMetadata = entry.getAnnotationMetadata();
                    injectMethodVisitor.visitVarInsn(25, 0);
                    injectMethodVisitor.visitVarInsn(25, 1);
                    injectMethodVisitor.visitVarInsn(25, 2);
                    injectMethodVisitor.push(this.currentMethodIndex);
                    injectMethodVisitor.push(i);
                    java.lang.reflect.Method methodToInvoke = argMetadata.hasDeclaredStereotype(Value.class) || argMetadata.hasDeclaredStereotype(Property.class) ? GET_VALUE_FOR_METHOD_ARGUMENT : this.getInjectMethodForParameter(entry);
                    this.pushInvokeMethodOnSuperClass((MethodVisitor)injectMethodVisitor, methodToInvoke);
                    BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
                }
            } else {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList());
            }
            injectMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeRef.getInternalName(), methodName, methodDescriptor, this.isInterface);
            if (this.isConfigurationProperties && returnType != PrimitiveElement.VOID) {
                injectMethodVisitor.pop();
            }
        } else {
            this.pushInjectMethodForIndex(injectMethodVisitor, injectInstanceIndex, this.currentMethodIndex, "injectBeanMethod");
        }
        ++this.currentMethodIndex;
    }

    private java.lang.reflect.Method getInjectMethodForParameter(ParameterElement parameterElement) {
        java.lang.reflect.Method methodToInvoke;
        ClassElement genericType = parameterElement.getGenericType();
        if (genericType.isAssignable(Collection.class) || genericType.isArray()) {
            ClassElement typeArgument;
            ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
            methodToInvoke = typeArgument != null ? (typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_METHOD_ARGUMENT : GET_BEANS_OF_TYPE_FOR_METHOD_ARGUMENT) : GET_BEAN_FOR_METHOD_ARGUMENT;
        } else {
            methodToInvoke = genericType.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATION_FOR_METHOD_ARGUMENT : GET_BEAN_FOR_METHOD_ARGUMENT;
        }
        return methodToInvoke;
    }

    private void pushInvokeMethodOnSuperClass(MethodVisitor constructorVisitor, java.lang.reflect.Method methodToInvoke) {
        constructorVisitor.visitMethodInsn(183, this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), methodToInvoke.getName(), Type.getMethodDescriptor((java.lang.reflect.Method)methodToInvoke), false);
    }

    private void resolveBeanOrValueForSetter(Type declaringTypeRef, ClassElement returnType, String setterName, ClassElement fieldType, java.lang.reflect.Method resolveMethod, boolean isValueOptional) {
        GeneratorAdapter injectVisitor = this.injectMethodVisitor;
        Label falseCondition = null;
        if (isValueOptional) {
            Label trueCondition = new Label();
            falseCondition = new Label();
            injectVisitor.loadThis();
            injectVisitor.loadArg(0);
            injectVisitor.loadArg(1);
            injectVisitor.push(this.currentMethodIndex);
            injectVisitor.push(0);
            injectVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_VALUE_FOR_METHOD_ARGUMENT));
            injectVisitor.push(false);
            injectVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, falseCondition);
            injectVisitor.visitLabel(trueCondition);
        }
        injectVisitor.visitVarInsn(25, this.injectInstanceIndex);
        String methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.singletonList(fieldType));
        this.injectMethodVisitor.visitVarInsn(25, 0);
        this.injectMethodVisitor.visitVarInsn(25, 1);
        this.injectMethodVisitor.visitVarInsn(25, 2);
        this.injectMethodVisitor.push(this.currentMethodIndex);
        injectVisitor.push(0);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)injectVisitor, resolveMethod);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectVisitor, fieldType);
        injectVisitor.visitMethodInsn(182, declaringTypeRef.getInternalName(), setterName, methodDescriptor, false);
        if (returnType != PrimitiveElement.VOID) {
            injectVisitor.pop();
        }
        if (falseCondition != null) {
            injectVisitor.visitLabel(falseCondition);
        }
    }

    private void visitInjectMethodDefinition() {
        if (this.injectMethodVisitor == null) {
            String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(4, "injectBean", desc, null, null), 4, "injectBean", desc);
            if (this.isConfigurationProperties) {
                injectMethodVisitor.loadThis();
                injectMethodVisitor.loadArg(0);
                injectMethodVisitor.loadArg(1);
                injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod((java.lang.reflect.Method)CONTAINS_PROPERTIES_METHOD));
                injectMethodVisitor.push(false);
                this.injectEnd = new Label();
                injectMethodVisitor.ifCmp(Type.BOOLEAN_TYPE, 153, this.injectEnd);
                injectMethodVisitor.visitLabel(new Label());
            }
            injectMethodVisitor.visitVarInsn(25, 3);
            injectMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.injectInstanceIndex = this.pushNewInjectLocalVariable();
            injectMethodVisitor.visitInsn(1);
            this.optionalInstanceIndex = this.pushNewInjectLocalVariable();
        }
    }

    private void visitPostConstructMethodDefinition() {
        if (this.postConstructMethodVisitor == null) {
            GeneratorAdapter postConstructMethodVisitor;
            this.interfaceTypes.add(InitializingBeanDefinition.class);
            this.postConstructMethodVisitor = postConstructMethodVisitor = this.newLifeCycleMethod("initialize");
            postConstructMethodVisitor.visitVarInsn(25, 3);
            postConstructMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.postConstructInstanceIndex = this.pushNewPostConstructLocalVariable();
            this.invokeSuperInjectMethod((MethodVisitor)postConstructMethodVisitor, POST_CONSTRUCT_METHOD);
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)this.buildMethodVisitor, "initialize");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.beanType);
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
        }
    }

    private void pushInjectMethodForIndex(GeneratorAdapter methodVisitor, int instanceIndex, int injectIndex, String injectMethodName) {
        java.lang.reflect.Method injectBeanMethod = ReflectionUtils.getRequiredMethod(AbstractBeanDefinition.class, (String)injectMethodName, (Class[])new Class[]{BeanResolutionContext.class, DefaultBeanContext.class, Integer.TYPE, Object.class});
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)methodVisitor, DefaultBeanContext.class);
        methodVisitor.push(injectIndex);
        methodVisitor.visitVarInsn(25, instanceIndex);
        this.pushInvokeMethodOnSuperClass((MethodVisitor)methodVisitor, injectBeanMethod);
    }

    private void visitPreDestroyMethodDefinition() {
        if (this.preDestroyMethodVisitor == null) {
            GeneratorAdapter preDestroyMethodVisitor;
            this.interfaceTypes.add(DisposableBeanDefinition.class);
            this.preDestroyMethodVisitor = preDestroyMethodVisitor = this.newLifeCycleMethod("dispose");
            preDestroyMethodVisitor.visitVarInsn(25, 3);
            preDestroyMethodVisitor.visitTypeInsn(192, this.beanType.getInternalName());
            this.preDestroyInstanceIndex = this.pushNewPreDestroyLocalVariable();
            this.invokeSuperInjectMethod((MethodVisitor)preDestroyMethodVisitor, PRE_DESTROY_METHOD);
        }
    }

    private GeneratorAdapter newLifeCycleMethod(String methodName) {
        String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
        return new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, desc, BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName)), null), 1, methodName, desc);
    }

    private void finalizeBuildMethod() {
        if (!this.providedBeanClassName.equals(this.beanFullClassName)) {
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            this.buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
            this.buildMethodVisitor.visitMethodInsn(182, this.beanType.getInternalName(), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), false);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.providedType);
            this.buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)this.buildMethodVisitor, "injectAnother");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.providedType);
        }
    }

    private void finalizeInjectMethod() {
        if (this.injectEnd != null) {
            this.injectMethodVisitor.visitLabel(this.injectEnd);
        }
        this.invokeSuperInjectMethod((MethodVisitor)this.injectMethodVisitor, INJECT_BEAN_METHOD);
        this.injectMethodVisitor.visitInsn(176);
    }

    private void invokeSuperInjectMethod(MethodVisitor methodVisitor, java.lang.reflect.Method methodToInvoke) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        BeanDefinitionWriter.pushCastToType(methodVisitor, DefaultBeanContext.class);
        methodVisitor.visitVarInsn(25, 3);
        this.pushInvokeMethodOnSuperClass(methodVisitor, methodToInvoke);
    }

    private void visitBuildFactoryMethodDefinition(ClassElement factoryClass, MethodElement factoryMethod) {
        if (this.buildMethodVisitor == null) {
            ParameterElement[] parameters = factoryMethod.getParameters();
            List<ParameterElement> parameterList = Arrays.asList(parameters);
            boolean isParametrized = this.isParametrized(factoryMethod);
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            buildMethodVisitor.visitVarInsn(25, 2);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, DefaultBeanContext.class);
            buildMethodVisitor.visitVarInsn(25, 1);
            Type factoryType = JavaModelUtils.getTypeReference(factoryClass);
            buildMethodVisitor.visitLdcInsn((Object)factoryType);
            java.lang.reflect.Method getBeanMethod = ReflectionUtils.getRequiredInternalMethod(DefaultBeanContext.class, (String)"getBean", (Class[])new Class[]{BeanResolutionContext.class, Class.class});
            buildMethodVisitor.visitMethodInsn(182, Type.getInternalName(DefaultBeanContext.class), "getBean", Type.getMethodDescriptor((java.lang.reflect.Method)getBeanMethod), false);
            int factoryVar = this.pushNewBuildLocalVariable();
            buildMethodVisitor.visitVarInsn(25, factoryVar);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, factoryClass);
            if (parameterList.isEmpty()) {
                buildMethodVisitor.visitMethodInsn(182, factoryType.getInternalName(), factoryMethod.getName(), Type.getMethodDescriptor((Type)this.beanType, (Type[])new Type[0]), false);
            } else {
                this.pushConstructorArguments(buildMethodVisitor, factoryMethod);
                String methodDescriptor = BeanDefinitionWriter.getMethodDescriptorForReturnType(this.beanType, parameterList);
                buildMethodVisitor.visitMethodInsn(182, factoryType.getInternalName(), factoryMethod.getName(), methodDescriptor, false);
            }
            this.buildInstanceIndex = this.pushNewBuildLocalVariable();
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)buildMethodVisitor, "injectBean");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
            buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        }
    }

    private void visitBuildMethodDefinition(MethodElement constructor) {
        if (this.buildMethodVisitor == null) {
            boolean isParametrized = this.isParametrized(constructor);
            List<ParameterElement> parameters = Arrays.asList(constructor.getParameters());
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            buildMethodVisitor.visitTypeInsn(187, this.beanType.getInternalName());
            buildMethodVisitor.visitInsn(89);
            this.pushConstructorArguments(buildMethodVisitor, constructor);
            String constructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(parameters);
            buildMethodVisitor.visitMethodInsn(183, this.beanType.getInternalName(), "<init>", constructorDescriptor, false);
            this.buildInstanceIndex = this.pushNewBuildLocalVariable();
            this.pushBeanDefinitionMethodInvocation((MethodVisitor)buildMethodVisitor, "injectBean");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
            buildMethodVisitor.visitVarInsn(58, this.buildInstanceIndex);
            buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        }
    }

    private void pushConstructorArguments(GeneratorAdapter buildMethodVisitor, MethodElement constructor) {
        ParameterElement[] parameters = constructor.getParameters();
        int size = parameters.length;
        if (size > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                ParameterElement parameter = parameters[i];
                this.pushConstructorArgument(buildMethodVisitor, parameter.getName(), parameter, parameter.getAnnotationMetadata(), i);
            }
        }
    }

    private void pushConstructorArgument(GeneratorAdapter buildMethodVisitor, String argumentName, ParameterElement argumentType, AnnotationMetadata annotationMetadata, int index) {
        if (this.isAnnotatedWithParameter(annotationMetadata) && this.argsIndex > -1) {
            buildMethodVisitor.visitVarInsn(25, this.argsIndex);
            buildMethodVisitor.push(argumentName);
            buildMethodVisitor.invokeInterface(Type.getType(Map.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"get", (Class[])new Class[]{Object.class})));
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
        } else {
            java.lang.reflect.Method methodToInvoke;
            buildMethodVisitor.visitVarInsn(25, 0);
            buildMethodVisitor.visitVarInsn(25, 1);
            buildMethodVisitor.visitVarInsn(25, 2);
            buildMethodVisitor.push(index);
            if (this.isValueType(annotationMetadata)) {
                methodToInvoke = GET_VALUE_FOR_CONSTRUCTOR_ARGUMENT;
            } else {
                ClassElement genericType = argumentType.getGenericType();
                if (genericType.isAssignable(Collection.class) || genericType.isArray()) {
                    ClassElement typeArgument;
                    ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
                    methodToInvoke = typeArgument != null ? (typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_CONSTRUCTOR_ARGUMENT : GET_BEANS_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT) : GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
                } else {
                    methodToInvoke = genericType.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATION_FOR_CONSTRUCTOR_ARGUMENT : GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
                }
            }
            this.pushInvokeMethodOnSuperClass((MethodVisitor)buildMethodVisitor, methodToInvoke);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
        }
    }

    private boolean isValueType(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredStereotype(Value.class) || annotationMetadata.hasDeclaredStereotype(Property.class);
        }
        return false;
    }

    private boolean isAnnotatedWithParameter(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredAnnotation(Parameter.class);
        }
        return false;
    }

    private boolean isParametrized(MethodElement constructor) {
        return Arrays.stream(constructor.getParameters()).anyMatch(p -> this.isAnnotatedWithParameter(p.getAnnotationMetadata()));
    }

    private void defineBuilderMethod(boolean isParametrized) {
        String methodSignature;
        String methodDescriptor;
        if (isParametrized) {
            this.superType = TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION;
            this.argsIndex = this.buildMethodLocalCount++;
        }
        if (isParametrized) {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName(), Map.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanDefinition.class.getName(), this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(Map.class.getName()));
        } else {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.providedBeanClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanDefinition.class.getName(), this.providedBeanClassName));
        }
        String methodName = isParametrized ? "doBuild" : "build";
        this.buildMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, methodDescriptor, methodSignature, null), 1, methodName, methodDescriptor);
    }

    private void pushBeanDefinitionMethodInvocation(MethodVisitor buildMethodVisitor, String methodName) {
        buildMethodVisitor.visitVarInsn(25, 0);
        buildMethodVisitor.visitVarInsn(25, 1);
        buildMethodVisitor.visitVarInsn(25, 2);
        buildMethodVisitor.visitVarInsn(25, this.buildInstanceIndex);
        buildMethodVisitor.visitMethodInsn(182, this.beanDefinitionInternalName, methodName, Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(BeanResolutionContext.class), Type.getType(BeanContext.class), Type.getType(Object.class)}), false);
    }

    private int pushNewBuildLocalVariable() {
        this.buildMethodVisitor.visitVarInsn(58, this.buildMethodLocalCount);
        return this.buildMethodLocalCount++;
    }

    private int pushNewInjectLocalVariable() {
        this.injectMethodVisitor.visitVarInsn(58, this.injectMethodLocalCount);
        return this.injectMethodLocalCount++;
    }

    private int pushNewPostConstructLocalVariable() {
        this.postConstructMethodVisitor.visitVarInsn(58, this.postConstructMethodLocalCount);
        return this.postConstructMethodLocalCount++;
    }

    private int pushNewPreDestroyLocalVariable() {
        this.preDestroyMethodVisitor.visitVarInsn(58, this.preDestroyMethodLocalCount);
        return this.preDestroyMethodLocalCount++;
    }

    private void visitBeanDefinitionConstructorInternal(MethodElement methodElement, boolean requiresReflection) {
        if (this.constructorVisitor == null) {
            GeneratorAdapter protectedConstructor;
            AnnotationMetadata constructorMetadata = methodElement.getAnnotationMetadata();
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, constructorMetadata);
            ParameterElement[] parameters = methodElement.getParameters();
            List<ParameterElement> parameterList = Arrays.asList(parameters);
            Optional<AnnotationMetadata> argumentQualifier = parameterList.stream().filter(p -> this.isAnnotatedWithParameter(p.getAnnotationMetadata())).map(AnnotationMetadataProvider::getAnnotationMetadata).findFirst();
            boolean isParametrized = argumentQualifier.isPresent();
            if (isParametrized) {
                this.superType = TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION;
            }
            Method constructorMethod = Method.getMethod(CONSTRUCTOR_ABSTRACT_BEAN_DEFINITION);
            this.constructorVisitor = protectedConstructor = new GeneratorAdapter(this.classWriter.visitMethod(4, "<init>", constructorMethod.getDescriptor(), null, null), 4, "<init>", constructorMethod.getDescriptor());
            Type[] beanDefinitionConstructorArgumentTypes = constructorMethod.getArgumentTypes();
            protectedConstructor.loadThis();
            for (int i = 0; i < beanDefinitionConstructorArgumentTypes.length; ++i) {
                protectedConstructor.loadArg(i);
            }
            protectedConstructor.invokeConstructor(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION : this.superType, BEAN_DEFINITION_CLASS_CONSTRUCTOR);
            GeneratorAdapter defaultConstructor = this.startConstructor((ClassVisitor)this.classWriter);
            GeneratorAdapter defaultConstructorVisitor = new GeneratorAdapter((MethodVisitor)defaultConstructor, 1, "<init>", "()V");
            defaultConstructor.visitVarInsn(25, 0);
            defaultConstructor.visitLdcInsn((Object)this.beanType);
            if (constructorMetadata == AnnotationMetadata.EMPTY_METADATA) {
                defaultConstructor.visitInsn(1);
            } else if (constructorMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataWriter.instantiateNewMetadataHierarchy(this.beanDefinitionType, this.classWriter, defaultConstructor, (AnnotationMetadataHierarchy)constructorMetadata, this.loadTypeMethods);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, defaultConstructor, (DefaultAnnotationMetadata)constructorMetadata, this.loadTypeMethods);
            }
            defaultConstructor.visitInsn(requiresReflection ? 4 : 3);
            if (parameterList.isEmpty()) {
                defaultConstructor.visitInsn(1);
            } else {
                BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanFullClassName, this.beanDefinitionType, this.classWriter, defaultConstructorVisitor, parameterList, this.loadTypeMethods);
                for (ParameterElement value : parameterList) {
                    DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value.getAnnotationMetadata());
                }
            }
            defaultConstructorVisitor.invokeConstructor(this.beanDefinitionType, BEAN_DEFINITION_CLASS_CONSTRUCTOR);
            defaultConstructorVisitor.visitInsn(177);
            defaultConstructorVisitor.visitMaxs(13, 1);
            defaultConstructorVisitor.visitEnd();
        }
    }

    private GeneratorAdapter buildProtectedConstructor(Method constructorType) {
        GeneratorAdapter protectedConstructor = new GeneratorAdapter(this.classWriter.visitMethod(4, "<init>", constructorType.getDescriptor(), null, null), 4, "<init>", constructorType.getDescriptor());
        Type[] arguments = constructorType.getArgumentTypes();
        protectedConstructor.loadThis();
        for (int i = 0; i < arguments.length; ++i) {
            protectedConstructor.loadArg(i);
        }
        if (this.isSuperFactory) {
            protectedConstructor.invokeConstructor(TYPE_ABSTRACT_BEAN_DEFINITION, constructorType);
        } else {
            protectedConstructor.invokeConstructor(this.superType, constructorType);
        }
        return protectedConstructor;
    }

    private String generateBeanDefSig(String typeParameter) {
        SignatureWriter sv = new SignatureWriter();
        this.visitSuperTypeParameters((SignatureVisitor)sv, typeParameter);
        String beanTypeInternalName = BeanDefinitionWriter.getInternalName(typeParameter);
        for (Class interfaceType : this.interfaceTypes) {
            SignatureVisitor bfi = sv.visitInterface();
            bfi.visitClassType(Type.getInternalName((Class)interfaceType));
            SignatureVisitor iisv = bfi.visitTypeArgument('=');
            iisv.visitClassType(beanTypeInternalName);
            iisv.visitEnd();
            bfi.visitEnd();
        }
        return sv.toString();
    }

    private void visitSuperTypeParameters(SignatureVisitor sv, String ... typeParameters) {
        SignatureVisitor psv = sv.visitSuperclass();
        psv.visitClassType(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName());
        if (this.superType == TYPE_ABSTRACT_BEAN_DEFINITION || this.superType == TYPE_ABSTRACT_PARAMETRIZED_BEAN_DEFINITION || this.isSuperFactory) {
            for (String typeParameter : typeParameters) {
                SignatureVisitor ppsv = psv.visitTypeArgument('=');
                String beanTypeInternalName = BeanDefinitionWriter.getInternalName(typeParameter);
                ppsv.visitClassType(beanTypeInternalName);
                ppsv.visitEnd();
            }
        }
        psv.visitEnd();
    }

    private static java.lang.reflect.Method getBeanLookupMethod(String methodName) {
        return ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)methodName, (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE});
    }

    private static java.lang.reflect.Method getBeanLookupMethodForArgument(String methodName) {
        return ReflectionUtils.getRequiredInternalMethod(AbstractBeanDefinition.class, (String)methodName, (Class[])new Class[]{BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE});
    }

    @Internal
    public static final class MethodVisitData {
        private final TypedElement beanType;
        private final boolean requiresReflection;
        private final MethodElement methodElement;

        MethodVisitData(TypedElement beanType, MethodElement methodElement, boolean requiresReflection) {
            this.beanType = beanType;
            this.requiresReflection = requiresReflection;
            this.methodElement = methodElement;
        }

        public MethodElement getMethodElement() {
            return this.methodElement;
        }

        public TypedElement getBeanType() {
            return this.beanType;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }
    }
}

