/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.AbstractBeanProperty;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
class BeanPropertyWriter
extends AbstractClassFileWriter
implements Named {
    private static final Type TYPE_BEAN_PROPERTY = Type.getType(AbstractBeanProperty.class);
    private static final Method METHOD_READ_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanProperty.class, (String)"readInternal", (Class[])new Class[]{Object.class}));
    private static final Method METHOD_WRITE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanProperty.class, (String)"writeInternal", (Class[])new Class[]{Object.class, Object.class}));
    private static final Method METHOD_WITH_VALUE_INTERNAL = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanProperty.class, (String)"withValueInternal", (Class[])new Class[]{Object.class, Object.class}));
    private static final Method METHOD_GET_BEAN = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(BeanProperty.class, (String)"getDeclaringBean", (Class[])new Class[0]));
    private static final Method METHOD_INSTANTIATE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(BeanIntrospection.class, (String)"instantiate", (Class[])new Class[]{Object[].class}));
    private final Type propertyType;
    private final String propertyName;
    private final AnnotationMetadata annotationMetadata;
    private final Type type;
    private final ClassWriter classWriter;
    private final Map<String, ClassElement> typeArguments;
    private final Type beanType;
    private final boolean readOnly;
    private final boolean isMutable;
    private final MethodElement readMethod;
    private final MethodElement writeMethod;
    private final MethodElement withMethod;
    private final HashMap<String, GeneratorAdapter> loadTypeMethods = new HashMap();
    private final TypedElement typeElement;
    private final ClassElement declaringElement;
    private final Type propertyGenericType;
    private final BeanIntrospectionWriter beanIntrospectionWriter;

    BeanPropertyWriter(@NonNull BeanIntrospectionWriter introspectionWriter, @NonNull TypedElement typeElement, @NonNull Type propertyType, @NonNull Type propertyGenericType, @NonNull String propertyName, @Nullable MethodElement readMethod, @Nullable MethodElement writeMethod, @Nullable MethodElement withMethod, boolean isReadOnly, int index, @Nullable AnnotationMetadata annotationMetadata, @Nullable Map<String, ClassElement> typeArguments) {
        super(introspectionWriter.getOriginatingElements());
        this.beanIntrospectionWriter = introspectionWriter;
        Type introspectionType = introspectionWriter.getIntrospectionType();
        this.declaringElement = introspectionWriter.getClassElement();
        this.typeElement = typeElement;
        this.beanType = introspectionWriter.getBeanType();
        this.propertyType = propertyType;
        this.propertyGenericType = propertyGenericType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.withMethod = withMethod;
        this.propertyName = propertyName;
        this.readOnly = isReadOnly;
        this.isMutable = !this.readOnly || this.hasAssociatedConstructorArgument();
        this.annotationMetadata = annotationMetadata == AnnotationMetadata.EMPTY_METADATA ? null : annotationMetadata;
        this.type = JavaModelUtils.getTypeReference(ClassElement.of(introspectionType.getClassName() + "$$" + index));
        this.classWriter = new ClassWriter(3);
        this.typeArguments = CollectionUtils.isNotEmpty(typeArguments) ? typeArguments : null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    @NonNull
    public String getName() {
        return this.type.getClassName();
    }

    @NonNull
    public String getPropertyName() {
        return this.propertyName;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        try (OutputStream classOutput = classWriterOutputVisitor.visitClass(this.getName(), this.getOriginatingElements());){
            this.startFinalClass((ClassVisitor)this.classWriter, this.type.getInternalName(), TYPE_BEAN_PROPERTY);
            this.writeConstructor();
            this.writeReadMethod();
            this.writeWriteMethod();
            if (this.readOnly) {
                GeneratorAdapter isReadOnly = this.startPublicFinalMethodZeroArgs(this.classWriter, Boolean.TYPE, "isReadOnly");
                isReadOnly.push(true);
                isReadOnly.returnValue();
                isReadOnly.visitMaxs(1, 1);
                isReadOnly.endMethod();
            }
            if (this.writeMethod != null && this.readMethod == null) {
                GeneratorAdapter isWriteOnly = this.startPublicFinalMethodZeroArgs(this.classWriter, Boolean.TYPE, "isWriteOnly");
                isWriteOnly.push(true);
                isWriteOnly.returnValue();
                isWriteOnly.visitMaxs(1, 1);
                isWriteOnly.endMethod();
            }
            boolean isMutable = this.isMutable;
            String nonMutableMessage = "Cannot mutate property [" + this.getPropertyName() + "] that is not mutable via a setter method or constructor argument for type: " + this.beanType.getClassName();
            if (isMutable) {
                GeneratorAdapter withValueMethod;
                if (this.writeMethod != null) {
                    withValueMethod = this.startPublicMethod(this.classWriter, METHOD_WITH_VALUE_INTERNAL);
                    withValueMethod.loadThis();
                    withValueMethod.loadArgs();
                    withValueMethod.invokeVirtual(this.type, METHOD_WRITE_INTERNAL);
                    withValueMethod.loadArg(0);
                    withValueMethod.returnValue();
                    withValueMethod.visitMaxs(1, 1);
                    withValueMethod.endMethod();
                } else if (this.withMethod != null) {
                    withValueMethod = this.startPublicMethod(this.classWriter, METHOD_WITH_VALUE_INTERNAL);
                    withValueMethod.loadArg(0);
                    BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod, this.beanType);
                    withValueMethod.loadArg(1);
                    BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod, this.propertyType);
                    this.invokeMethod(withValueMethod, this.withMethod);
                    withValueMethod.returnValue();
                    withValueMethod.visitMaxs(1, 1);
                    withValueMethod.endMethod();
                } else {
                    Map<String, BeanPropertyWriter> propertyDefinitions = this.beanIntrospectionWriter.getPropertyDefinitions();
                    MethodElement constructor = this.beanIntrospectionWriter.getConstructor();
                    Object[] constructorArguments = null;
                    if (constructor != null) {
                        ParameterElement[] parameters = constructor.getParameters();
                        constructorArguments = new Object[parameters.length];
                        for (int i = 0; i < parameters.length; ++i) {
                            ParameterElement parameter = parameters[i];
                            BeanPropertyWriter propertyWriter = propertyDefinitions.get(parameter.getName());
                            if (propertyWriter == this) {
                                constructorArguments[i] = this;
                                continue;
                            }
                            if (propertyWriter != null) {
                                MethodElement readMethod = propertyWriter.readMethod;
                                if (readMethod != null) {
                                    if (readMethod.getGenericReturnType().isAssignable(parameter.getGenericType())) {
                                        constructorArguments[i] = readMethod;
                                        continue;
                                    }
                                    isMutable = false;
                                    nonMutableMessage = "Cannot create copy of type [" + this.beanType.getClassName() + "]. Property of type [" + readMethod.getGenericReturnType().getName() + "] is not assignable to constructor argument [" + parameter.getName() + "]";
                                    continue;
                                }
                                isMutable = false;
                                nonMutableMessage = "Cannot create copy of type [" + this.beanType.getClassName() + "]. Constructor contains argument [" + parameter.getName() + "] that is not a readable property";
                                break;
                            }
                            isMutable = false;
                            nonMutableMessage = "Cannot create copy of type [" + this.beanType.getClassName() + "]. Constructor contains argument [" + parameter.getName() + "] that is not a readable property";
                            break;
                        }
                    }
                    if (isMutable) {
                        Set readMethods;
                        GeneratorAdapter withValueMethod2 = this.startPublicMethod(this.classWriter, METHOD_WITH_VALUE_INTERNAL);
                        withValueMethod2.loadThis();
                        withValueMethod2.invokeVirtual(this.type, METHOD_GET_BEAN);
                        if (constructorArguments != null) {
                            int len = constructorArguments.length;
                            BeanPropertyWriter.pushNewArray(withValueMethod2, Object.class, len);
                            readMethods = new HashSet(len);
                            for (int i = 0; i < len; ++i) {
                                Object constructorArgument = constructorArguments[i];
                                BeanPropertyWriter.pushStoreInArray(withValueMethod2, i, len, () -> {
                                    if (constructorArgument instanceof BeanPropertyWriter) {
                                        withValueMethod2.loadArg(1);
                                    } else {
                                        MethodElement readMethod = (MethodElement)constructorArgument;
                                        readMethods.add(readMethod);
                                        withValueMethod2.loadArg(0);
                                        BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod2, this.beanType);
                                        ClassElement returnType = this.invokeReadMethod(withValueMethod2, readMethod);
                                        BeanPropertyWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)withValueMethod2);
                                    }
                                });
                            }
                        } else {
                            BeanPropertyWriter.pushNewArray(withValueMethod2, Object.class, 0);
                            readMethods = Collections.emptySet();
                        }
                        withValueMethod2.invokeInterface(Type.getType(BeanIntrospection.class), METHOD_INSTANTIATE);
                        List readWriteProps = propertyDefinitions.values().stream().filter(bwp -> bwp.writeMethod != null && bwp.readMethod != null && !readMethods.contains(bwp.readMethod)).collect(Collectors.toList());
                        if (!readWriteProps.isEmpty()) {
                            int beanTypeLocal = withValueMethod2.newLocal(this.beanType);
                            withValueMethod2.storeLocal(beanTypeLocal);
                            for (BeanPropertyWriter readWriteProp : readWriteProps) {
                                MethodElement writeMethod = readWriteProp.writeMethod;
                                MethodElement readMethod = readWriteProp.readMethod;
                                withValueMethod2.loadLocal(beanTypeLocal);
                                BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod2, this.beanType);
                                withValueMethod2.loadArg(0);
                                BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod2, this.beanType);
                                this.invokeReadMethod(withValueMethod2, readMethod);
                                ClassElement writeReturnType = writeMethod.getReturnType();
                                String methodDescriptor = BeanPropertyWriter.getMethodDescriptor(writeReturnType, Arrays.asList(writeMethod.getParameters()));
                                if (this.declaringElement.isInterface()) {
                                    withValueMethod2.invokeInterface(this.beanType, new Method(writeMethod.getName(), methodDescriptor));
                                } else {
                                    withValueMethod2.invokeVirtual(this.beanType, new Method(writeMethod.getName(), methodDescriptor));
                                }
                                if (writeReturnType.getName().equals("void")) continue;
                                withValueMethod2.pop();
                            }
                            withValueMethod2.loadLocal(beanTypeLocal);
                            BeanPropertyWriter.pushCastToType((MethodVisitor)withValueMethod2, this.beanType);
                        }
                        withValueMethod2.returnValue();
                        withValueMethod2.visitMaxs(1, 1);
                        withValueMethod2.endMethod();
                    }
                }
            }
            GeneratorAdapter isWriteOnly = this.startPublicFinalMethodZeroArgs(this.classWriter, Boolean.TYPE, "hasSetterOrConstructorArgument");
            isWriteOnly.push(isMutable);
            isWriteOnly.returnValue();
            isWriteOnly.visitMaxs(1, 1);
            isWriteOnly.endMethod();
            if (!isMutable) {
                GeneratorAdapter mutateMethod = this.startPublicMethod(this.classWriter, METHOD_WITH_VALUE_INTERNAL);
                mutateMethod.throwException(Type.getType(UnsupportedOperationException.class), nonMutableMessage);
                mutateMethod.visitMaxs(1, 1);
                mutateMethod.endMethod();
            }
            for (GeneratorAdapter generator : this.loadTypeMethods.values()) {
                generator.visitMaxs(3, 1);
                generator.visitEnd();
            }
            classOutput.write(this.classWriter.toByteArray());
        }
    }

    @NonNull
    private ClassElement invokeReadMethod(GeneratorAdapter mutateMethod, MethodElement readMethod) {
        ClassElement returnType = readMethod.getReturnType();
        if (this.declaringElement.isInterface()) {
            mutateMethod.invokeInterface(this.beanType, new Method(readMethod.getName(), BeanPropertyWriter.getMethodDescriptor(returnType, Collections.emptyList())));
        } else {
            mutateMethod.invokeVirtual(this.beanType, new Method(readMethod.getName(), BeanPropertyWriter.getMethodDescriptor(returnType, Collections.emptyList())));
        }
        return returnType;
    }

    private boolean hasAssociatedConstructorArgument() {
        MethodElement constructor = this.beanIntrospectionWriter.getConstructor();
        if (constructor != null) {
            ParameterElement[] parameters;
            for (ParameterElement parameter : parameters = constructor.getParameters()) {
                if (!this.getPropertyName().equals(parameter.getName())) continue;
                return this.typeElement.getType().isAssignable(parameter.getGenericType());
            }
        }
        return false;
    }

    private void writeWriteMethod() {
        Type returnType;
        GeneratorAdapter writeMethod = this.startPublicMethod(this.classWriter, METHOD_WRITE_INTERNAL.getName(), Void.TYPE.getName(), Object.class.getName(), Object.class.getName());
        writeMethod.loadArg(0);
        writeMethod.checkCast(this.beanType);
        writeMethod.loadArg(1);
        BeanPropertyWriter.pushCastToType((MethodVisitor)writeMethod, this.propertyType);
        boolean hasWriteMethod = this.writeMethod != null;
        String methodName = hasWriteMethod ? this.writeMethod.getName() : NameUtils.setterNameFor((String)this.propertyName);
        Type type = returnType = hasWriteMethod ? JavaModelUtils.getTypeReference(this.writeMethod.getReturnType()) : Type.VOID_TYPE;
        if (this.declaringElement.isInterface()) {
            writeMethod.invokeInterface(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(returnType, Collections.singleton(this.propertyType))));
        } else {
            writeMethod.invokeVirtual(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(returnType, Collections.singleton(this.propertyType))));
        }
        writeMethod.visitInsn(177);
        writeMethod.visitMaxs(1, 1);
        writeMethod.visitEnd();
    }

    private void writeReadMethod() {
        String methodName;
        GeneratorAdapter readMethod = this.startPublicMethod(this.classWriter, METHOD_READ_INTERNAL.getName(), Object.class.getName(), Object.class.getName());
        readMethod.loadArg(0);
        BeanPropertyWriter.pushCastToType((MethodVisitor)readMethod, this.beanType);
        boolean isBoolean = this.propertyType.getClassName().equals("boolean");
        String string = methodName = this.readMethod != null ? this.readMethod.getName() : NameUtils.getterNameFor((String)this.propertyName, (boolean)isBoolean);
        if (this.declaringElement.isInterface()) {
            readMethod.invokeInterface(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(this.propertyType, Collections.emptyList())));
        } else {
            readMethod.invokeVirtual(this.beanType, new Method(methodName, BeanPropertyWriter.getMethodDescriptor(this.propertyType, Collections.emptyList())));
        }
        BeanPropertyWriter.pushBoxPrimitiveIfNecessary(this.propertyType, (MethodVisitor)readMethod);
        readMethod.returnValue();
        readMethod.visitMaxs(1, 1);
        readMethod.visitEnd();
    }

    private void writeConstructor() {
        GeneratorAdapter constructor = this.startConstructor((ClassVisitor)this.classWriter, BeanIntrospection.class);
        constructor.loadThis();
        constructor.loadArg(0);
        constructor.push(this.propertyGenericType);
        constructor.push(this.propertyName);
        if (this.annotationMetadata instanceof DefaultAnnotationMetadata) {
            DefaultAnnotationMetadata annotationMetadata = (DefaultAnnotationMetadata)this.annotationMetadata;
            if (annotationMetadata.isEmpty()) {
                constructor.visitInsn(1);
            } else {
                AnnotationMetadataWriter.instantiateNewMetadata(this.type, this.classWriter, constructor, annotationMetadata, this.loadTypeMethods);
            }
        } else {
            constructor.visitInsn(1);
        }
        if (this.typeArguments != null) {
            BeanPropertyWriter.pushTypeArgumentElements(this.type, this.classWriter, constructor, this.typeElement.getName(), this.typeArguments, this.loadTypeMethods);
        } else {
            constructor.visitInsn(1);
        }
        this.invokeConstructor((MethodVisitor)constructor, AbstractBeanProperty.class, BeanIntrospection.class, Class.class, String.class, AnnotationMetadata.class, Argument[].class);
        constructor.visitInsn(177);
        constructor.visitMaxs(20, 2);
        constructor.visitEnd();
    }
}

