/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.ReflectClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface ClassElement
extends TypedElement {
    public boolean isAssignable(String var1);

    default public boolean isAssignable(ClassElement type) {
        return this.isAssignable(type.getName());
    }

    default public boolean isOptional() {
        return this.isAssignable(Optional.class);
    }

    default public String getCanonicalName() {
        if (this.isOptional()) {
            return this.getFirstTypeArgument().map(Element::getName).orElse(Object.class.getName());
        }
        return this.getName();
    }

    default public boolean isRecord() {
        return false;
    }

    default public boolean isInner() {
        return false;
    }

    default public boolean isEnum() {
        return this instanceof EnumElement;
    }

    @NonNull
    default public Optional<MethodElement> getPrimaryConstructor() {
        return Optional.empty();
    }

    @NonNull
    default public Optional<MethodElement> getDefaultConstructor() {
        return Optional.empty();
    }

    default public Optional<ClassElement> getSuperType() {
        return Optional.empty();
    }

    @Override
    @NonNull
    default public ClassElement getType() {
        return this;
    }

    @Override
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    default public String getPackageName() {
        return NameUtils.getPackageName((String)this.getName());
    }

    default public List<PropertyElement> getBeanProperties() {
        return Collections.emptyList();
    }

    default public List<FieldElement> getFields() {
        return this.getEnclosedElements(ElementQuery.ALL_FIELDS);
    }

    @Deprecated
    default public List<FieldElement> getFields(@NonNull Predicate<Set<ElementModifier>> modifierFilter) {
        Objects.requireNonNull(modifierFilter, "The modifier filter cannot be null");
        return this.getEnclosedElements(ElementQuery.ALL_FIELDS.modifiers(modifierFilter));
    }

    default public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        return Collections.emptyList();
    }

    default public <T extends Element> Optional<T> getEnclosedElement(@NonNull ElementQuery<T> query) {
        List<T> enclosedElements = this.getEnclosedElements(query);
        if (!enclosedElements.isEmpty()) {
            return Optional.of(enclosedElements.iterator().next());
        }
        return Optional.empty();
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isIterable() {
        return this.isArray() || this.isAssignable(Iterable.class);
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull Class<?> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments() {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        return Collections.emptyMap();
    }

    default public Optional<ClassElement> getFirstTypeArgument() {
        return this.getTypeArguments().values().stream().findFirst();
    }

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }

    @NonNull
    public ClassElement toArray();

    @NonNull
    public ClassElement fromArray();

    @NonNull
    public static ClassElement of(@NonNull Class<?> type) {
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null"));
    }

    @NonNull
    public static ClassElement of(@NonNull Class<?> type, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull Map<String, ClassElement> typeArguments) {
        Objects.requireNonNull(annotationMetadata, "Annotation metadata cannot be null");
        Objects.requireNonNull(typeArguments, "Type arguments cannot be null");
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null")){

            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public Map<String, ClassElement> getTypeArguments() {
                return Collections.unmodifiableMap(typeArguments);
            }
        };
    }

    @Internal
    @NonNull
    public static ClassElement of(final @NonNull String typeName) {
        return new ClassElement(){

            @Override
            public boolean isAssignable(String type) {
                return false;
            }

            @Override
            public boolean isAssignable(ClassElement type) {
                return false;
            }

            @Override
            public ClassElement toArray() {
                throw new UnsupportedOperationException("Cannot convert class elements produced by name to an array");
            }

            @Override
            public ClassElement fromArray() {
                throw new UnsupportedOperationException("Cannot convert class elements produced by from an array");
            }

            @Override
            @NotNull
            public String getName() {
                return typeName;
            }

            @Override
            public boolean isPackagePrivate() {
                return false;
            }

            @Override
            public boolean isProtected() {
                return false;
            }

            @Override
            public boolean isPublic() {
                return false;
            }

            @Override
            @NotNull
            public Object getNativeType() {
                return typeName;
            }
        };
    }
}

