/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.yaml;

import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.core.util.CollectionUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YamlPropertySourceLoader
extends AbstractPropertySourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(YamlPropertySourceLoader.class);
    private static final SafeConstructor YAML_CONSTRUCTOR = new SafeConstructor(){

        protected Map<Object, Object> newMap(MappingNode node) {
            return this.createDefaultMap(node.getValue().size());
        }

        protected List<Object> newList(SequenceNode node) {
            return this.createDefaultList(node.getValue().size());
        }
    };

    public boolean isEnabled() {
        return YamlPropertySourceLoader.isSnakeYamlPresent();
    }

    @Override
    public Set<String> getExtensions() {
        return CollectionUtils.setOf((Object[])new String[]{"yml", "yaml"});
    }

    @Override
    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) {
        Yaml yaml;
        Iterable objects;
        Iterator i;
        if (System.getProperty("java.runtime.name") == null) {
            System.setProperty("java.runtime.name", "Unknown");
        }
        if ((i = (objects = (yaml = new Yaml((BaseConstructor)YAML_CONSTRUCTOR)).loadAll(input)).iterator()).hasNext()) {
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof Map)) continue;
                Map map = (Map)object;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing YAML: {}", (Object)map);
                }
                String prefix = "";
                this.processMap(finalMap, map, prefix);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("PropertySource [{}] produced no YAML content", (Object)name);
        }
    }

    private static boolean isSnakeYamlPresent() {
        try {
            Class<Yaml> yamlClass = Yaml.class;
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

