/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.AbstractBeanIntrospection;
import io.micronaut.core.beans.AbstractBeanIntrospectionReference;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.beans.visitor.BeanPropertyWriter;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Internal
class BeanIntrospectionWriter
extends AbstractAnnotationMetadataWriter {
    private static final Method METHOD_ADD_PROPERTY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanIntrospection.class, (String)"addProperty", (Class[])new Class[]{BeanProperty.class}));
    private static final Method METHOD_INDEX_PROPERTY = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(AbstractBeanIntrospection.class, (String)"indexProperty", (Class[])new Class[]{Class.class, String.class, String.class}));
    private static final String REFERENCE_SUFFIX = "$IntrospectionRef";
    private static final String INTROSPECTION_SUFFIX = "$Introspection";
    private final ClassWriter referenceWriter;
    private final String introspectionName;
    private final Type introspectionType;
    private final Type beanType;
    private final ClassWriter introspectionWriter;
    private final List<BeanPropertyWriter> propertyDefinitions = new ArrayList<BeanPropertyWriter>();
    private final Map<String, Collection<AnnotationValueIndex>> indexes = new HashMap<String, Collection<AnnotationValueIndex>>(2);
    private final Map<String, GeneratorAdapter> localLoadTypeMethods = new HashMap<String, GeneratorAdapter>();
    private final ClassElement classElement;
    private boolean executed = false;
    private int propertyIndex = 0;
    private MethodElement constructor;
    private MethodElement defaultConstructor;

    BeanIntrospectionWriter(ClassElement classElement, AnnotationMetadata beanAnnotationMetadata) {
        super(BeanIntrospectionWriter.computeReferenceName(classElement.getName()), (Element)classElement, beanAnnotationMetadata, true);
        String name = classElement.getName();
        this.classElement = classElement;
        this.referenceWriter = new ClassWriter(1);
        this.introspectionWriter = new ClassWriter(1);
        this.introspectionName = BeanIntrospectionWriter.computeIntrospectionName(name);
        this.introspectionType = BeanIntrospectionWriter.getTypeReference(this.introspectionName);
        this.beanType = BeanIntrospectionWriter.getTypeReference(name);
    }

    BeanIntrospectionWriter(String generatingType, int index, ClassElement originatingElement, ClassElement classElement, AnnotationMetadata beanAnnotationMetadata) {
        super(BeanIntrospectionWriter.computeReferenceName(generatingType) + index, (Element)originatingElement, beanAnnotationMetadata, true);
        String className = classElement.getName();
        this.classElement = classElement;
        this.referenceWriter = new ClassWriter(1);
        this.introspectionWriter = new ClassWriter(1);
        this.introspectionName = BeanIntrospectionWriter.computeIntrospectionName(generatingType, className);
        this.introspectionType = BeanIntrospectionWriter.getTypeReference(this.introspectionName);
        this.beanType = BeanIntrospectionWriter.getTypeReference(className);
    }

    public MethodElement getConstructor() {
        return this.constructor;
    }

    ClassElement getClassElement() {
        return this.classElement;
    }

    Type getIntrospectionType() {
        return this.introspectionType;
    }

    public Type getBeanType() {
        return this.beanType;
    }

    void visitProperty(@NonNull TypedElement type, @NonNull String name, @Nullable MethodElement readMethod, @Nullable MethodElement writeMethod, boolean isReadOnly, @Nullable AnnotationMetadata annotationMetadata, @Nullable Map<String, ClassElement> typeArguments) {
        Type propertyType = BeanIntrospectionWriter.getTypeReference(type);
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        this.propertyDefinitions.add(new BeanPropertyWriter(this, type, propertyType, name, readMethod, writeMethod, isReadOnly, this.propertyIndex++, annotationMetadata, typeArguments));
    }

    void indexProperty(AnnotationValue<?> annotation, String property, @Nullable String value) {
        this.indexes.computeIfAbsent(property, s -> new HashSet(2)).add(new AnnotationValueIndex(annotation, property, value));
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        if (!this.executed) {
            this.executed = true;
            this.writeIntrospectionReference(classWriterOutputVisitor);
            this.writeIntrospectionClass(classWriterOutputVisitor);
        }
    }

    private void writeIntrospectionClass(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Type superType = Type.getType(AbstractBeanIntrospection.class);
        try (OutputStream introspectionStream = classWriterOutputVisitor.visitClass(this.introspectionName, this.getOriginatingElements());){
            this.startFinalClass((ClassVisitor)this.introspectionWriter, this.introspectionType.getInternalName(), superType);
            GeneratorAdapter constructorWriter = this.startConstructor((ClassVisitor)this.introspectionWriter);
            constructorWriter.loadThis();
            constructorWriter.push(this.beanType);
            if (this.annotationMetadata == null || this.annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
                constructorWriter.visitInsn(1);
            } else {
                constructorWriter.getStatic(this.targetClassType, "$ANNOTATION_METADATA", Type.getType(AnnotationMetadata.class));
            }
            constructorWriter.push(this.propertyDefinitions.size());
            this.invokeConstructor((MethodVisitor)constructorWriter, AbstractBeanIntrospection.class, Class.class, AnnotationMetadata.class, Integer.TYPE);
            for (BeanPropertyWriter propertyWriter : this.propertyDefinitions) {
                propertyWriter.accept(classWriterOutputVisitor);
                Type writerType = propertyWriter.getType();
                constructorWriter.loadThis();
                constructorWriter.newInstance(writerType);
                constructorWriter.dup();
                constructorWriter.loadThis();
                constructorWriter.invokeConstructor(writerType, new Method("<init>", BeanIntrospectionWriter.getConstructorDescriptor(BeanIntrospection.class)));
                constructorWriter.visitMethodInsn(183, superType.getInternalName(), METHOD_ADD_PROPERTY.getName(), METHOD_ADD_PROPERTY.getDescriptor(), false);
                String propertyName = propertyWriter.getPropertyName();
                if (!this.indexes.containsKey(propertyName)) continue;
                Collection<AnnotationValueIndex> annotations = this.indexes.get(propertyName);
                for (AnnotationValueIndex index : annotations) {
                    constructorWriter.loadThis();
                    Type typeReference = BeanIntrospectionWriter.getTypeReference(index.annotationValue.getAnnotationName());
                    constructorWriter.push(typeReference);
                    constructorWriter.push(propertyName);
                    constructorWriter.push(index.value);
                    constructorWriter.visitMethodInsn(183, superType.getInternalName(), METHOD_INDEX_PROPERTY.getName(), METHOD_INDEX_PROPERTY.getDescriptor(), false);
                }
            }
            constructorWriter.visitInsn(177);
            constructorWriter.visitMaxs(2, 1);
            this.writeInstantiateMethod();
            if (this.constructor != null && ArrayUtils.isNotEmpty((Object[])this.constructor.getParameters())) {
                this.writeConstructorArguments();
            }
            for (GeneratorAdapter generatorAdapter : this.localLoadTypeMethods.values()) {
                generatorAdapter.visitMaxs(1, 1);
                generatorAdapter.visitEnd();
            }
            introspectionStream.write(this.introspectionWriter.toByteArray());
        }
    }

    private void writeConstructorArguments() {
        GeneratorAdapter getConstructorArguments = this.startPublicMethodZeroArgs(this.introspectionWriter, Argument[].class, "getConstructorArguments");
        ParameterElement[] constructorArguments = this.constructor.getParameters();
        Map<String, Object> args = this.toParameterTypes(constructorArguments);
        LinkedHashMap<String, AnnotationMetadata> annotationMetadataMap = new LinkedHashMap<String, AnnotationMetadata>(args.size());
        for (ParameterElement constructorArgument : constructorArguments) {
            annotationMetadataMap.put(constructorArgument.getName(), constructorArgument.getAnnotationMetadata());
        }
        BeanIntrospectionWriter.pushBuildArgumentsForMethod(this.introspectionType, this.introspectionWriter, getConstructorArguments, args, annotationMetadataMap, this.toTypeArguments(constructorArguments), this.localLoadTypeMethods);
        getConstructorArguments.returnValue();
        getConstructorArguments.visitMaxs(1, 1);
        getConstructorArguments.endMethod();
        String desc = BeanIntrospectionWriter.getMethodDescriptor(Object.class, Collections.singleton(Object[].class));
        GeneratorAdapter instantiateInternal = new GeneratorAdapter(this.introspectionWriter.visitMethod(1, "instantiateInternal", desc, null, null), 1, "instantiateInternal", desc);
        Collection argumentTypes = Arrays.stream(constructorArguments).map(pe -> BeanIntrospectionWriter.getTypeReference(pe.getType())).collect(Collectors.toList());
        boolean isConstructor = this.constructor instanceof ConstructorElement;
        boolean isCompanion = this.constructor.getDeclaringType().getSimpleName().endsWith("$Companion");
        if (isConstructor) {
            instantiateInternal.newInstance(this.beanType);
            instantiateInternal.dup();
        } else if (isCompanion) {
            instantiateInternal.getStatic(this.beanType, "Companion", BeanIntrospectionWriter.getTypeReference(this.constructor.getDeclaringType().getName()));
        }
        int i = 0;
        for (Type argumentType : argumentTypes) {
            instantiateInternal.loadArg(0);
            instantiateInternal.push(i++);
            instantiateInternal.arrayLoad(TYPE_OBJECT);
            BeanIntrospectionWriter.pushCastToType((MethodVisitor)instantiateInternal, argumentType);
        }
        if (isConstructor) {
            String constructorDescriptor = BeanIntrospectionWriter.getConstructorDescriptor(argumentTypes);
            instantiateInternal.invokeConstructor(this.beanType, new Method("<init>", constructorDescriptor));
        } else if (this.constructor.isStatic()) {
            String methodDescriptor = BeanIntrospectionWriter.getMethodDescriptor(this.beanType, argumentTypes);
            Method method = new Method(this.constructor.getName(), methodDescriptor);
            if (this.classElement.isInterface()) {
                instantiateInternal.visitMethodInsn(184, this.beanType.getInternalName(), method.getName(), method.getDescriptor(), true);
            } else {
                instantiateInternal.invokeStatic(this.beanType, method);
            }
        } else if (isCompanion) {
            instantiateInternal.invokeVirtual(BeanIntrospectionWriter.getTypeReference(this.constructor.getDeclaringType().getName()), new Method(this.constructor.getName(), BeanIntrospectionWriter.getMethodDescriptor(this.beanType, argumentTypes)));
        }
        instantiateInternal.visitInsn(176);
        instantiateInternal.visitMaxs(2, 1);
        instantiateInternal.visitEnd();
    }

    private void writeInstantiateMethod() {
        GeneratorAdapter instantiateMethod = this.startPublicMethod(this.introspectionWriter, "instantiate", Object.class.getName(), new String[0]);
        if (this.defaultConstructor != null) {
            if (this.defaultConstructor instanceof ConstructorElement) {
                this.pushNewInstance(instantiateMethod, this.beanType);
            } else if (this.defaultConstructor.isStatic()) {
                String methodDescriptor = BeanIntrospectionWriter.getMethodDescriptor(this.beanType, Collections.emptyList());
                instantiateMethod.invokeStatic(this.beanType, new Method(this.defaultConstructor.getName(), methodDescriptor));
            } else if (this.constructor.getDeclaringType().getSimpleName().endsWith("$Companion")) {
                instantiateMethod.getStatic(this.beanType, "Companion", BeanIntrospectionWriter.getTypeReference(this.constructor.getDeclaringType().getName()));
                instantiateMethod.invokeVirtual(BeanIntrospectionWriter.getTypeReference(this.constructor.getDeclaringType().getName()), new Method(this.constructor.getName(), BeanIntrospectionWriter.getMethodDescriptor(this.beanType, Collections.emptyList())));
            }
            instantiateMethod.visitInsn(176);
            instantiateMethod.visitMaxs(2, 1);
            instantiateMethod.visitEnd();
        } else {
            Type exceptionType = Type.getType(InstantiationException.class);
            instantiateMethod.newInstance(exceptionType);
            instantiateMethod.dup();
            instantiateMethod.visitLdcInsn((Object)"No default constructor exists");
            instantiateMethod.invokeConstructor(exceptionType, Method.getMethod((Constructor)ReflectionUtils.getRequiredInternalConstructor(InstantiationException.class, (Class[])new Class[]{String.class})));
            instantiateMethod.throwException();
            instantiateMethod.visitMaxs(3, 1);
            instantiateMethod.visitEnd();
        }
    }

    private void writeIntrospectionReference(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        Type superType = Type.getType(AbstractBeanIntrospectionReference.class);
        String referenceName = this.targetClassType.getClassName();
        classWriterOutputVisitor.visitServiceDescriptor(BeanIntrospectionReference.class, referenceName);
        try (OutputStream referenceStream = classWriterOutputVisitor.visitClass(referenceName, this.getOriginatingElements());){
            this.startService((ClassVisitor)this.referenceWriter, BeanIntrospectionReference.class, this.targetClassType.getInternalName(), superType);
            ClassWriter classWriter = this.generateClassBytes(this.referenceWriter);
            for (GeneratorAdapter generatorAdapter : this.loadTypeMethods.values()) {
                generatorAdapter.visitMaxs(1, 1);
                generatorAdapter.visitEnd();
            }
            referenceStream.write(classWriter.toByteArray());
        }
    }

    private ClassWriter generateClassBytes(ClassWriter classWriter) {
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        this.invokeConstructor((MethodVisitor)cv, AbstractBeanIntrospectionReference.class, new Class[0]);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter loadMethod = this.startPublicMethodZeroArgs(classWriter, BeanIntrospection.class, "load");
        this.pushNewInstance(loadMethod, this.introspectionType);
        loadMethod.returnValue();
        loadMethod.visitMaxs(2, 1);
        loadMethod.endMethod();
        GeneratorAdapter nameMethod = this.startPublicMethodZeroArgs(classWriter, String.class, "getName");
        nameMethod.push(this.beanType.getClassName());
        nameMethod.returnValue();
        nameMethod.visitMaxs(1, 1);
        nameMethod.endMethod();
        GeneratorAdapter getBeanType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanType");
        getBeanType.push(this.beanType);
        getBeanType.returnValue();
        getBeanType.visitMaxs(2, 1);
        getBeanType.endMethod();
        this.writeGetAnnotationMetadataMethod(classWriter);
        return classWriter;
    }

    @NotNull
    private static String computeReferenceName(String className) {
        String packageName = NameUtils.getPackageName((String)className);
        String shortName = NameUtils.getSimpleName((String)className);
        return packageName + ".$" + shortName + REFERENCE_SUFFIX;
    }

    @NotNull
    private static String computeIntrospectionName(String className) {
        String packageName = NameUtils.getPackageName((String)className);
        String shortName = NameUtils.getSimpleName((String)className);
        return packageName + ".$" + shortName + INTROSPECTION_SUFFIX;
    }

    @NotNull
    private static String computeIntrospectionName(String generatingName, String className) {
        String packageName = NameUtils.getPackageName((String)generatingName);
        return packageName + ".$" + className.replace('.', '_') + INTROSPECTION_SUFFIX;
    }

    void visitConstructor(MethodElement constructor) {
        this.constructor = constructor;
    }

    void visitDefaultConstructor(MethodElement constructor) {
        this.defaultConstructor = constructor;
    }

    private class AnnotationValueIndex {
        @NonNull
        final AnnotationValue annotationValue;
        @NonNull
        final String property;
        @Nullable
        final String value;

        public AnnotationValueIndex(@NonNull AnnotationValue annotationValue, @Nullable String property, String value) {
            this.annotationValue = annotationValue;
            this.property = property;
            this.value = value;
        }
    }
}

