/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadata;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Internal
public class DefaultAnnotationMetadata
extends AbstractAnnotationMetadata
implements AnnotationMetadata,
Cloneable,
EnvironmentAnnotationMetadata {
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> allAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredStereotypes;
    @Nullable
    Map<String, Map<CharSequence, Object>> allStereotypes;
    @Nullable
    Map<String, List<String>> annotationsByStereotype;
    @Nullable
    Map<String, Map<CharSequence, Object>> annotationDefaultValues;
    private Map<Class, List> annotationValuesByType = new ConcurrentHashMap<Class, List>(2);
    private Map<String, String> repeated = null;
    private Set<String> sourceRetentionAnnotations;

    @Internal
    protected DefaultAnnotationMetadata() {
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype) {
        super(declaredAnnotations, allAnnotations);
        this.declaredAnnotations = declaredAnnotations;
        this.declaredStereotypes = declaredStereotypes;
        this.allStereotypes = allStereotypes;
        this.allAnnotations = allAnnotations;
        this.annotationsByStereotype = annotationsByStereotype;
    }

    @Internal
    Set<String> getSourceRetentionAnnotations() {
        if (this.sourceRetentionAnnotations != null) {
            return Collections.unmodifiableSet(this.sourceRetentionAnnotations);
        }
        return Collections.emptySet();
    }

    @NonNull
    public Map<String, Object> getDefaultValues(@NonNull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        return AnnotationMetadataSupport.getDefaultValues(annotation);
    }

    public boolean isPresent(@NonNull String annotation, @NonNull String member) {
        boolean isPresent = false;
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                isPresent = values.containsKey(member);
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                isPresent = values.containsKey(member);
            }
        }
        return isPresent;
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType, null);
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType);
    }

    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    @Override
    @Internal
    public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).enumValue(member, enumType, valueMapper);
            }
            return Optional.empty();
        }
        return this.enumValue(annotation.getName(), member, enumType, valueMapper);
    }

    public <E extends Enum> E[] enumValues(@NonNull String annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType, null);
    }

    public <E extends Enum> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType, null);
    }

    public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    @Override
    public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"enumType", enumType);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawValue(repeatable.value().getName(), member);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).enumValues(member, enumType);
            }
            return (Enum[])Array.newInstance(enumType, 0);
        }
        Object v = this.getRawValue(annotation.getName(), member);
        return AnnotationValue.resolveEnumValues(enumType, (Object)v);
    }

    @Override
    public <E extends Enum> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"enumType", enumType);
        Object v = this.getRawValue(annotation, member);
        return AnnotationValue.resolveEnumValues(enumType, (Object)v);
    }

    @Override
    @Internal
    public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        return this.enumValueOf(enumType, rawValue);
    }

    private <E extends Enum> Optional<E> enumValueOf(Class<E> enumType, Object rawValue) {
        if (rawValue != null) {
            if (enumType.isInstance(rawValue)) {
                return Optional.of((Enum)rawValue);
            }
            try {
                return Optional.of(Enum.valueOf(enumType, rawValue.toString()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Object rawSingleValue = this.getRawValue(annotation, member);
        Class[] classes = AnnotationValue.resolveClassValues((Object)rawSingleValue);
        if (classes != null) {
            return classes;
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    public <T> Class<T>[] classValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), member, null);
            if (v instanceof AnnotationValue) {
                Class[] classes = ((AnnotationValue)v).classValues(member);
                return classes;
            }
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        return this.classValues(annotation.getName(), member);
    }

    @NonNull
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.classValue(annotation, member, null);
    }

    @Override
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), member, valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).classValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.classValue(annotation.getName(), member, valueMapper);
    }

    @NonNull
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.classValue(annotation, member, null);
    }

    @Override
    @Internal
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof AnnotationClassValue) {
            return ((AnnotationClassValue)rawValue).getType();
        }
        if (rawValue instanceof Class) {
            return Optional.of((Class)rawValue);
        }
        if (rawValue != null) {
            return ConversionService.SHARED.convert(rawValue, Class.class);
        }
        return Optional.empty();
    }

    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.intValue(annotation, member, null);
    }

    @NonNull
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.intValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).intValue(member, valueMapper);
            }
            return OptionalInt.empty();
        }
        return this.intValue(annotation.getName(), member, valueMapper);
    }

    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.booleanValue(annotation, member, null);
    }

    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.booleanValue(annotation, member, null);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", null);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).booleanValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.booleanValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            return Optional.of((Boolean)rawValue);
        }
        if (rawValue != null) {
            return Optional.of(StringUtils.isTrue((String)rawValue.toString()));
        }
        return Optional.empty();
    }

    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.longValue(annotation, member, null);
    }

    @NonNull
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.longValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).longValue(member, valueMapper);
            }
            return OptionalLong.empty();
        }
        return this.longValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalLong.of(((Number)rawValue).longValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty((CharSequence)(str = rawValue.toString()))) {
            try {
                long i = Long.parseLong(str);
                return OptionalLong.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalInt.of(((Number)rawValue).intValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty((CharSequence)(str = rawValue.toString()))) {
            try {
                int i = Integer.parseInt(str);
                return OptionalInt.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalInt.empty();
    }

    @NonNull
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.stringValue(annotation, member, null);
    }

    @Override
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).stringValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.stringValue(annotation.getName(), member, valueMapper);
    }

    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.stringValues(annotation, member, null);
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawValue(repeatable.value().getName(), member);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).stringValues(member, valueMapper);
            }
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Object v = this.getRawValue(annotation.getName(), member);
        String[] strings = AnnotationValue.resolveStringValues((Object)v, valueMapper);
        return strings != null ? strings : StringUtils.EMPTY_STRING_ARRAY;
    }

    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.stringValue(annotation, member, null);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof CharSequence) {
            return Optional.of(rawValue.toString());
        }
        if (rawValue instanceof Class) {
            String name = ((Class)rawValue).getName();
            return Optional.of(name);
        }
        if (rawValue != null) {
            return Optional.of(rawValue.toString());
        }
        return Optional.empty();
    }

    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.isTrue(annotation, member, null);
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).isTrue(member, valueMapper);
            }
            return false;
        }
        return this.isTrue(annotation.getName(), member, valueMapper);
    }

    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.isTrue(annotation, member, null);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        if (rawValue != null) {
            String booleanString = rawValue.toString().toLowerCase(Locale.ENGLISH);
            return StringUtils.isTrue((String)booleanString);
        }
        return false;
    }

    public boolean isFalse(@NonNull String annotation, @NonNull String member) {
        return !this.isTrue(annotation, member);
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        return this.doubleValue(annotation, member, null);
    }

    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.doubleValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Object v = this.getRawSingleValue(repeatable.value().getName(), "value", valueMapper);
            if (v instanceof AnnotationValue) {
                return ((AnnotationValue)v).doubleValue(member, valueMapper);
            }
            return OptionalDouble.empty();
        }
        return this.doubleValue(annotation.getName(), member);
    }

    @Override
    @Internal
    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            return OptionalDouble.of(((Number)rawValue).doubleValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty((CharSequence)(str = rawValue.toString()))) {
            try {
                double i = Double.parseDouble(str);
                return OptionalDouble.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of member [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalDouble.empty();
    }

    @NonNull
    public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        boolean isRepeatable;
        ArgumentUtils.requireNonNull((String)"annotation", annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        boolean bl = isRepeatable = repeatable != null;
        if (isRepeatable) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get((CharSequence)member, requiredType);
            }
            return Optional.empty();
        }
        return this.getValue(annotation.getName(), member, requiredType);
    }

    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        return this.getValue(annotation, member, requiredType, null);
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Optional resolved = Optional.empty();
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Object rawValue;
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                Object rawValue2 = values.get(member);
                if (rawValue2 != null) {
                    if (valueMapper != null) {
                        rawValue2 = valueMapper.apply(rawValue2);
                    }
                    resolved = ConversionService.SHARED.convert(rawValue2, requiredType);
                }
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null && (rawValue = values.get(member)) != null) {
                if (valueMapper != null) {
                    rawValue = valueMapper.apply(rawValue);
                }
                resolved = ConversionService.SHARED.convert(rawValue, requiredType);
            }
        }
        if (!resolved.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return resolved;
    }

    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            Object v = defaultValues.get(member);
            if (requiredType.isInstance(v)) {
                return Optional.of(v);
            }
            return ConversionService.SHARED.convert(v, requiredType);
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nullable Class<T> annotationType) {
        if (annotationType != null) {
            List<Object> results = this.annotationValuesByType.get(annotationType);
            if (results == null) {
                Map<CharSequence, Object> values;
                results = this.resolveAnnotationValuesByType(annotationType, this.allAnnotations, this.allStereotypes);
                if (results != null) {
                    return results;
                }
                if (this.allAnnotations != null && (values = this.allAnnotations.get(annotationType.getName())) != null) {
                    results = Collections.singletonList(new AnnotationValue(annotationType.getName(), values));
                }
                if (results == null) {
                    results = Collections.emptyList();
                }
                this.annotationValuesByType.put(annotationType, results);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        Map<String, Map<CharSequence, Object>> sourceStereotypes;
        Map<String, Map<CharSequence, Object>> sourceAnnotations;
        List<AnnotationValue<T>> results;
        if (annotationType != null && (results = this.resolveAnnotationValuesByType(annotationType, sourceAnnotations = this.declaredAnnotations, sourceStereotypes = this.declaredStereotypes)) != null) {
            return results;
        }
        return Collections.emptyList();
    }

    public <T extends Annotation> T[] synthesizeAnnotationsByType(@NonNull Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@NonNull Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public boolean isEmpty() {
        return this.allAnnotations == null || this.allAnnotations.isEmpty();
    }

    public boolean hasDeclaredAnnotation(String annotation) {
        return this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredAnnotations.containsKey(annotation);
    }

    public boolean hasAnnotation(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allAnnotations.containsKey(annotation);
    }

    public boolean hasStereotype(String annotation) {
        return this.hasAnnotation(annotation) || this.allStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allStereotypes.containsKey(annotation);
    }

    public boolean hasDeclaredStereotype(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.declaredStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredStereotypes.containsKey(annotation);
    }

    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        if (stereotype != null) {
            List<String> annotations;
            if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
                return this.getAnnotationType(annotations.get(0));
            }
            if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
                return this.getAnnotationType(stereotype);
            }
            if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
                return this.getAnnotationType(stereotype);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public Optional<String> getAnnotationNameByStereotype(@Nullable String stereotype) {
        if (stereotype != null) {
            List<String> annotations;
            if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
                return Optional.of(annotations.get(0));
            }
            if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
                return Optional.of(stereotype);
            }
            if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
                return Optional.of(stereotype);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Collections.emptyList();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            return Collections.unmodifiableList(annotations);
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    @NonNull
    public Set<String> getAnnotationNames() {
        if (this.allAnnotations != null) {
            return this.allAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        if (this.declaredAnnotations != null) {
            return this.declaredAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    @NonNull
    public List<String> getDeclaredAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Collections.emptyList();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            annotations = new ArrayList<String>(annotations);
            if (this.declaredAnnotations != null) {
                annotations.removeIf(s -> !this.declaredAnnotations.containsKey(s));
                return Collections.unmodifiableList(annotations);
            }
            return Collections.emptyList();
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        return AnnotationMetadataSupport.getAnnotationType(name);
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        if (this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.declaredAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.declaredStereotypes != null && (values = this.declaredStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"valueType", valueType);
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return OptionalValues.of(valueType, values);
            }
            if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                return OptionalValues.of(valueType, values);
            }
        }
        return OptionalValues.empty();
    }

    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"annotation", (Object)annotation);
        ArgumentUtils.requireNonNull((String)"member", (Object)member);
        ArgumentUtils.requireNonNull((String)"requiredType", requiredType);
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            return ConversionService.SHARED.convert(defaultValues.get(member), requiredType);
        }
        return Optional.empty();
    }

    public DefaultAnnotationMetadata clone() {
        return new DefaultAnnotationMetadata(this.declaredAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredAnnotations) : null, this.declaredStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredStereotypes) : null, this.allStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.allStereotypes) : null, this.allAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.allAnnotations) : null, (Map<String, List<String>>)(this.annotationsByStereotype != null ? new HashMap<String, List<String>>(this.annotationsByStereotype) : null));
    }

    protected final void addAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.addAnnotation(annotation, values, RetentionPolicy.RUNTIME);
    }

    protected final void addAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] avs;
                for (AnnotationValue av : avs = (AnnotationValue[])v) {
                    this.addRepeatable(annotation, av);
                }
            } else if (v instanceof Iterable && repeatedName != null) {
                Iterable i = (Iterable)v;
                for (Object o : i) {
                    if (!(o instanceof AnnotationValue)) continue;
                    this.addRepeatable(annotation, (AnnotationValue)o);
                }
            } else {
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, null, allAnnotations, false, retentionPolicy);
            }
        }
    }

    protected final void addDefaultAnnotationValues(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            Map<String, Map<CharSequence, Object>> annotationDefaults = this.annotationDefaultValues;
            if (annotationDefaults == null) {
                annotationDefaults = this.annotationDefaultValues = new HashMap<String, Map<CharSequence, Object>>();
            }
            this.putValues(annotation, values, annotationDefaults);
        }
    }

    @Internal
    public static boolean areAnnotationDefaultsRegistered(String annotation) {
        return AnnotationMetadataSupport.hasDefaultValues(annotation);
    }

    @Internal
    public static void registerAnnotationDefaults(String annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    public static void registerAnnotationDefaults(AnnotationClassValue<?> annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    public static void registerAnnotationType(AnnotationClassValue<?> annotation) {
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    protected final void addRepeatable(String annotationName, AnnotationValue annotationValue) {
        this.addRepeatable(annotationName, annotationValue, annotationValue.getRetentionPolicy());
    }

    protected final void addRepeatable(String annotationName, AnnotationValue annotationValue, RetentionPolicy retentionPolicy) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations, retentionPolicy);
        }
    }

    protected void addRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, allStereotypes, RetentionPolicy.RUNTIME);
    }

    protected void addDeclaredRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, declaredStereotypes, RetentionPolicy.RUNTIME);
        this.addRepeatableInternal(stereotype, annotationValue, this.getAllStereotypes(), RetentionPolicy.RUNTIME);
    }

    protected final void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue) {
        this.addDeclaredRepeatable(annotationName, annotationValue, annotationValue.getRetentionPolicy());
    }

    protected final void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue, RetentionPolicy retentionPolicy) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getDeclaredAnnotationsInternal();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations, retentionPolicy);
            this.addRepeatable(annotationName, annotationValue);
        }
    }

    protected final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        this.addStereotype(parentAnnotations, stereotype, values, RetentionPolicy.RUNTIME);
    }

    protected final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, null, allStereotypes, false, retentionPolicy);
            }
        }
    }

    protected final void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        this.addDeclaredStereotype(parentAnnotations, stereotype, values, RetentionPolicy.RUNTIME);
    }

    protected final void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, declaredStereotypes, allStereotypes, true, retentionPolicy);
            }
        }
    }

    protected void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.addDeclaredAnnotation(annotation, values, RetentionPolicy.RUNTIME);
    }

    protected void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatable(annotation, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatable(annotation, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredAnnotations = this.getDeclaredAnnotationsInternal();
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, declaredAnnotations, allAnnotations, true, retentionPolicy);
            }
        }
    }

    @Internal
    void dump() {
        System.out.println("declaredAnnotations = " + this.declaredAnnotations);
        System.out.println("declaredStereotypes = " + this.declaredStereotypes);
        System.out.println("allAnnotations = " + this.allAnnotations);
        System.out.println("allStereotypes = " + this.allStereotypes);
        System.out.println("annotationsByStereotype = " + this.annotationsByStereotype);
    }

    private <T extends Annotation> List<AnnotationValue<T>> resolveAnnotationValuesByType(Class<T> annotationType, Map<String, Map<CharSequence, Object>> sourceAnnotations, Map<String, Map<CharSequence, Object>> sourceStereotypes) {
        Class<? extends Annotation> repeatableType;
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        if (repeatable != null && this.hasStereotype(repeatableType = repeatable.value())) {
            Map<CharSequence, Object> values;
            ArrayList<AnnotationValue<T>> results = new ArrayList<AnnotationValue<T>>();
            if (sourceAnnotations != null) {
                values = sourceAnnotations.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            if (sourceStereotypes != null) {
                values = sourceStereotypes.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            return results;
        }
        return null;
    }

    private void addAnnotation(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> declaredAnnotations, Map<String, Map<CharSequence, Object>> allAnnotations, boolean isDeclared, RetentionPolicy retentionPolicy) {
        if (isDeclared && declaredAnnotations != null) {
            this.putValues(annotation, values, declaredAnnotations);
        }
        this.putValues(annotation, values, allAnnotations);
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            this.addSourceRetentionAnnotation(annotation);
        }
    }

    private void addSourceRetentionAnnotation(String annotation) {
        if (this.sourceRetentionAnnotations == null) {
            this.sourceRetentionAnnotations = new HashSet<String>(5);
        }
        this.sourceRetentionAnnotations.add(annotation);
    }

    private void putValues(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> currentAnnotationValues) {
        Map<CharSequence, Object> existing = currentAnnotationValues.get(annotation);
        boolean hasValues = CollectionUtils.isNotEmpty(values);
        if (existing != null && hasValues) {
            if (existing.isEmpty()) {
                existing = new LinkedHashMap<CharSequence, Object>();
                currentAnnotationValues.put(annotation, existing);
            }
            for (CharSequence key : values.keySet()) {
                if (existing.containsKey(key)) continue;
                existing.put(key, values.get(key));
            }
        } else {
            if (!hasValues) {
                existing = existing == null ? Collections.emptyMap() : existing;
            } else {
                existing = new LinkedHashMap<CharSequence, Object>(values.size());
                existing.putAll(values);
            }
            currentAnnotationValues.put(annotation, existing);
        }
    }

    private Map<String, Map<CharSequence, Object>> getAllStereotypes() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.allStereotypes;
        if (stereotypes == null) {
            this.allStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredStereotypesInternal() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.declaredStereotypes;
        if (stereotypes == null) {
            this.declaredStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getAllAnnotations() {
        Map<String, Map<CharSequence, Object>> annotations = this.allAnnotations;
        if (annotations == null) {
            this.allAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredAnnotationsInternal() {
        Map<String, Map<CharSequence, Object>> annotations = this.declaredAnnotations;
        if (annotations == null) {
            this.declaredAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private List<String> getAnnotationsByStereotypeInternal(String stereotype) {
        return this.getAnnotationsByStereotypeInternal().computeIfAbsent(stereotype, s -> new ArrayList());
    }

    private String getRepeatedName(String annotation) {
        if (this.repeated != null) {
            return this.repeated.get(annotation);
        }
        return null;
    }

    private Map<String, List<String>> getAnnotationsByStereotypeInternal() {
        Map<String, List<String>> annotations = this.annotationsByStereotype;
        if (annotations == null) {
            this.annotationsByStereotype = annotations = new HashMap<String, List<String>>(3);
        }
        return annotations;
    }

    @Nullable
    private Object getRawSingleValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawValue(annotation, member);
        if (rawValue != null) {
            Iterator i;
            if (rawValue.getClass().isArray()) {
                int len = Array.getLength(rawValue);
                if (len > 0) {
                    rawValue = Array.get(rawValue, 0);
                }
            } else if (rawValue instanceof Iterable && (i = ((Iterable)rawValue).iterator()).hasNext()) {
                rawValue = i.next();
            }
        }
        if (valueMapper != null && rawValue instanceof CharSequence) {
            return valueMapper.apply(rawValue);
        }
        return rawValue;
    }

    @Nullable
    private Object getRawValue(@NonNull String annotation, @NonNull String member) {
        Object rawValue = null;
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                rawValue = values.get(member);
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                rawValue = values.get(member);
            }
        }
        return rawValue;
    }

    private void addRepeatableInternal(String annotationName, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations, RetentionPolicy retentionPolicy) {
        this.addRepeatableInternal(annotationName, "value", annotationValue, allAnnotations, retentionPolicy);
    }

    private void addRepeatableInternal(String annotationName, String member, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations, RetentionPolicy retentionPolicy) {
        Map values;
        Object v;
        if (this.repeated == null) {
            this.repeated = new HashMap<String, String>(2);
        }
        this.repeated.put(annotationName, annotationValue.getAnnotationName());
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            this.addSourceRetentionAnnotation(annotationName);
        }
        if ((v = (values = allAnnotations.computeIfAbsent(annotationName, s -> new HashMap())).get(member)) != null) {
            if (v.getClass().isArray()) {
                Object[] array = (Object[])v;
                LinkedHashSet<Object> newValues = new LinkedHashSet<Object>(array.length + 1);
                newValues.addAll(Arrays.asList(array));
                newValues.add(annotationValue);
                values.put(member, newValues);
            } else if (v instanceof Collection) {
                ((Collection)v).add(annotationValue);
            }
        } else {
            LinkedHashSet<AnnotationValue> newValues = new LinkedHashSet<AnnotationValue>(2);
            newValues.add(annotationValue);
            values.put(member, newValues);
        }
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, String annotationName, String member, Object value) {
        return DefaultAnnotationMetadata.mutateMember(annotationMetadata, annotationName, Collections.singletonMap(member, value));
    }

    @Internal
    public static void contributeDefaults(AnnotationMetadata target, AnnotationMetadata source) {
        if (source instanceof AnnotationMetadataHierarchy) {
            source = ((AnnotationMetadataHierarchy)source).getDeclaredMetadata();
        }
        if (target instanceof DefaultAnnotationMetadata && source instanceof DefaultAnnotationMetadata) {
            Map<String, Map<CharSequence, Object>> existingDefaults = ((DefaultAnnotationMetadata)target).annotationDefaultValues;
            if (existingDefaults != null) {
                Map<String, Map<CharSequence, Object>> additionalDefaults = ((DefaultAnnotationMetadata)source).annotationDefaultValues;
                if (additionalDefaults != null) {
                    existingDefaults.putAll(additionalDefaults);
                }
            } else {
                Map<String, Map<CharSequence, Object>> additionalDefaults = ((DefaultAnnotationMetadata)source).annotationDefaultValues;
                if (additionalDefaults != null) {
                    additionalDefaults.forEach(((DefaultAnnotationMetadata)target)::addDefaultAnnotationValues);
                }
            }
        }
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, final String annotationName, final Map<CharSequence, Object> members) {
        if (StringUtils.isEmpty((CharSequence)annotationName)) {
            throw new IllegalArgumentException("Argument [annotationName] cannot be blank");
        }
        if (!members.isEmpty()) {
            for (Map.Entry<CharSequence, Object> entry : members.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
                    throw new IllegalArgumentException("Argument [members] cannot have a blank key");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("Argument [members] cannot have a null value. Key [" + entry.getKey() + "]");
            }
        }
        if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
            return new DefaultAnnotationMetadata(){
                {
                    this.addDeclaredAnnotation(annotationName, members);
                }
            };
        }
        DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
        defaultMetadata = defaultMetadata.clone();
        defaultMetadata.addDeclaredAnnotation(annotationName, members);
        return defaultMetadata;
    }

    static {
        ConversionService.SHARED.addConverter(AnnotationValue.class, Annotation.class, (object, targetType, context) -> {
            Optional annotationClass = ClassUtils.forName((String)object.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
            return annotationClass.map(aClass -> AnnotationMetadataSupport.buildAnnotation(aClass, object));
        });
        ConversionService.SHARED.addConverter(AnnotationValue[].class, Object[].class, (object, targetType, context) -> {
            ArrayList result = new ArrayList();
            Class annotationClass = null;
            for (AnnotationValue annotationValue : object) {
                if (annotationClass == null) {
                    Optional aClass = ClassUtils.forName((String)annotationValue.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
                    if (!aClass.isPresent()) break;
                    annotationClass = (Class)aClass.get();
                }
                Object annotation = AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
                result.add(annotation);
            }
            if (!result.isEmpty()) {
                return Optional.of(result.toArray((Object[])Array.newInstance(annotationClass, result.size())));
            }
            return Optional.empty();
        });
    }
}

