/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.Internal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

@Internal
class DefaultMessageContext
implements MessageSource.MessageContext {
    @Nullable
    private final Locale locale;
    @Nullable
    private final Map<String, Object> variables;

    DefaultMessageContext(@Nullable Locale locale, @Nullable Map<String, Object> variables) {
        this.locale = locale;
        this.variables = variables;
    }

    @Override
    @NonNull
    public Map<String, Object> getVariables() {
        if (this.variables != null) {
            return Collections.unmodifiableMap(this.variables);
        }
        return Collections.emptyMap();
    }

    @Override
    @NonNull
    public Locale getLocale() {
        return this.getLocale(Locale.getDefault());
    }

    @Override
    @NonNull
    public Locale getLocale(@Nullable Locale defaultLocale) {
        if (this.locale != null) {
            return this.locale;
        }
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }
}

