/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

@Internal
abstract class AbstractExecutable
implements Executable {
    protected final Class declaringType;
    protected final String methodName;
    protected final Class[] argTypes;
    private Argument[] arguments;
    private Method method;

    AbstractExecutable(Class declaringType, String methodName, Argument[] arguments) {
        Objects.requireNonNull(declaringType, "Declaring type cannot be null");
        Objects.requireNonNull(methodName, "Method name cannot be null");
        this.argTypes = Argument.toClassArray((Argument[])arguments);
        this.declaringType = declaringType;
        this.methodName = methodName;
        this.arguments = ArrayUtils.isNotEmpty((Object[])arguments) ? arguments : Argument.ZERO_ARGUMENTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExecutable)) {
            return false;
        }
        AbstractExecutable that = (AbstractExecutable)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringType, this.methodName);
        result = 31 * result + Arrays.hashCode(this.argTypes);
        return result;
    }

    public Argument[] getArguments() {
        return this.arguments;
    }

    public final Method getTargetMethod() {
        if (this.method == null) {
            Method resolvedMethod = this.resolveTargetMethod();
            resolvedMethod.setAccessible(true);
            this.method = resolvedMethod;
        }
        return this.method;
    }

    @NonNull
    protected Method resolveTargetMethod() {
        return ReflectionUtils.getRequiredMethod((Class)this.declaringType, (String)this.methodName, (Class[])this.argTypes);
    }
}

