/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.Collections;

@Internal
final class JavaParameterElement
extends AbstractJavaElement
implements ParameterElement {
    private final JavaClassElement owningType;
    private final MethodElement methodElement;
    private ClassElement typeElement;
    private ClassElement genericTypeElement;

    JavaParameterElement(JavaClassElement owningType, MethodElement methodElement, JavaNativeElement.Variable nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(nativeElement, annotationMetadataFactory, visitorContext);
        this.owningType = owningType;
        this.methodElement = methodElement;
    }

    @Override
    @NonNull
    public JavaNativeElement.Variable getNativeType() {
        return (JavaNativeElement.Variable)super.getNativeType();
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaParameterElement(this.owningType, this.methodElement, this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext);
    }

    public ParameterElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ParameterElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @NonNull
    public ClassElement getType() {
        if (this.typeElement == null) {
            this.typeElement = this.newClassElement(this.getNativeType(), this.getNativeType().element().asType(), Collections.emptyMap());
        }
        return this.typeElement;
    }

    @NonNull
    public ClassElement getGenericType() {
        if (this.genericTypeElement == null) {
            this.genericTypeElement = this.newClassElement(this.getNativeType(), this.getNativeType().element().asType(), this.methodElement.getTypeArguments());
        }
        return this.genericTypeElement;
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }
}

