/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.TypedMessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@BootstrapContextCompatible
public final class WritableBodyWriter
implements TypedMessageBodyHandler<Writable>,
ChunkedMessageBodyReader<Writable>,
ResponseBodyWriter<Writable> {
    private final ApplicationConfiguration applicationConfiguration;

    public WritableBodyWriter(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public Argument<Writable> getType() {
        return Argument.of(Writable.class);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void writeTo(Argument<Writable> type, MediaType mediaType, Writable object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (mediaType != null) {
            outgoingHeaders.setIfMissing((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
        try {
            object.writeTo(outputStream, MessageBodyWriter.getCharset(mediaType, (Headers)outgoingHeaders));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }

    private Writable read0(ByteBuffer<?> byteBuffer) {
        String s = byteBuffer.toString(this.applicationConfiguration.getDefaultCharset());
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return w -> w.write(s);
    }

    @Override
    public Publisher<? extends Writable> readChunked(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return Flux.from(input).map(this::read0);
    }

    @Override
    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return this.read0(byteBuffer);
    }

    @Override
    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        String s;
        try {
            s = new String(inputStream.readAllBytes(), this.applicationConfiguration.getDefaultCharset());
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
        return w -> w.write(s);
    }

    @Override
    @NonNull
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<Writable> type, @NonNull MediaType mediaType, Writable object) throws CodecException {
        try {
            return bodyFactory.buffer(o -> object.writeTo(o, MessageBodyWriter.getCharset(mediaType, response.getHeaders())));
        }
        catch (IOException e) {
            throw new CodecException("Failed to buffer Writable", e);
        }
    }
}

