/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriterWrapper;
import io.micronaut.http.codec.CodecException;

@Indexed(value=MessageBodyWriter.class)
public interface ResponseBodyWriter<T>
extends MessageBodyWriter<T> {
    @NonNull
    default public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<T> httpResponse, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) throws CodecException {
        httpResponse.getHeaders().contentTypeIfMissing(mediaType);
        return ByteBodyHttpResponseWrapper.wrap(httpResponse, this.writePiece(bodyFactory, request, httpResponse, type, mediaType, object));
    }

    @NonNull
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory var1, @NonNull HttpRequest<?> var2, @NonNull HttpResponse<?> var3, @NonNull Argument<T> var4, @NonNull MediaType var5, T var6) throws CodecException;

    @NonNull
    public static <T> ResponseBodyWriter<T> wrap(@NonNull MessageBodyWriter<T> writer) {
        if (writer instanceof ResponseBodyWriter) {
            ResponseBodyWriter rbw = (ResponseBodyWriter)writer;
            return rbw;
        }
        return new ResponseBodyWriterWrapper<T>(writer);
    }
}

