/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractMessageBodyHandlerRegistry
implements MessageBodyHandlerRegistry {
    private static final MessageBodyReader<Object> NO_READER = new NoReader();
    private static final MessageBodyWriter<Object> NO_WRITER = new NoWriter();
    private final Map<HandlerKey<?>, MessageBodyReader<?>> readers = new ConcurrentHashMap(10);
    private final Map<HandlerKey<?>, MessageBodyWriter<?>> writers = new ConcurrentHashMap(10);

    AbstractMessageBodyHandlerRegistry() {
    }

    protected abstract <T> MessageBodyReader<T> findReaderImpl(Argument<T> var1, List<MediaType> var2);

    @Override
    public <T> Optional<MessageBodyReader<T>> findReader(Argument<T> type, List<MediaType> mediaTypes) {
        HandlerKey<T> key = new HandlerKey<T>(type, mediaTypes);
        MessageBodyReader<?> messageBodyReader = this.readers.get(key);
        if (messageBodyReader == null) {
            MessageBodyReader<T> reader = this.findReaderImpl(type, mediaTypes);
            if (reader != null) {
                this.readers.put(key, reader);
                return Optional.of(reader);
            }
            this.readers.put(key, NO_READER);
            return Optional.empty();
        }
        if (messageBodyReader == NO_READER) {
            return Optional.empty();
        }
        return Optional.of(messageBodyReader);
    }

    protected abstract <T> MessageBodyWriter<T> findWriterImpl(Argument<T> var1, List<MediaType> var2);

    @Override
    public <T> Optional<MessageBodyWriter<T>> findWriter(Argument<T> type, List<MediaType> mediaTypes) {
        if (type.getType() == Object.class) {
            return Optional.empty();
        }
        HandlerKey<T> key = new HandlerKey<T>(type, mediaTypes);
        MessageBodyWriter<?> messageBodyWriter = this.writers.get(key);
        if (messageBodyWriter == null) {
            MessageBodyWriter<T> writer = this.findWriterImpl(type, mediaTypes);
            if (writer != null) {
                this.writers.put(key, writer);
                return Optional.of(writer);
            }
            this.writers.put(key, NO_WRITER);
            return Optional.empty();
        }
        if (messageBodyWriter == NO_WRITER) {
            return Optional.empty();
        }
        return Optional.of(messageBodyWriter);
    }

    private record HandlerKey<T>(Argument<T> type, List<MediaType> mediaTypes) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerKey that = (HandlerKey)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash((Object)this.type.typeHashCode(), this.mediaTypes);
        }
    }

    private static final class NoReader
    implements MessageBodyReader<Object> {
        private NoReader() {
        }

        @Override
        public boolean isReadable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
            return null;
        }

        @Override
        public Object read(Argument<Object> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
            return null;
        }
    }

    private static final class NoWriter
    implements MessageBodyWriter<Object> {
        private NoWriter() {
        }

        @Override
        public boolean isWriteable(Argument<Object> type, MediaType mediaType) {
            return false;
        }

        @Override
        public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            throw new UnsupportedOperationException();
        }
    }
}

