/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

@Internal
final class ByteQueue {
    private final Queue<ByteBuffer> queue = new ArrayDeque<ByteBuffer>();

    ByteQueue() {
    }

    public void addCopy(byte[] arr, int off, int len) {
        this.add(Arrays.copyOfRange(arr, off, off + len));
    }

    private void add(byte[] arr) {
        if (arr.length == 0) {
            return;
        }
        this.queue.add(ByteBuffer.wrap(arr));
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int take(byte[] arr, int off, int len) {
        ByteBuffer peek = this.queue.peek();
        if (peek == null) {
            throw new IllegalStateException("Queue is empty");
        }
        int n = Math.min(len, peek.remaining());
        peek.get(arr, off, n);
        if (peek.remaining() == 0) {
            this.queue.poll();
        }
        return n;
    }

    public void clear() {
        this.queue.clear();
    }
}

