/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.uri.UriMatchInfo;
import java.util.Optional;

public final class BasicHttpAttributes {
    private BasicHttpAttributes() {
    }

    public static Optional<UriMatchInfo> getRouteMatchInfo(HttpRequest<?> request) {
        return request.getAttribute(HttpAttributes.ROUTE_MATCH, UriMatchInfo.class);
    }

    @NonNull
    public static Optional<String> getUriTemplate(HttpRequest<?> request) {
        return request.getAttribute(HttpAttributes.URI_TEMPLATE, String.class);
    }

    public static void setUriTemplate(@NonNull HttpRequest<?> request, @NonNull String uriTemplate) {
        request.setAttribute(HttpAttributes.URI_TEMPLATE, uriTemplate);
    }

    @NonNull
    public static Optional<String> getServiceId(@NonNull HttpRequest<?> request) {
        return request.getAttribute(HttpAttributes.SERVICE_ID, String.class);
    }
}

