/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.caffeine.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.micronaut.cache.Cache;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import jakarta.inject.Singleton;
import java.util.Collections;

@RequiresMetrics
@Singleton
@Requires(property="micronaut.metrics.binders.cache.enabled", notEquals="false")
public class CaffeineCacheMetricsBinder
implements BeanCreatedEventListener<Cache<?>> {
    private final BeanProvider<MeterRegistry> meterRegistryProvider;

    public CaffeineCacheMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    public Cache<?> onCreated(BeanCreatedEvent<Cache<?>> event) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        Cache cache = (Cache)event.getBean();
        Object nativeCache = cache.getNativeCache();
        if (nativeCache instanceof com.github.benmanes.caffeine.cache.Cache) {
            CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, (com.github.benmanes.caffeine.cache.Cache)((com.github.benmanes.caffeine.cache.Cache)nativeCache), (String)cache.getName(), Collections.emptyList());
        }
        return cache;
    }
}

