/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.tracing.ScopedSpan;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;

class OtelScopedSpan
implements ScopedSpan {
    final Span span;
    final Scope scope;

    OtelScopedSpan(Span span, Scope scope) {
        this.span = span;
        this.scope = scope;
    }

    public boolean isNoop() {
        return !this.span.isRecording();
    }

    public TraceContext context() {
        return new OtelTraceContext(this.span);
    }

    public ScopedSpan name(String name) {
        this.span.updateName(name);
        return this;
    }

    public ScopedSpan tag(String key, String value) {
        this.span.setAttribute(key, value);
        return this;
    }

    public ScopedSpan event(String value) {
        this.span.addEvent(value);
        return this;
    }

    public ScopedSpan error(Throwable throwable) {
        this.span.recordException(throwable);
        return this;
    }

    public void end() {
        this.scope.close();
        this.span.end();
    }
}

