/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.brave.bridge.BraveFinishedSpan;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import java.util.Collections;
import java.util.List;

public class CompositeSpanHandler
extends SpanHandler {
    private final List<SpanExportingPredicate> filters;
    private final List<SpanReporter> reporters;
    private final List<SpanFilter> spanFilters;

    public CompositeSpanHandler(@Nullable List<SpanExportingPredicate> predicates, @Nullable List<SpanReporter> reporters, @Nullable List<SpanFilter> spanFilters) {
        this.filters = predicates == null ? Collections.emptyList() : predicates;
        this.reporters = reporters == null ? Collections.emptyList() : reporters;
        this.spanFilters = spanFilters == null ? Collections.emptyList() : spanFilters;
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (cause != SpanHandler.Cause.FINISHED) {
            return true;
        }
        boolean shouldProcess = this.shouldProcess(span);
        if (!shouldProcess) {
            return false;
        }
        shouldProcess = super.end(context, span, cause);
        if (!shouldProcess) {
            return false;
        }
        FinishedSpan modified = BraveFinishedSpan.fromBrave(span);
        for (SpanFilter spanFilter : this.spanFilters) {
            modified = spanFilter.map(modified);
        }
        for (SpanReporter reporter : this.reporters) {
            reporter.report(modified);
        }
        return true;
    }

    private boolean shouldProcess(MutableSpan span) {
        for (SpanExportingPredicate exporter : this.filters) {
            if (exporter.isExportable(BraveFinishedSpan.fromBrave(span))) continue;
            return false;
        }
        return true;
    }
}

