/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.common.lang.NonNull;
import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.elastic.DefaultIndexTemplateCreator;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticNamingConvention;
import io.micrometer.elastic.IndexTemplateCreator;
import io.micrometer.elastic.LegacyIndexTemplateCreator;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("elastic-metrics-publisher");
    static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private static final Pattern MAJOR_VERSION_PATTERN = Pattern.compile("\"number\" *: *\"([\\d]+)");
    private static final String ERROR_RESPONSE_BODY_SIGNATURE = "\"errors\":true";
    private static final Pattern STATUS_CREATED_PATTERN = Pattern.compile("\"status\":201");
    private final Logger logger = LoggerFactory.getLogger(ElasticMeterRegistry.class);
    private final ElasticConfig config;
    private final HttpSender httpClient;
    private final DateTimeFormatter indexDateFormatter;
    private final String actionLine;
    private volatile boolean checkedForIndexTemplate;

    public ElasticMeterRegistry(ElasticConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    protected ElasticMeterRegistry(ElasticConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new ElasticNamingConvention());
        this.config = config;
        this.indexDateFormatter = DateTimeFormatter.ofPattern(config.indexDateFormat());
        this.httpClient = httpClient;
        this.actionLine = StringUtils.isNotEmpty((String)config.pipeline()) ? "{ \"create\" : {\"pipeline\":\"" + config.pipeline() + "\"} }\n" : "{ \"create\" : {} }\n";
        this.start(threadFactory);
    }

    public static Builder builder(ElasticConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        this.createIndexTemplateIfNeeded();
        String uri = this.config.host() + "/" + this.indexName() + "/_bulk";
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                String requestBody = batch.stream().map(m -> (Optional)m.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n", "", "\n"));
                this.connect(HttpSender.Method.POST, uri).withJsonContent(requestBody).send().onSuccess(response -> {
                    int numberOfSentItems = batch.size();
                    String responseBody = response.body();
                    if (responseBody.contains(ERROR_RESPONSE_BODY_SIGNATURE)) {
                        int numberOfCreatedItems = ElasticMeterRegistry.countCreatedItems(responseBody);
                        this.logger.debug("failed metrics payload: {}", (Object)requestBody);
                        this.logger.error("failed to send metrics to elastic (sent {} metrics but created {} metrics): {}", new Object[]{numberOfSentItems, numberOfCreatedItems, responseBody});
                    } else {
                        this.logger.debug("successfully sent {} metrics to elastic", (Object)numberOfSentItems);
                    }
                }).onError(response -> {
                    this.logger.debug("failed metrics payload: {}", (Object)requestBody);
                    this.logger.error("failed to send metrics to elastic: {}", (Object)response.body());
                });
            }
            catch (Throwable e) {
                this.logger.error("failed to send metrics to elastic", e);
            }
        }
    }

    private void createIndexTemplateIfNeeded() {
        if (this.checkedForIndexTemplate || !this.config.autoCreateIndex()) {
            return;
        }
        if (this.config.enableSource()) {
            this.logger.warn("'_source' field is enabled. Disable '_source' field to save space and reduce I/O.");
        }
        this.attemptIndexTemplateCreation(new DefaultIndexTemplateCreator(this.httpClient));
        if (!this.checkedForIndexTemplate) {
            this.logger.debug("Attempt to create index template using legacy /_template/ endpoint");
            this.attemptIndexTemplateCreation(new LegacyIndexTemplateCreator(this.httpClient));
        }
    }

    private void attemptIndexTemplateCreation(IndexTemplateCreator creator) {
        IndexTemplateCreator.IndexTemplateStatus indexTemplateStatus = creator.fetchIndexTemplateStatus(this.config);
        switch (indexTemplateStatus) {
            case MISSING: {
                try {
                    creator.createIndexTemplate(this.config);
                    this.checkedForIndexTemplate = true;
                }
                catch (Throwable exc) {
                    this.logger.error("Could not create index template in Elastic", exc);
                }
                break;
            }
            case EXISTS: {
                this.checkedForIndexTemplate = true;
                break;
            }
        }
    }

    private HttpSender.Request.Builder connect(HttpSender.Method method, String uri) {
        return this.authentication(this.httpClient.newRequest(uri).withMethod(method));
    }

    private HttpSender.Request.Builder authentication(HttpSender.Request.Builder request) {
        if (StringUtils.isNotBlank((String)this.config.apiKeyCredentials())) {
            return request.withAuthentication("ApiKey", this.config.apiKeyCredentials());
        }
        return request.withBasicAuthentication(this.config.userName(), this.config.password());
    }

    static int getMajorVersion(String responseBody) {
        Matcher matcher = MAJOR_VERSION_PATTERN.matcher(responseBody);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected response body: " + responseBody);
        }
        return Integer.parseInt(matcher.group(1));
    }

    static int countCreatedItems(String responseBody) {
        Matcher matcher = STATUS_CREATED_PATTERN.matcher(responseBody);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    protected String indexName() {
        ZonedDateTime dt = ZonedDateTime.ofInstant(new Date(this.config().clock().wallTime()).toInstant(), ZoneOffset.UTC);
        return this.config.index() + this.config.indexDateSeparator() + this.indexDateFormatter.format(dt);
    }

    Optional<String> writeCounter(Counter counter) {
        return this.writeCounter((Meter)counter, counter.count());
    }

    Optional<String> writeFunctionCounter(FunctionCounter counter) {
        return this.writeCounter((Meter)counter, counter.count());
    }

    private Optional<String> writeCounter(Meter meter, double value) {
        if (Double.isFinite(value)) {
            return Optional.of(this.writeDocument(meter, builder -> builder.append(",\"count\":").append(value)));
        }
        return Optional.empty();
    }

    Optional<String> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            return Optional.of(this.writeDocument((Meter)gauge, builder -> builder.append(",\"value\":").append(value)));
        }
        return Optional.empty();
    }

    Optional<String> writeTimeGauge(TimeGauge gauge) {
        double value = gauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Optional.of(this.writeDocument((Meter)gauge, builder -> builder.append(",\"value\":").append(value)));
        }
        return Optional.empty();
    }

    Optional<String> writeFunctionTimer(FunctionTimer timer) {
        double sum = timer.totalTime(this.getBaseTimeUnit());
        double mean = timer.mean(this.getBaseTimeUnit());
        if (Double.isFinite(sum) && Double.isFinite(mean)) {
            return Optional.of(this.writeDocument((Meter)timer, builder -> {
                builder.append(",\"count\":").append(timer.count());
                builder.append(",\"sum\":").append(sum);
                builder.append(",\"mean\":").append(mean);
            }));
        }
        return Optional.empty();
    }

    Optional<String> writeLongTaskTimer(LongTaskTimer timer) {
        return Optional.of(this.writeDocument((Meter)timer, builder -> {
            builder.append(",\"activeTasks\":").append(timer.activeTasks());
            builder.append(",\"duration\":").append(timer.duration(this.getBaseTimeUnit()));
        }));
    }

    Optional<String> writeTimer(Timer timer) {
        return Optional.of(this.writeDocument((Meter)timer, builder -> {
            builder.append(",\"count\":").append(timer.count());
            builder.append(",\"sum\":").append(timer.totalTime(this.getBaseTimeUnit()));
            builder.append(",\"mean\":").append(timer.mean(this.getBaseTimeUnit()));
            builder.append(",\"max\":").append(timer.max(this.getBaseTimeUnit()));
        }));
    }

    Optional<String> writeSummary(DistributionSummary summary) {
        HistogramSnapshot histogramSnapshot = summary.takeSnapshot();
        return Optional.of(this.writeDocument((Meter)summary, builder -> {
            builder.append(",\"count\":").append(histogramSnapshot.count());
            builder.append(",\"sum\":").append(histogramSnapshot.total());
            builder.append(",\"mean\":").append(histogramSnapshot.mean());
            builder.append(",\"max\":").append(histogramSnapshot.max());
        }));
    }

    Optional<String> writeMeter(Meter meter) {
        Iterable measurements = meter.measure();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (Measurement measurement : measurements) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            names.add(measurement.getStatistic().getTagValueRepresentation());
            values.add(value);
        }
        if (names.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.writeDocument(meter, builder -> {
            for (int i = 0; i < names.size(); ++i) {
                builder.append(",\"").append((String)names.get(i)).append("\":\"").append(values.get(i)).append("\"");
            }
        }));
    }

    protected String generateTimestamp() {
        return TIMESTAMP_FORMATTER.format(Instant.ofEpochMilli(this.config().clock().wallTime()));
    }

    String writeDocument(Meter meter, Consumer<StringBuilder> consumer) {
        StringBuilder sb = new StringBuilder(this.actionLine);
        String timestamp = this.generateTimestamp();
        String name = this.getConventionName(meter.getId());
        String type = meter.getId().getType().toString().toLowerCase();
        sb.append("{\"").append(this.config.timestampFieldName()).append("\":\"").append(timestamp).append('\"').append(",\"name\":\"").append(StringEscapeUtils.escapeJson((String)name)).append('\"').append(",\"type\":\"").append(type).append('\"');
        List tags = this.getConventionTags(meter.getId());
        for (Tag tag : tags) {
            sb.append(",\"").append(StringEscapeUtils.escapeJson((String)tag.getKey())).append("\":\"").append(StringEscapeUtils.escapeJson((String)tag.getValue())).append('\"');
        }
        consumer.accept(sb);
        sb.append('}');
        return sb.toString();
    }

    @NonNull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final ElasticConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = ElasticMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(ElasticConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ElasticMeterRegistry build() {
            return new ElasticMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

