/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.observation.Observation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ObservationHandler<T extends Observation.Context> {
    default public void onStart(T context) {
    }

    default public void onError(T context) {
    }

    default public void onEvent(Observation.Event event, T context) {
    }

    default public void onScopeOpened(T context) {
    }

    default public void onScopeClosed(T context) {
    }

    default public void onScopeReset(T context) {
    }

    default public void onStop(T context) {
    }

    public boolean supportsContext(Observation.Context var1);

    public static class AllMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public AllMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public AllMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            this.handlers = handlers.stream().map(handler -> handler).collect(Collectors.toList());
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onStart(context));
        }

        @Override
        public void onError(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onError(context));
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onEvent(event, context));
        }

        @Override
        public void onScopeOpened(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onScopeOpened(context));
        }

        @Override
        public void onScopeClosed(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onScopeClosed(context));
        }

        @Override
        public void onScopeReset(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onScopeReset(context));
        }

        @Override
        public void onStop(Observation.Context context) {
            this.getAllApplicableHandlers(context).forEach(handler -> handler.onStop(context));
        }

        @Override
        public boolean supportsContext(Observation.Context context) {
            return this.getAllApplicableHandlers(context).findAny().isPresent();
        }

        private Stream<ObservationHandler<Observation.Context>> getAllApplicableHandlers(Observation.Context context) {
            return this.handlers.stream().filter(handler -> handler.supportsContext(context));
        }
    }

    public static class FirstMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public FirstMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public FirstMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            this.handlers = handlers.stream().map(handler -> handler).collect(Collectors.toList());
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onStart(context));
        }

        @Override
        public void onError(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onError(context));
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onEvent(event, context));
        }

        @Override
        public void onScopeOpened(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onScopeOpened(context));
        }

        @Override
        public void onScopeClosed(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onScopeClosed(context));
        }

        @Override
        public void onScopeReset(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onScopeReset(context));
        }

        @Override
        public void onStop(Observation.Context context) {
            this.getFirstApplicableHandler(context).ifPresent(handler -> handler.onStop(context));
        }

        @Override
        public boolean supportsContext(Observation.Context context) {
            return this.getFirstApplicableHandler(context).isPresent();
        }

        private Optional<ObservationHandler<Observation.Context>> getFirstApplicableHandler(Observation.Context context) {
            return this.handlers.stream().filter(handler -> handler.supportsContext(context)).findFirst();
        }
    }

    public static interface CompositeObservationHandler
    extends ObservationHandler<Observation.Context> {
        public List<ObservationHandler<Observation.Context>> getHandlers();
    }
}

