/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class PoolingHttpClientConnectionManagerMetricsBinder
implements MeterBinder {
    private final PoolingHttpClientConnectionManager connectionManager;
    private final Iterable<Tag> tags;

    public PoolingHttpClientConnectionManagerMetricsBinder(PoolingHttpClientConnectionManager connectionManager, String name, String ... tags) {
        this(connectionManager, name, Tags.of(tags));
    }

    public PoolingHttpClientConnectionManagerMetricsBinder(PoolingHttpClientConnectionManager connectionManager, String name, Iterable<Tag> tags) {
        this.connectionManager = connectionManager;
        this.tags = Tags.concat(tags, "httpclient", name);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry) {
        this.registerTotalMetrics(registry);
    }

    private void registerTotalMetrics(MeterRegistry registry) {
        Gauge.builder("httpcomponents.httpclient.pool.total.max", this.connectionManager, connectionManager -> connectionManager.getTotalStats().getMax()).description("The configured maximum number of allowed persistent connections for all routes.").tags(this.tags).register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connectionManager, connectionManager -> connectionManager.getTotalStats().getAvailable()).description("The number of persistent and leased connections for all routes.").tags(this.tags).tag("state", "available").register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connectionManager, connectionManager -> connectionManager.getTotalStats().getLeased()).description("The number of persistent and leased connections for all routes.").tags(this.tags).tag("state", "leased").register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.pending", this.connectionManager, connectionManager -> connectionManager.getTotalStats().getPending()).description("The number of connection requests being blocked awaiting a free connection for all routes.").tags(this.tags).register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.route.max.default", this.connectionManager, PoolingHttpClientConnectionManager::getDefaultMaxPerRoute).description("The configured default maximum number of allowed persistent connections per route.").tags(this.tags).register(registry);
    }
}

