/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.pubsub.api.sync;

import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.cluster.pubsub.api.sync.PubSubNodeSelection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.function.Predicate;

public interface RedisClusterPubSubCommands<K, V>
extends RedisPubSubCommands<K, V> {
    @Override
    public StatefulRedisClusterPubSubConnection<K, V> getStatefulConnection();

    @Deprecated
    default public PubSubNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    default public PubSubNodeSelection<K, V> upstream() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    @Deprecated
    default public PubSubNodeSelection<K, V> slaves() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    @Deprecated
    default public PubSubNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public PubSubNodeSelection<K, V> replicas() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public PubSubNodeSelection<K, V> replicas(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.REPLICA));
    }

    default public PubSubNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public PubSubNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);
}

