/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.ReadFromImpl;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.List;

public abstract class ReadFrom {
    public static final ReadFrom MASTER = new ReadFromImpl.ReadFromMaster();
    public static final ReadFrom MASTER_PREFERRED = new ReadFromImpl.ReadFromMasterPreferred();
    public static final ReadFrom REPLICA_PREFERRED;
    @Deprecated
    public static final ReadFrom SLAVE_PREFERRED;
    public static final ReadFrom REPLICA;
    @Deprecated
    public static final ReadFrom SLAVE;
    public static final ReadFrom NEAREST;
    public static final ReadFrom ANY;

    public abstract List<RedisNodeDescription> select(Nodes var1);

    protected boolean isOrderSensitive() {
        return false;
    }

    public static ReadFrom valueOf(String name) {
        if (LettuceStrings.isEmpty(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        if (name.equalsIgnoreCase("master")) {
            return MASTER;
        }
        if (name.equalsIgnoreCase("masterPreferred")) {
            return MASTER_PREFERRED;
        }
        if (name.equalsIgnoreCase("slave") || name.equalsIgnoreCase("replica")) {
            return REPLICA;
        }
        if (name.equalsIgnoreCase("slavePreferred") || name.equalsIgnoreCase("replicaPreferred")) {
            return REPLICA_PREFERRED;
        }
        if (name.equalsIgnoreCase("nearest")) {
            return NEAREST;
        }
        if (name.equalsIgnoreCase("any")) {
            return ANY;
        }
        throw new IllegalArgumentException("ReadFrom " + name + " not supported");
    }

    static {
        SLAVE_PREFERRED = REPLICA_PREFERRED = new ReadFromImpl.ReadFromReplicaPreferred();
        SLAVE = REPLICA = new ReadFromImpl.ReadFromReplica();
        NEAREST = new ReadFromImpl.ReadFromNearest();
        ANY = new ReadFromImpl.ReadFromAnyNode();
    }

    public static interface Nodes
    extends Iterable<RedisNodeDescription> {
        public List<RedisNodeDescription> getNodes();
    }
}

