/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.DecoratedCommand;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;

public class CommandWrapper<K, V, T>
implements RedisCommand<K, V, T>,
CompleteableCommand<T>,
DecoratedCommand<K, V, T> {
    private static final AtomicReferenceFieldUpdater<CommandWrapper, Consumer[]> ONCOMPLETE = AtomicReferenceFieldUpdater.newUpdater(CommandWrapper.class, Consumer[].class, "onComplete");
    private static final Consumer<?>[] EMPTY = new Consumer[0];
    protected final RedisCommand<K, V, T> command;
    private volatile Consumer<?>[] onComplete = EMPTY;

    public CommandWrapper(RedisCommand<K, V, T> command) {
        this.command = command;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        this.command.complete();
        Consumer[] consumers = ONCOMPLETE.get(this);
        if (consumers != EMPTY && ONCOMPLETE.compareAndSet(this, consumers, EMPTY)) {
            for (Consumer consumer : consumers) {
                if (this.getOutput() != null) {
                    consumer.accept(this.getOutput().get());
                    continue;
                }
                consumer.accept(null);
            }
        }
    }

    @Override
    public void cancel() {
        this.command.cancel();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        return this.command.completeExceptionally(throwable);
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean isCancelled() {
        return this.command.isCancelled();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        this.command.setOutput(output);
    }

    @Override
    public void onComplete(Consumer<? super T> action) {
        Consumer[] updated;
        Consumer[] existing;
        do {
            existing = ONCOMPLETE.get(this);
            updated = new Consumer[existing.length + 1];
            System.arraycopy(existing, 0, updated, 0, existing.length);
            updated[existing.length] = action;
        } while (!ONCOMPLETE.compareAndSet(this, existing, updated));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.getType());
        sb.append(", output=").append(this.getOutput());
        sb.append(", commandType=").append(this.command.getClass().getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean isDone() {
        return this.command.isDone();
    }

    @Override
    public RedisCommand<K, V, T> getDelegate() {
        return this.command;
    }

    public static <K, V, T> RedisCommand<K, V, T> unwrap(RedisCommand<K, V, T> wrapped) {
        RedisCommand<K, V, T> result = wrapped;
        while (result instanceof DecoratedCommand) {
            result = ((DecoratedCommand)((Object)result)).getDelegate();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisCommand)) {
            return false;
        }
        RedisCommand<K, V, T> left = this.command;
        while (left instanceof DecoratedCommand) {
            left = CommandWrapper.unwrap(left);
        }
        RedisCommand<K, V, T> right = (RedisCommand<K, V, T>)o;
        while (right instanceof DecoratedCommand) {
            right = CommandWrapper.unwrap(right);
        }
        return left == right;
    }

    public int hashCode() {
        RedisCommand<K, V, T> toHash = this.command;
        while (toHash instanceof DecoratedCommand) {
            toHash = CommandWrapper.unwrap(toHash);
        }
        return toHash != null ? toHash.hashCode() : 0;
    }
}

