/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterslave.MasterSlaveConnectionProvider;
import io.lettuce.core.masterslave.ReadOnlyCommands;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Collection;

class MasterSlaveChannelWriter<K, V>
implements RedisChannelWriter {
    private MasterSlaveConnectionProvider<K, V> masterSlaveConnectionProvider;
    private boolean closed = false;

    public MasterSlaveChannelWriter(MasterSlaveConnectionProvider<K, V> masterSlaveConnectionProvider) {
        this.masterSlaveConnectionProvider = masterSlaveConnectionProvider;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        MasterSlaveConnectionProvider.Intent intent = MasterSlaveChannelWriter.getIntent(command.getType());
        StatefulRedisConnection<K, V> connection = this.masterSlaveConnectionProvider.getConnection(intent);
        return connection.dispatch(command);
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        MasterSlaveConnectionProvider.Intent intent = MasterSlaveChannelWriter.getIntent(commands);
        StatefulRedisConnection<K, V> connection = this.masterSlaveConnectionProvider.getConnection(intent);
        return connection.dispatch(commands);
    }

    static MasterSlaveConnectionProvider.Intent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        boolean w = false;
        boolean r = false;
        MasterSlaveConnectionProvider.Intent singleIntent = MasterSlaveConnectionProvider.Intent.WRITE;
        for (RedisCommand<?, ?, ?> command : commands) {
            singleIntent = MasterSlaveChannelWriter.getIntent(command.getType());
            if (singleIntent == MasterSlaveConnectionProvider.Intent.READ) {
                r = true;
            }
            if (singleIntent == MasterSlaveConnectionProvider.Intent.WRITE) {
                w = true;
            }
            if (!r || !w) continue;
            return MasterSlaveConnectionProvider.Intent.WRITE;
        }
        return singleIntent;
    }

    private static MasterSlaveConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        return ReadOnlyCommands.isReadOnlyCommand(type) ? MasterSlaveConnectionProvider.Intent.READ : MasterSlaveConnectionProvider.Intent.WRITE;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.masterSlaveConnectionProvider != null) {
            this.masterSlaveConnectionProvider.close();
            this.masterSlaveConnectionProvider = null;
        }
    }

    public MasterSlaveConnectionProvider<K, V> getMasterSlaveConnectionProvider() {
        return this.masterSlaveConnectionProvider;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.masterSlaveConnectionProvider.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.masterSlaveConnectionProvider.flushCommands();
    }

    @Override
    public void reset() {
        this.masterSlaveConnectionProvider.reset();
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.masterSlaveConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.masterSlaveConnectionProvider.getReadFrom();
    }
}

