/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.ThreadPoolConfig;
import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.microprofile.cdi.ExecuteOn;
import io.helidon.microprofile.cdi.ExecuteOnExtension;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.config.ConfigProvider;

@Interceptor
@ExecuteOn
@Priority(value=4010)
class ExecuteOnInterceptor {
    private static final String EXECUTE_ON = "execute-on";
    private static final String RUN_ON_VIRTUAL_THREAD = "execute-on.virtual";
    private static final String RUN_ON_PLATFORM_THREAD = "execute-on.platform";
    private static final LazyValue<ExecutorService> PLATFORM_EXECUTOR_SERVICE = LazyValue.create(() -> {
        org.eclipse.microprofile.config.Config mpConfig = ConfigProvider.getConfig();
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)mpConfig);
        return ((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ThreadPoolSupplier.builder().threadNamePrefix(EXECUTE_ON)).config((io.helidon.common.config.Config)config.get(RUN_ON_PLATFORM_THREAD))).virtualThreads(false)).build().get();
    });
    private static final LazyValue<ExecutorService> VIRTUAL_EXECUTOR_SERVICE = LazyValue.create(() -> {
        org.eclipse.microprofile.config.Config mpConfig = ConfigProvider.getConfig();
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)mpConfig);
        String threadNamePrefix = config.get(RUN_ON_VIRTUAL_THREAD).get("thread-name-prefix").asString().asOptional().orElse(EXECUTE_ON);
        return ((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ThreadPoolSupplier.builder().threadNamePrefix(threadNamePrefix)).virtualThreads(true)).build().get();
    });
    @Inject
    private ExecuteOnExtension extension;

    ExecuteOnInterceptor() {
    }

    @AroundInvoke
    public Object executeOn(InvocationContext context) throws Throwable {
        ExecuteOn executeOn = this.extension.getAnnotation(context.getMethod());
        return switch (executeOn.value()) {
            default -> throw new MatchException(null, null);
            case ExecuteOn.ThreadType.PLATFORM -> ((ExecutorService)PLATFORM_EXECUTOR_SERVICE.get()).submit(() -> ((InvocationContext)context).proceed()).get(executeOn.timeout(), executeOn.unit());
            case ExecuteOn.ThreadType.VIRTUAL -> ((ExecutorService)VIRTUAL_EXECUTOR_SERVICE.get()).submit(() -> ((InvocationContext)context).proceed()).get(executeOn.timeout(), executeOn.unit());
            case ExecuteOn.ThreadType.EXECUTOR -> ExecuteOnInterceptor.findExecutor(executeOn.executorName()).submit(() -> ((InvocationContext)context).proceed()).get(executeOn.timeout(), executeOn.unit());
        };
    }

    private static ExecutorService findExecutor(String executorName) {
        return (ExecutorService)CDI.current().select(ExecutorService.class, new Annotation[]{NamedLiteral.of((String)executorName)}).get();
    }
}

