/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.logging.common.LogConfig;
import io.helidon.microprofile.cdi.ContainerInstanceHolder;
import io.helidon.microprofile.cdi.HelidonContainerImpl;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

final class BuildTimeInitializer {
    private static volatile HelidonContainerImpl container;
    private static final Lock CONTAINER_ACCESS;

    private BuildTimeInitializer() {
    }

    static HelidonContainerImpl get() {
        return BuildTimeInitializer.accessContainer(() -> {
            if (null == container) {
                BuildTimeInitializer.createContainer();
            }
            return container;
        });
    }

    static void reset() {
        BuildTimeInitializer.accessContainer(() -> {
            container = null;
            return null;
        });
    }

    private static void createContainer() {
        BuildTimeInitializer.accessContainer(() -> {
            container = HelidonContainerImpl.create();
            ContainerInstanceHolder.addListener(BuildTimeInitializer::reset);
            return null;
        });
    }

    private static <T> T accessContainer(Supplier<T> operation) {
        CONTAINER_ACCESS.lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            CONTAINER_ACCESS.unlock();
        }
    }

    static {
        CONTAINER_ACCESS = new ReentrantLock(true);
        LogConfig.initClass();
        try {
            BuildTimeInitializer.createContainer();
        }
        catch (Throwable e) {
            System.getLogger(BuildTimeInitializer.class.getName()).log(System.Logger.Level.ERROR, "Failed to initialize CDI container", e);
            throw e;
        }
    }
}

