/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.common.NativeImageHelper;
import java.lang.invoke.MethodHandles;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.ProxyServices;

class HelidonProxyServices
implements ProxyServices {
    private static final Logger LOGGER = Logger.getLogger(HelidonProxyServices.class.getName());
    private static final String WELD_JAVAX_PREFIX = "org.jboss.weldx.";
    private static final String WELD_JAVA_PREFIX = "org.jboss.weld.";
    private final Map<ClassLoader, ClassDefiningCl> classLoaders = Collections.synchronizedMap(new IdentityHashMap());
    private final ClassLoader contextCl = HelidonProxyServices.class.getClassLoader();
    private final ClassDefiningCl contextClassDefiningCl = this.createCl(this.contextCl);
    private final Module myModule = HelidonProxyServices.class.getModule();

    HelidonProxyServices() {
    }

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        return this.wrapCl(proxiedBeanType.getClassLoader());
    }

    public Class<?> loadBeanClass(String className) {
        return this.contextClassDefiningCl.doLoad(className);
    }

    public void cleanup() {
        this.classLoaders.clear();
    }

    public boolean supportsClassDefining() {
        return true;
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        if (this.weldInternalProxyClassName(className)) {
            return this.wrapCl(originalClass.getClassLoader()).doDefineClass(originalClass, className, classBytes, off, len);
        }
        try {
            return this.defineClassPrivateLookup(originalClass, className, classBytes, off, len);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to create class " + className + " using private lookup", e);
            throw e;
        }
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (this.weldInternalProxyClassName(className)) {
            return this.wrapCl(originalClass.getClassLoader()).doDefineClass(originalClass, className, classBytes, off, len, protectionDomain);
        }
        try {
            return this.defineClassPrivateLookup(originalClass, className, classBytes, off, len);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to create class " + className + " using private lookup", e);
            throw e;
        }
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        return this.wrapCl(originalClass.getClassLoader()).loadClass(classBinaryName);
    }

    private boolean weldInternalProxyClassName(String className) {
        return className.startsWith(WELD_JAVAX_PREFIX) || className.startsWith(WELD_JAVA_PREFIX);
    }

    private Class<?> defineClassPrivateLookup(Class<?> originalClass, String className, byte[] classBytes, int off, int len) {
        MethodHandles.Lookup lookup;
        if (NativeImageHelper.isRuntime()) {
            throw new IllegalStateException("Cannot define class in native image. Class name: " + className + ", original class: " + originalClass.getName());
        }
        LOGGER.finest("Defining class " + className + " original class: " + originalClass.getName());
        try {
            Class<?> lookupClass;
            int index = className.indexOf(36);
            if (index < 0) {
                LOGGER.finest(() -> "Attempt to define a proxy class without a $ in its name. Class name: " + className + ", original class name: " + originalClass.getName());
                lookupClass = originalClass;
            } else {
                lookupClass = this.tryLoading(originalClass, className.substring(0, index));
            }
            Module lookupClassModule = lookupClass.getModule();
            if (!this.myModule.canRead(lookupClassModule)) {
                this.myModule.addReads(lookupClassModule);
            }
            lookup = MethodHandles.privateLookupIn(lookupClass, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to define class " + className, e);
        }
        return this.defineClass(lookup, className, classBytes, off, len);
    }

    private Class<?> tryLoading(Class<?> originalClass, String className) {
        try {
            return originalClass.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Attempt to load class " + className + " failed.", e);
            return originalClass;
        }
    }

    private Class<?> defineClass(MethodHandles.Lookup lookup, String className, byte[] classBytes, int off, int len) {
        try {
            byte[] definitionBytes;
            if (classBytes.length == len) {
                definitionBytes = classBytes;
            } else {
                definitionBytes = new byte[len];
                System.arraycopy(classBytes, off, definitionBytes, 0, len);
            }
            return lookup.defineClass(definitionBytes);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to define class " + className, e);
        }
    }

    private ClassDefiningCl wrapCl(ClassLoader origCl) {
        if (origCl instanceof ClassDefiningCl) {
            return (ClassDefiningCl)origCl;
        }
        if (origCl == this.contextCl) {
            return this.contextClassDefiningCl;
        }
        return this.classLoaders.computeIfAbsent(origCl, this::createCl);
    }

    private ClassDefiningCl createCl(ClassLoader parent) {
        return new ClassDefiningCl(parent);
    }

    private static class ClassDefiningCl
    extends ClassLoader {
        protected ClassDefiningCl(ClassLoader parent) {
            super(parent);
        }

        Class<?> doDefineClass(Class<?> originalClass, String className, byte[] bytes, int off, int len) {
            if (NativeImageHelper.isRuntime()) {
                throw new IllegalStateException("Cannot define class in native image. Class name: " + className + ", original class: " + originalClass.getName());
            }
            LOGGER.finest("Defining class " + className + " original class: " + originalClass.getName());
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return super.defineClass(className, bytes, off, len);
            }
        }

        Class<?> doDefineClass(Class<?> originalClass, String className, byte[] bytes, int off, int len, ProtectionDomain domain) {
            if (NativeImageHelper.isRuntime()) {
                throw new IllegalStateException("Cannot define class in native image. Class name: " + className + ", original class: " + originalClass.getName());
            }
            LOGGER.finest("Defining class " + className + " original class: " + originalClass.getName());
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return super.defineClass(className, bytes, off, len, domain);
            }
        }

        Class<?> doLoad(String className) {
            try {
                return super.loadClass(className, true);
            }
            catch (ClassNotFoundException e) {
                throw BeanLogger.LOG.cannotLoadClass((Object)className, (Throwable)e);
            }
        }
    }
}

