/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.microprofile.cdi.BuildTimeInitializer;
import io.helidon.microprofile.cdi.HelidonCdiProvider;
import io.helidon.microprofile.cdi.HelidonContainer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class ContainerInstanceHolder {
    private static final AtomicReference<HelidonContainer> CONTAINER = new AtomicReference();
    private static final List<Runnable> RESET_LISTENERS = new LinkedList<Runnable>();
    private static boolean isReset = false;

    private ContainerInstanceHolder() {
    }

    static void set(HelidonContainer container) {
        CONTAINER.set(container);
    }

    static synchronized boolean isReset() {
        return isReset;
    }

    static synchronized HelidonContainer get() {
        HelidonContainer helidonContainer = CONTAINER.get();
        if (null == helidonContainer) {
            helidonContainer = ContainerInstanceHolder.fromBuildTimeInitializer();
            CONTAINER.compareAndSet(null, helidonContainer);
        }
        return helidonContainer;
    }

    private static HelidonContainer fromBuildTimeInitializer() {
        return BuildTimeInitializer.get();
    }

    static synchronized void addListener(Runnable runnable) {
        RESET_LISTENERS.add(runnable);
    }

    static synchronized void reset() {
        isReset = true;
        CONTAINER.set(null);
        for (Runnable resetListener : RESET_LISTENERS) {
            resetListener.run();
        }
        HelidonCdiProvider.unset();
        RESET_LISTENERS.clear();
    }
}

