/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.OverrideSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ContentImpl
implements ConfigContent {
    private static final Logger LOGGER = Logger.getLogger(ContentImpl.class.getName());
    private final Object stamp;

    ContentImpl(ConfigContent.Builder<?> builder) {
        this.stamp = builder.stamp();
    }

    @Override
    public Optional<Object> stamp() {
        return Optional.ofNullable(this.stamp);
    }

    static class OverrideContentImpl
    extends ContentImpl
    implements ConfigContent.OverrideContent {
        private final OverrideSource.OverrideData data;

        OverrideContentImpl(ConfigContent.OverrideContent.Builder builder) {
            super(builder);
            this.data = builder.data();
        }

        @Override
        public OverrideSource.OverrideData data() {
            return this.data;
        }
    }

    static class NodeContentImpl
    extends ContentImpl
    implements ConfigContent.NodeContent {
        private final ConfigNode.ObjectNode data;

        NodeContentImpl(ConfigContent.NodeContent.Builder builder) {
            super(builder);
            this.data = builder.node();
        }

        @Override
        public ConfigNode.ObjectNode data() {
            return this.data;
        }
    }

    static class ParsableContentImpl
    extends ContentImpl
    implements ConfigParser.Content {
        private final String mediaType;
        private final InputStream data;
        private final Charset charset;

        ParsableContentImpl(ConfigParser.Content.Builder builder) {
            super(builder);
            this.mediaType = builder.mediaType();
            this.data = builder.data();
            this.charset = builder.charset();
        }

        @Override
        public void close() {
            try {
                this.data.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to close input stream", e);
            }
        }

        @Override
        public Optional<String> mediaType() {
            return Optional.ofNullable(this.mediaType);
        }

        @Override
        public InputStream data() {
            return this.data;
        }

        @Override
        public Charset charset() {
            return this.charset;
        }
    }
}

