/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ClasspathConfigSource;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.DirectoryConfigSource;
import io.helidon.config.EnvironmentVariables;
import io.helidon.config.FileConfigSource;
import io.helidon.config.InMemoryConfigSource;
import io.helidon.config.MapConfigSource;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.PrefixedConfigSource;
import io.helidon.config.UrlConfigSource;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;

public final class ConfigSources {
    static final String DEFAULT_MAP_NAME = "map";
    static final String DEFAULT_PROPERTIES_NAME = "properties";

    private ConfigSources() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static ConfigSource empty() {
        return EmptyConfigSourceHolder.EMPTY;
    }

    public static ConfigSource create(Config config) {
        return ConfigSources.create(ObjectNodeImpl.create(config));
    }

    public static NodeConfigSource create(ConfigNode.ObjectNode objectNode) {
        return InMemoryConfigSource.create("ObjectNode", ConfigContent.NodeContent.builder().node(objectNode).build());
    }

    public static ConfigSource create(InputStream data, String mediaType) {
        return InMemoryConfigSource.create("Readable", ConfigParser.Content.builder().data(data).mediaType(mediaType).build());
    }

    public static ConfigSource create(String content, String mediaType) {
        return InMemoryConfigSource.create("String", ConfigParser.Content.builder().data(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))).mediaType(mediaType).build());
    }

    public static MapConfigSource.Builder create(Map<String, String> map) {
        return ConfigSources.create(map, DEFAULT_MAP_NAME);
    }

    public static MapConfigSource.Builder create(Map<String, String> map, String name) {
        return (MapConfigSource.Builder)((MapConfigSource.Builder)MapConfigSource.builder().map(map)).name(name);
    }

    public static MapConfigSource.Builder create(Properties properties) {
        return ConfigSources.create(properties, DEFAULT_PROPERTIES_NAME);
    }

    public static MapConfigSource.Builder create(Properties properties, String name) {
        return (MapConfigSource.Builder)((MapConfigSource.Builder)MapConfigSource.builder().properties(properties)).name(name);
    }

    public static ConfigSource prefixed(String key, Supplier<? extends ConfigSource> sourceSupplier) {
        return PrefixedConfigSource.create(key, sourceSupplier.get());
    }

    public static SystemPropertiesConfigSource.Builder systemProperties() {
        return (SystemPropertiesConfigSource.Builder)new SystemPropertiesConfigSource.Builder().properties(System.getProperties());
    }

    public static MapConfigSource environmentVariables() {
        return new EnvironmentVariablesConfigSource();
    }

    public static ClasspathConfigSource.Builder classpath(String resource) {
        return ClasspathConfigSource.builder().resource(resource);
    }

    public static List<UrlConfigSource.Builder> classpathAll(String resource) {
        LinkedList<UrlConfigSource.Builder> result = new LinkedList<UrlConfigSource.Builder>();
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resource);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                result.add(ConfigSources.url(url));
            }
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read " + resource + " from classpath", e);
        }
        return result;
    }

    public static FileConfigSource.Builder file(String path) {
        return FileConfigSource.builder().path(Paths.get(path, new String[0]));
    }

    public static FileConfigSource.Builder file(Path path) {
        return FileConfigSource.builder().path(path);
    }

    public static DirectoryConfigSource.Builder directory(String path) {
        return DirectoryConfigSource.builder().path(Paths.get(path, new String[0]));
    }

    public static UrlConfigSource.Builder url(URL url) {
        return UrlConfigSource.builder().url(url);
    }

    static final class EmptyConfigSourceHolder {
        static final ConfigSource EMPTY = new NodeConfigSource(){

            @Override
            public String description() {
                return "Empty";
            }

            @Override
            public Optional<ConfigContent.NodeContent> load() throws ConfigException {
                return Optional.empty();
            }

            public String toString() {
                return "EmptyConfigSource";
            }

            @Override
            public boolean optional() {
                return true;
            }
        };

        private EmptyConfigSourceHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static final class SystemPropertiesConfigSource
    extends MapConfigSource {
        private SystemPropertiesConfigSource(Builder builder) {
            super(builder);
        }

        public static final class Builder
        extends MapConfigSource.MapBuilder<Builder> {
            private Builder() {
            }

            public MapConfigSource build() {
                super.name("");
                return new SystemPropertiesConfigSource(this);
            }

            @Override
            public Builder name(String sourceName) {
                return this;
            }
        }
    }

    static final class EnvironmentVariablesConfigSource
    extends MapConfigSource {
        EnvironmentVariablesConfigSource() {
            super((MapConfigSource.MapBuilder<?>)((MapConfigSource.Builder)MapConfigSource.builder().map(EnvironmentVariables.expand())).name(""));
        }
    }
}

