/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.HelidonFlavor;
import java.util.Arrays;
import java.util.Objects;

final class FeatureDescriptor {
    private final HelidonFlavor[] flavors;
    private final String name;
    private final String[] path;
    private final String description;
    private final boolean nativeSupported;
    private final String nativeDescription;
    private final boolean experimental;

    private FeatureDescriptor(Builder builder) {
        this.flavors = builder.flavors;
        this.name = builder.name;
        this.path = builder.path;
        this.description = builder.description;
        this.nativeSupported = builder.nativeSupported;
        this.nativeDescription = builder.nativeDescription;
        this.experimental = builder.experimental;
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDescriptor that = (FeatureDescriptor)o;
        return Arrays.equals((Object[])this.flavors, (Object[])that.flavors) && this.name.equals(that.name) && Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode((Object[])this.flavors);
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    HelidonFlavor[] flavors() {
        return this.flavors;
    }

    String name() {
        return this.name;
    }

    String[] path() {
        return this.path;
    }

    String description() {
        return this.description;
    }

    boolean nativeSupported() {
        return this.nativeSupported;
    }

    String nativeDescription() {
        return this.nativeDescription == null ? "" : this.nativeDescription;
    }

    String stringPath() {
        return String.join((CharSequence)"/", this.path());
    }

    boolean experimental() {
        return this.experimental;
    }

    boolean hasFlavor(HelidonFlavor expected) {
        for (HelidonFlavor flavor : this.flavors) {
            if (flavor != expected) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    static class Builder
    implements io.helidon.common.Builder<FeatureDescriptor> {
        private HelidonFlavor[] flavors = new HelidonFlavor[]{HelidonFlavor.SE, HelidonFlavor.MP};
        private String name;
        private String[] path;
        private String description = null;
        private boolean nativeSupported = true;
        private String nativeDescription = null;
        private boolean experimental;

        private Builder() {
        }

        @Override
        public FeatureDescriptor build() {
            if (this.name == null) {
                this.name = this.path[this.path.length - 1];
            }
            return new FeatureDescriptor(this);
        }

        Builder name(String name) {
            if (name == null || name.isEmpty()) {
                return this;
            }
            this.name = name;
            return this;
        }

        Builder path(String path) {
            if (path == null || path.isEmpty()) {
                return this;
            }
            this.path = new String[]{path};
            return this;
        }

        Builder description(String description) {
            if (description == null || description.isEmpty()) {
                return this;
            }
            this.description = description;
            return this;
        }

        Builder nativeSupported(boolean nativeSupported) {
            this.nativeSupported = nativeSupported;
            return this;
        }

        Builder nativeDescription(String description) {
            if (description == null || description.isEmpty()) {
                return this;
            }
            this.nativeDescription = description;
            return this;
        }

        Builder flavor(HelidonFlavor ... flavors) {
            this.flavors = flavors;
            return this;
        }

        Builder path(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("Path must have at least one element");
            }
            this.path = path;
            return this;
        }

        Builder experimental(boolean experimental) {
            this.experimental = experimental;
            return this;
        }
    }
}

