/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.KeystoreKeys;
import java.util.List;
import java.util.Optional;

@Prototype.Configured
@Prototype.Blueprint
@Prototype.CustomMethods(value=CustomMethods.class)
interface KeystoreKeysBlueprint {
    public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    public static final String DEFAULT_PRIVATE_KEY_ALIAS = "1";

    @Option.Required
    @Option.Configured(value="resource")
    public Resource keystore();

    @Option.Configured
    @Option.Default(value={"PKCS12"})
    public String type();

    @Option.Confidential
    @Option.Configured
    public Optional<char[]> passphrase();

    @Option.Configured(value="key.alias")
    public Optional<String> keyAlias();

    @Option.Configured(value="key.passphrase")
    @Option.Confidential
    public Optional<char[]> keyPassphrase();

    @Option.Configured(value="cert.alias")
    public Optional<String> certAlias();

    @Option.Configured(value="cert-chain.alias")
    public Optional<String> certChainAlias();

    @Option.Singular(value="certAlias")
    public List<String> certAliases();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean trustStore();

    public static final class CustomMethods {
        private CustomMethods() {
        }

        @Deprecated(forRemoval=true, since="4.0.0")
        @Prototype.BuilderMethod
        static void keystorePassphrase(KeystoreKeys.BuilderBase<?, ?> builder, String passphrase) {
            builder.passphrase(passphrase);
        }
    }
}

