/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.utils;

import java.io.Serializable;
import java.util.function.Consumer;

public class BidHashMap<K, V>
implements Serializable {
    private Node<K, V>[] keyNodes = new Node[this.maxSize];
    private Node<K, V>[] keyEndNodes = new Node[this.maxSize];
    private Node<K, V>[] valueNodes = new Node[this.maxSize];
    private Node<K, V>[] valueEndNodes = new Node[this.maxSize];
    private int maxSize = 32;
    private int size = 0;
    private short expansionNum = 0;

    public V put(K key, V value) {
        if (this.getV(key) != null) {
            throw new RuntimeException("\u952e\u503c\u5bf9\u5df2\u7ecf\u5b58\u5728: " + this.getV(key));
        }
        V v = this.getV(key);
        Node<K, V> n1 = new Node<K, V>(key, value);
        Node<K, V> n2 = new Node<K, V>(key, value);
        int kIndex = this.getIndex(key);
        int vIndex = this.getIndex(value);
        if (this.keyNodes[kIndex] == null) {
            this.keyNodes[kIndex] = n1;
            this.keyEndNodes[kIndex] = n1;
        } else {
            this.keyEndNodes[kIndex].next = n1;
            this.keyEndNodes[kIndex] = n1;
        }
        if (this.valueNodes[vIndex] == null) {
            this.valueNodes[vIndex] = n2;
            this.valueEndNodes[vIndex] = n2;
        } else {
            this.valueEndNodes[vIndex].next = n2;
            this.valueEndNodes[vIndex] = n2;
        }
        ++this.size;
        if (this.size >= this.maxSize) {
            this.expansion();
        }
        return value;
    }

    protected V put(Node<K, V> node) {
        return this.put(node.key, node.value);
    }

    public V removeByKey(K key) {
        V value = this.getV(key);
        if (value == null) {
            return null;
        }
        int kIndex = this.getIndex(key);
        int vIndex = this.getIndex(value);
        Node<K, V> keyNode = this.keyNodes[kIndex];
        while (keyNode != null) {
            if (keyNode.key.equals(key)) {
                if (keyNode.last == null) {
                    this.keyNodes[kIndex] = keyNode.next;
                } else {
                    keyNode.last.next = keyNode.next;
                }
            }
            keyNode = keyNode.next;
        }
        Node<K, V> valueNode = this.valueNodes[vIndex];
        while (valueNode != null) {
            if (valueNode.value.equals(value)) {
                if (valueNode.last == null) {
                    this.valueNodes[vIndex] = valueNode.next;
                } else {
                    valueNode.last.next = valueNode.next;
                }
            }
            valueNode = valueNode.next;
        }
        --this.size;
        return value;
    }

    public K removeByValue(V value) {
        K key = this.getK(value);
        if (key == null) {
            return null;
        }
        int kIndex = this.getIndex(key);
        int vIndex = this.getIndex(value);
        Node<K, V> keyNode = this.keyNodes[kIndex];
        while (keyNode != null) {
            if (keyNode.key.equals(key)) {
                if (keyNode.last == null) {
                    this.keyNodes[kIndex] = keyNode.next;
                } else {
                    keyNode.last.next = keyNode.next;
                }
            }
            keyNode = keyNode.next;
        }
        Node<K, V> valueNode = this.valueNodes[vIndex];
        while (valueNode != null) {
            if (valueNode.value.equals(value)) {
                if (valueNode.last == null) {
                    this.valueNodes[vIndex] = valueNode.next;
                } else {
                    valueNode.last.next = valueNode.next;
                }
            }
            valueNode = valueNode.next;
        }
        --this.size;
        return key;
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public short getExpansionNum() {
        return this.expansionNum;
    }

    public boolean isEmpty() {
        return this.keyNodes.length == 0;
    }

    public void clear() {
        this.maxSize = 32;
        this.size = 0;
        this.expansionNum = 0;
        this.keyNodes = new Node[this.maxSize];
        this.keyEndNodes = new Node[this.maxSize];
        this.valueNodes = new Node[this.maxSize];
        this.valueEndNodes = new Node[this.maxSize];
    }

    public V getV(K key) {
        Node<K, V> node = this.keyNodes[this.getIndex(key)];
        if (node == null) {
            return null;
        }
        if (node.key.equals(key)) {
            return node.value;
        }
        while (node.next != null) {
            if (node.next.key.equals(key)) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    public K getK(V value) {
        Node<K, V> node = this.valueNodes[this.getIndex(value)];
        if (node == null) {
            return null;
        }
        if (node.value.equals(value)) {
            return node.key;
        }
        while (node.next != null) {
            if (node.next.value.equals(value)) {
                return node.key;
            }
            node = node.next;
        }
        return null;
    }

    public Node<K, V>[] getKeyNodes() {
        return this.keyNodes;
    }

    @Deprecated
    public boolean existence(K key, V value) {
        V v = this.getV(key);
        if (v == null || v.equals(value)) {
            return false;
        }
        K k = this.getK(v);
        return k != null && !k.equals(key);
    }

    @Deprecated
    public boolean existenceByKey(K key) {
        V v = this.getV(key);
        if (v == null) {
            return false;
        }
        K k = this.getK(v);
        return k != null;
    }

    @Deprecated
    public boolean existenceByValue(V value) {
        K k = this.getK(value);
        if (k == null) {
            return false;
        }
        V v = this.getV(k);
        return v != null;
    }

    protected int getIndex(int hashCode) {
        return Math.abs(hashCode % this.maxSize);
    }

    protected int getIndex(Object o) {
        return Math.abs(o.hashCode() % this.maxSize);
    }

    protected void expansion() {
        if (this.maxSize == Integer.MAX_VALUE) {
            throw new RuntimeException("\u6570\u636e\u8d85\u51fa\u5bb9\u5668\u6700\u5927\u5bb9\u91cf");
        }
        this.maxSize *= 2;
        this.size = 0;
        Node<K, V>[] oldKeyNodes = this.keyNodes;
        this.keyNodes = new Node[this.maxSize];
        this.keyEndNodes = new Node[this.maxSize];
        this.valueNodes = new Node[this.maxSize];
        this.valueEndNodes = new Node[this.maxSize];
        this.foreach(oldKeyNodes, node -> this.put((Node<K, V>)node));
        this.expansionNum = (short)(this.expansionNum + 1);
    }

    protected void foreach(Node<K, V>[] nodes, Consumer<Node<K, V>> consumer) {
        for (Node<K, V> node : nodes) {
            while (node != null) {
                consumer.accept(node);
                node = node.next;
            }
        }
    }

    private static class Node<K, V>
    implements Serializable {
        K key;
        V value;
        Node<K, V> last;
        Node<K, V> next;

        public Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "{key=" + this.key + ",value=" + this.value + "}";
        }
    }
}

