/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.message;

import cn.messageplus.core.message.Message;
import cn.messageplus.core.message.request.PathRequest;
import cn.messageplus.core.message.response.PathResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageFactory {
    public static Map<Short, Class<? extends Message>> messageClasses = new HashMap<Short, Class<? extends Message>>();

    public static void addMessageType(short type, Class<? extends Message> messageClass) {
        messageClasses.put(type, messageClass);
    }

    public static void addMessageType(Message messageType) {
        messageClasses.put(messageType.getType(), messageType.getClass());
    }

    public static void addMessageTypes(List<Message> messageType) {
        for (Message requestType : messageType) {
            messageClasses.put(requestType.getType(), requestType.getClass());
        }
    }

    public static Class<? extends Message> getMessageType(short type) {
        return messageClasses.get(type);
    }

    public static Class<? extends Message> getMessageType(Message message) {
        return MessageFactory.getMessageType(message.getType());
    }

    public static void clientStaticInit() {
        MessageFactory.addMessageType((short)3, PathRequest.class);
        MessageFactory.addMessageType((short)53, PathResponse.class);
    }
}

