/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.manage;

import cn.messageplus.core.entity.ChatRoom;
import cn.messageplus.core.entity.Group;
import cn.messageplus.core.implement.MessageResponseHandlerImpl;
import cn.messageplus.core.manage.ChatRoomManage;
import cn.messageplus.core.manage.GroupManage;
import cn.messageplus.core.message.response.parent.MessageResponse;
import cn.messageplus.core.utils.BidHashMap;
import cn.messageplus.core.utils.exterior.SpringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManage.class);
    protected static final BidHashMap<String, Channel> uidChannelMap = new BidHashMap();
    protected static final BidHashMap<String, ByteBuf> uidBufferMap = new BidHashMap();

    public static void join(String uid, Channel channel) {
        uidChannelMap.removeByKey(uid);
        uidChannelMap.put(uid, channel);
        uidBufferMap.removeByKey(uid);
        uidBufferMap.put(uid, channel.alloc().buffer());
    }

    public static void sendByUser(String toId, MessageResponse response) {
        Channel channel = uidChannelMap.getV(toId);
        if (channel != null) {
            MessageResponseHandlerImpl mrh = SpringUtils.getBean(MessageResponseHandlerImpl.class);
            if (mrh != null) {
                log.debug("{} [{}] {} -> {}", new Object[]{response.getId(), response.getClass().getName(), response.getFromId(), response.getToId()});
                if (mrh.handlerResponse(response)) {
                    channel.writeAndFlush((Object)response);
                }
            } else {
                channel.writeAndFlush((Object)response);
            }
        }
    }

    public static void send(MessageResponse response) {
        switch (response.getToType()) {
            case 1: {
                SessionManage.sendByUser(response);
                break;
            }
            case 3: {
                SessionManage.sendByGroup(response);
                break;
            }
            case 5: {
                SessionManage.sendByChatRoom(response);
                break;
            }
        }
    }

    public static void sendByUser(MessageResponse response) {
        SessionManage.sendByUser(response.getToId(), response);
    }

    public static void sendByGroup(MessageResponse response) {
        Group group = GroupManage.getGroupById(response.getToId());
        if (group == null) {
            return;
        }
        SessionManage.sendByUser(group.getCreateUserId(), response);
        for (String userId : group.getUserIdList()) {
            SessionManage.sendByUser(userId, response);
        }
    }

    public static void sendByChatRoom(MessageResponse response) {
        ChatRoom chatRoom = ChatRoomManage.getChatRoomById(response.getToId());
        if (chatRoom == null) {
            return;
        }
        SessionManage.sendByUser(chatRoom.getCreateUserId(), response);
        for (String userId : chatRoom.getClientIdList()) {
            SessionManage.sendByUser(userId, response);
        }
    }

    public static String getUid(Channel channel) {
        return uidChannelMap.getK(channel);
    }

    public static ByteBuf getBuf(String uid) {
        return uidBufferMap.getV(uid);
    }

    public static ByteBuf getBuf(Channel channel) {
        String uid = SessionManage.getUid(channel);
        if (uid == null) {
            return null;
        }
        return uidBufferMap.getV(uid);
    }
}

