/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.handler;

import cn.dev33.satoken.stp.StpUtil;
import cn.messageplus.core.implement.MessageRequestHandlerImpl;
import cn.messageplus.core.manage.SessionManage;
import cn.messageplus.core.message.Message;
import cn.messageplus.core.message.MessageFactory;
import cn.messageplus.core.message.request.HeartbeatRequest;
import cn.messageplus.core.message.request.parent.MessageRequest;
import cn.messageplus.core.message.response.ErrorResponse;
import cn.messageplus.core.util.MpcUtil;
import cn.messageplus.core.utils.exterior.SpringUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageHandler
extends SimpleChannelInboundHandler<Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageHandler.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Message message) throws Exception {
        String suid = SessionManage.getUid(channelHandlerContext.channel());
        if (suid != null) {
            MpcUtil.setUserId(suid);
            message.setFromId(suid);
        } else {
            Object id = StpUtil.getLoginIdByToken((String)message.getHeaders().get("token"));
            if (id != null) {
                String uid = (String)id;
                SessionManage.join(uid, channelHandlerContext.channel());
                MpcUtil.setUserId(suid);
                message.setFromId(uid);
            } else {
                channelHandlerContext.writeAndFlush((Object)new ErrorResponse("Not logged in!"));
                return;
            }
        }
        MessageRequestHandlerImpl MESSAGE_REQUEST_HANDLER = SpringUtils.getBean(MessageRequestHandlerImpl.class);
        if (MessageFactory.getMessageType(message) == HeartbeatRequest.class) {
            channelHandlerContext.fireChannelRead((Object)message);
            return;
        } else if (MESSAGE_REQUEST_HANDLER != null) {
            log.debug("{} [{}] {} -> {}", new Object[]{message.getId(), message.getClass().getName(), message.getFromId(), message.getToId()});
            boolean bo = MESSAGE_REQUEST_HANDLER.handlerResponse((MessageRequest)message);
            if (!bo) return;
            channelHandlerContext.fireChannelRead((Object)message);
            return;
        } else {
            channelHandlerContext.fireChannelRead((Object)message);
        }
    }
}

