/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.entity;

import cn.messageplus.core.utils.SnowflakeIDUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public class Group {
    private String id = SnowflakeIDUtil.getGroupID();
    private String createUserId;
    private String name;
    private CopyOnWriteArrayList<String> userIdList;
    private Boolean isForbiddenSpeak = false;

    public Group(String createUserId, String groupName) {
        this.createUserId = createUserId;
        this.name = groupName;
        this.userIdList = new CopyOnWriteArrayList();
    }

    public Group(String createUserId, String groupName, CopyOnWriteArrayList<String> userIdList) {
        this(SnowflakeIDUtil.getGroupID(), createUserId, groupName, userIdList);
    }

    public Group(String id, String createUserId, String groupName, CopyOnWriteArrayList<String> userIdList) {
        this(createUserId, groupName);
        this.id = id;
        this.userIdList = userIdList;
    }

    public void join(String userId) {
        this.userIdList.add(userId);
    }

    private String getEasyStr() {
        return this.getCreateUserId() + ":" + this.getName();
    }

    private static String getEasyStr(String createUserId, String name) {
        return createUserId + ":" + name;
    }

    public static boolean isSame(Group group1, Group group2) {
        return group1.getEasyStr().equals(group2.getEasyStr());
    }

    public static boolean isSame(String createUserId, String name, Group group2) {
        return Group.getEasyStr(createUserId, name).equals(group2.getEasyStr());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCreateUserId() {
        return this.createUserId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CopyOnWriteArrayList<String> getUserIdList() {
        return this.userIdList;
    }

    @Generated
    public Boolean getIsForbiddenSpeak() {
        return this.isForbiddenSpeak;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUserIdList(CopyOnWriteArrayList<String> userIdList) {
        this.userIdList = userIdList;
    }

    @Generated
    public void setIsForbiddenSpeak(Boolean isForbiddenSpeak) {
        this.isForbiddenSpeak = isForbiddenSpeak;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isForbiddenSpeak = this.getIsForbiddenSpeak();
        Boolean other$isForbiddenSpeak = other.getIsForbiddenSpeak();
        if (this$isForbiddenSpeak == null ? other$isForbiddenSpeak != null : !((Object)this$isForbiddenSpeak).equals(other$isForbiddenSpeak)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$createUserId = this.getCreateUserId();
        String other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !this$createUserId.equals(other$createUserId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CopyOnWriteArrayList<String> this$userIdList = this.getUserIdList();
        CopyOnWriteArrayList<String> other$userIdList = other.getUserIdList();
        return !(this$userIdList == null ? other$userIdList != null : !((Object)this$userIdList).equals(other$userIdList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Group;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isForbiddenSpeak = this.getIsForbiddenSpeak();
        result = result * 59 + ($isForbiddenSpeak == null ? 43 : ((Object)$isForbiddenSpeak).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : $createUserId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CopyOnWriteArrayList<String> $userIdList = this.getUserIdList();
        result = result * 59 + ($userIdList == null ? 43 : ((Object)$userIdList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Group(id=" + this.getId() + ", createUserId=" + this.getCreateUserId() + ", name=" + this.getName() + ", userIdList=" + this.getUserIdList() + ", isForbiddenSpeak=" + this.getIsForbiddenSpeak() + ")";
    }
}

