/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.entity;

import cn.messageplus.core.utils.SnowflakeIDUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ChatRoom
implements Serializable {
    private String id;
    private String createUserId;
    private String name;
    private int maxUserNum = 0;
    private int allUserNum = 0;
    private int userNum = 0;
    private Map<String, Integer> clientIdMap = new ConcurrentHashMap<String, Integer>();
    private long thumbsUpNum = 0L;
    private Timestamp openingTime = new Timestamp(System.currentTimeMillis());
    private Timestamp offTime;
    private Boolean isForbiddenSpeak = false;

    public ChatRoom(String createUserId, String chatRoomName) {
        this.id = SnowflakeIDUtil.getID();
        this.createUserId = createUserId;
        this.name = chatRoomName;
    }

    public ChatRoom(String id, String createUserId, String chatRoomName) {
        this.id = id;
        this.createUserId = createUserId;
        this.name = chatRoomName;
    }

    public int joinChatRoom(String userId) {
        if (userId == null || userId.isEmpty()) {
            return -1;
        }
        Integer i = this.clientIdMap.get(userId);
        if (i == null) {
            this.clientIdMap.put(userId, 1);
            this.maxUserNum = this.clientIdMap.size() > this.maxUserNum ? this.clientIdMap.size() : this.maxUserNum;
        }
        return this.clientIdMap.size();
    }

    public int quitChatRoom(String userId) {
        if (userId == null || userId.isEmpty()) {
            return -1;
        }
        this.clientIdMap.remove(userId);
        return this.clientIdMap.size();
    }

    public List<String> getClientIdList() {
        return new ArrayList<String>(this.clientIdMap.keySet());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCreateUserId() {
        return this.createUserId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getMaxUserNum() {
        return this.maxUserNum;
    }

    @Generated
    public int getAllUserNum() {
        return this.allUserNum;
    }

    @Generated
    public int getUserNum() {
        return this.userNum;
    }

    @Generated
    public Map<String, Integer> getClientIdMap() {
        return this.clientIdMap;
    }

    @Generated
    public long getThumbsUpNum() {
        return this.thumbsUpNum;
    }

    @Generated
    public Timestamp getOpeningTime() {
        return this.openingTime;
    }

    @Generated
    public Timestamp getOffTime() {
        return this.offTime;
    }

    @Generated
    public Boolean getIsForbiddenSpeak() {
        return this.isForbiddenSpeak;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMaxUserNum(int maxUserNum) {
        this.maxUserNum = maxUserNum;
    }

    @Generated
    public void setAllUserNum(int allUserNum) {
        this.allUserNum = allUserNum;
    }

    @Generated
    public void setUserNum(int userNum) {
        this.userNum = userNum;
    }

    @Generated
    public void setClientIdMap(Map<String, Integer> clientIdMap) {
        this.clientIdMap = clientIdMap;
    }

    @Generated
    public void setThumbsUpNum(long thumbsUpNum) {
        this.thumbsUpNum = thumbsUpNum;
    }

    @Generated
    public void setOpeningTime(Timestamp openingTime) {
        this.openingTime = openingTime;
    }

    @Generated
    public void setOffTime(Timestamp offTime) {
        this.offTime = offTime;
    }

    @Generated
    public void setIsForbiddenSpeak(Boolean isForbiddenSpeak) {
        this.isForbiddenSpeak = isForbiddenSpeak;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRoom)) {
            return false;
        }
        ChatRoom other = (ChatRoom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxUserNum() != other.getMaxUserNum()) {
            return false;
        }
        if (this.getAllUserNum() != other.getAllUserNum()) {
            return false;
        }
        if (this.getUserNum() != other.getUserNum()) {
            return false;
        }
        if (this.getThumbsUpNum() != other.getThumbsUpNum()) {
            return false;
        }
        Boolean this$isForbiddenSpeak = this.getIsForbiddenSpeak();
        Boolean other$isForbiddenSpeak = other.getIsForbiddenSpeak();
        if (this$isForbiddenSpeak == null ? other$isForbiddenSpeak != null : !((Object)this$isForbiddenSpeak).equals(other$isForbiddenSpeak)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$createUserId = this.getCreateUserId();
        String other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !this$createUserId.equals(other$createUserId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Integer> this$clientIdMap = this.getClientIdMap();
        Map<String, Integer> other$clientIdMap = other.getClientIdMap();
        if (this$clientIdMap == null ? other$clientIdMap != null : !((Object)this$clientIdMap).equals(other$clientIdMap)) {
            return false;
        }
        Timestamp this$openingTime = this.getOpeningTime();
        Timestamp other$openingTime = other.getOpeningTime();
        if (this$openingTime == null ? other$openingTime != null : !((Object)this$openingTime).equals(other$openingTime)) {
            return false;
        }
        Timestamp this$offTime = this.getOffTime();
        Timestamp other$offTime = other.getOffTime();
        return !(this$offTime == null ? other$offTime != null : !((Object)this$offTime).equals(other$offTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatRoom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxUserNum();
        result = result * 59 + this.getAllUserNum();
        result = result * 59 + this.getUserNum();
        long $thumbsUpNum = this.getThumbsUpNum();
        result = result * 59 + (int)($thumbsUpNum >>> 32 ^ $thumbsUpNum);
        Boolean $isForbiddenSpeak = this.getIsForbiddenSpeak();
        result = result * 59 + ($isForbiddenSpeak == null ? 43 : ((Object)$isForbiddenSpeak).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : $createUserId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Integer> $clientIdMap = this.getClientIdMap();
        result = result * 59 + ($clientIdMap == null ? 43 : ((Object)$clientIdMap).hashCode());
        Timestamp $openingTime = this.getOpeningTime();
        result = result * 59 + ($openingTime == null ? 43 : ((Object)$openingTime).hashCode());
        Timestamp $offTime = this.getOffTime();
        result = result * 59 + ($offTime == null ? 43 : ((Object)$offTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatRoom(id=" + this.getId() + ", createUserId=" + this.getCreateUserId() + ", name=" + this.getName() + ", maxUserNum=" + this.getMaxUserNum() + ", allUserNum=" + this.getAllUserNum() + ", userNum=" + this.getUserNum() + ", clientIdMap=" + this.getClientIdMap() + ", thumbsUpNum=" + this.getThumbsUpNum() + ", openingTime=" + this.getOpeningTime() + ", offTime=" + this.getOffTime() + ", isForbiddenSpeak=" + this.getIsForbiddenSpeak() + ")";
    }

    @Generated
    public ChatRoom() {
    }
}

