/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.codec;

import cn.messageplus.core.message.Message;
import cn.messageplus.core.message.MessageFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

@ChannelHandler.Sharable
public class MessageCodec
extends MessageToMessageCodec<ByteBuf, Message> {
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        ByteBuf buffer = ctx.alloc().buffer();
        buffer.writeByte((int)msg.getVersion());
        buffer.writeShort((int)msg.getType());
        byte[] jsonBytes = JSON.toJSONBytes((Object)msg);
        buffer.writeInt(jsonBytes.length);
        buffer.writeBytes(jsonBytes);
        out.add(buffer);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        while (msg.readableBytes() > 0) {
            byte version = msg.readByte();
            short type = msg.readShort();
            int length = msg.readInt();
            byte[] content = new byte[length];
            msg.readBytes(content, 0, length);
            Object message = JSON.parseObject((byte[])content, MessageFactory.getMessageType(type), (Feature[])new Feature[0]);
            out.add(message);
        }
    }
}

