/*
 * Decompiled with CFR 0.152.
 */
package cn.messageplus.core.codec;

import cn.messageplus.core.message.Message;
import cn.messageplus.core.message.MessageFactory;
import cn.messageplus.core.message.request.parent.MessageSliceRequest;
import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BinaryWebSocketCodec
extends MessageToMessageCodec<BinaryWebSocketFrame, Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryWebSocketCodec.class);
    protected static final int maxSliceLength = 60000;

    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
    }

    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame frame, List<Object> out) throws Exception {
        ByteBuf content = frame.content();
        byte version = content.readByte();
        short type = content.readShort();
        int length = content.readInt();
        byte[] bytes = new byte[length];
        content.readBytes(bytes);
        Class<? extends Message> requestType = MessageFactory.getMessageType(type);
        Message messageRequest = (Message)JSON.parseObject((String)new String(bytes, StandardCharsets.UTF_8), MessageFactory.getMessageType(type));
        if (requestType.getSuperclass() == MessageSliceRequest.class) {
            MessageSliceRequest request = (MessageSliceRequest)messageRequest;
            int audioLength = content.readInt();
            request.setLength(audioLength);
            if (request.getCurrentIndex() < request.getSliceNum()) {
                byte[] audioBytes = new byte[60000];
                content.readBytes(audioBytes);
                request.setBytes(audioBytes);
            } else {
                byte[] audioBytes = new byte[audioLength - (request.getSliceNum() - 1) * 60000];
                content.readBytes(audioBytes);
                request.setBytes(audioBytes);
            }
        }
        out.add(messageRequest);
    }
}

